# Glasgow Maintainers Coordination Meeting

Date: 2023-07-15

Attendees:
- @whitequark
- @attie
- @esden
- @wanda (aka @mwk)
- @electronic_eel

## Agenda

### 1. Teach Glasgow to use YoWASP if installed

Assignee: @attie

- Some progress, initial PoC operational
- Makes sense to incorproate some of requirements from "_Teach Glasgow to cache applets_"
- @attie & @whitequark to discuss further


### 2. Bridging IRC, Matrix, Discord

Assignee: @whitequark

- Setting up a double-puppet bridge between the three
- @esden to remove current IRC bridge when ready (for both `#glasgow` and `#amaranth`)


### 3. Finish migrating off `amaranth.compat`

Assignee: @wanda

- Complete!


### 4. Support Python 3.11

Assignee: @whitequark / @wanda

- Tests pass, some applets verified
- Complete!


### 5. Serial Numbers

Assignee: @esden

- Specification revised, and shared: [Glasgow Sticker Spec](https://gist.github.com/esden/864341e02b2affe049367aa62c719606/ca03bccebaab9bf6172537fb0468a070e13e227f)
- @esden to share gist with details in `#glasgow`


### 6. USB Manufacturer String

Assignee: @whitequark

- Add support for a custom USB Manufacturer string (in support of 1BitSquared)
- See [`#347`](https://github.com/GlasgowEmbedded/glasgow/issues/347)


## Outstanding Topics

### 7. Teach Glasgow to cache applets

Assignee: nobody

- Depends on `1`, @attie to investigate once complete
- Required in part because YoWASP is slower
- Use [`yowasp_runtime/__init__.py`](https://github.com/YoWASP/runtime/blob/develop/yowasp_runtime/__init__.py#L84-L103) as a template / reference
- Cache key is as hash of `design + yosys_ver + nextpnr_ver + icepack_ver + ecppack_ver`


### 8. Documentation

Assignee: @attie & @whitequark

- @attie in progress on "_Getting Started_" user documentation & troubleshooting guide
- @whitequark to write a document outlining acceptable page, commit message & code style
- Reference [`amaranth` Github workflow](https://github.com/amaranth-lang/amaranth/blob/main/.github/workflows/main.yaml#L56-L135)


### 9. Out of Tree Applets

Assignee: nobody

- No official support planned "_now_", but we need to start building out infrastructure
- Split `glasgow-contrib` applets into their own package / repo, to test machinery


### 10. Rewrite Applet API

Assignee: nobody

- Currently blocked on Amaranth, improvements expected in coming months... can start before
- Much of Glasgow framework may move to Amaranth
- Either revise `bitfield` to use variable annotations, or deprecate in favor of `amaranth.lib.data`
- Aim for new CLI, and ensure support for GUI in the future
- Drop `argparse`, and make applets declarative (ideally cache metadata for `--help` to improve startup)
- @whitequark has further ideas, will expand in another meeting


### 11. Replace `bitarray`

Assignee: nobody

- PR attempt at resolving this [#265](https://github.com/GlasgowEmbedded/glasgow/pull/265) (closed due to quality)
- Large issue, do not attempt without discussing


### 6. XC9500XL - Migrade from `.bit` to `.jed`

Assignee: @whitequark

- [PR #288](https://github.com/GlasgowEmbedded/glasgow/pull/288)
