# Glasgow Maintainers Coordination Meeting

Date: 2023-07-01

Attendees:
- @whitequark
- @attie
- @esden
- @mwk

Apologies:
- @electronic_eel


## Agenda

### 1. Teach Glasgow to use YoWASP if installed

Assignee: @attie

- Use [`amaranth/_toolchain/yosys.py`](https://github.com/amaranth-lang/amaranth/blob/main/amaranth/_toolchain/yosys.py) as an example, and extend/port to Glasgow
- @whitequark to guide as necessary


### 2. Teach Glasgow to cache applets

Assignee: nobody

- Depends on `1`, @attie to investigate once complete
- Required in part because YoWASP is slower
- Use [`yowasp_runtime/__init__.py`](https://github.com/YoWASP/runtime/blob/develop/yowasp_runtime/__init__.py#L84-L103) as a template / reference
- Cache key is as hash of `design + yosys_ver + nextpnr_ver + icepack_ver + ecppack_ver`


### 3. Finish migrating off `amaranth.compat`

Assignee: @mwk (? - waiting for ack/nak)

#### `memory.floppy`

Assignee: @mwk

- WIP

#### `interface.spi_controller`

Assignee: @mwk

- [PR #308](https://github.com/GlasgowEmbedded/glasgow/pull/308)
- Merged


### 4. Documentation

Assignee: @attie & @whitequark

- @attie in progress on "_Getting Started_" user documentation & troubleshooting guide
- @whitequark to write a document outlining acceptable page, commit message & code style
- Reference [`amaranth` Github workflow](https://github.com/amaranth-lang/amaranth/blob/main/.github/workflows/main.yaml#L56-L135)


### 5. Support Python 3.11

Assignee: @whitequark

- `@asyncio.coroutine` is deprecated and removed from Python 3.11
- [Issue #297](https://github.com/GlasgowEmbedded/glasgow/issues/297)


### 6. Out of Tree Applets

Assignee: nobody

- No official support planned "_now_", but we need to start building out infrastructure
- Split `glasgow-contrib` applets into their own package / repo, to test machinery


### 7. Rewrite Applet API

Assignee: nobody

- Currently blocked on Amaranth, improvements expected in coming months... can start before
- Much of Glasgow framework may move to Amaranth
- Either revise `bitfield` to use variable annotations, or deprecate in favor of `amaranth.lib.data`
- Aim for new CLI, and ensure support for GUI in the future
- Drop `argparse`, and make applets declarative (ideally cache metadata for `--help` to improve startup)
- @whitequark has further ideas, will expand in another meeting


### 8. Replace `bitarray`

Assignee: nobody

- PR attempt at resolving this [#265](https://github.com/GlasgowEmbedded/glasgow/pull/265) (closed due to quality)
- Large issue, do not attempt without discussing


### 9. XC9500XL - Migrade from `.bit` to `.jed`

Assignee: @whitequark

- [PR #288](https://github.com/GlasgowEmbedded/glasgow/pull/288)


### 10. Serial Numbers

Assignee: @esden

- Sticker format sample shown, content to be discussed and finalised later... largely 1b2's decision
- @esden to share gist with details in `#glasgow`
