// Code generated by go-swagger; DO NOT EDIT.

//
// Copyright 2021 The Sigstore Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package entries

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/sigstore/rekor/pkg/generated/models"
)

// SearchLogQueryOKCode is the HTTP code returned for type SearchLogQueryOK
const SearchLogQueryOKCode int = 200

/*
SearchLogQueryOK Returns zero or more entries from the transparency log, according to how many were included in request query

swagger:response searchLogQueryOK
*/
type SearchLogQueryOK struct {

	/*
	  In: Body
	*/
	Payload []models.LogEntry `json:"body,omitempty"`
}

// NewSearchLogQueryOK creates SearchLogQueryOK with default headers values
func NewSearchLogQueryOK() *SearchLogQueryOK {

	return &SearchLogQueryOK{}
}

// WithPayload adds the payload to the search log query o k response
func (o *SearchLogQueryOK) WithPayload(payload []models.LogEntry) *SearchLogQueryOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the search log query o k response
func (o *SearchLogQueryOK) SetPayload(payload []models.LogEntry) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *SearchLogQueryOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = make([]models.LogEntry, 0, 50)
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// SearchLogQueryBadRequestCode is the HTTP code returned for type SearchLogQueryBadRequest
const SearchLogQueryBadRequestCode int = 400

/*
SearchLogQueryBadRequest The content supplied to the server was invalid

swagger:response searchLogQueryBadRequest
*/
type SearchLogQueryBadRequest struct {

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewSearchLogQueryBadRequest creates SearchLogQueryBadRequest with default headers values
func NewSearchLogQueryBadRequest() *SearchLogQueryBadRequest {

	return &SearchLogQueryBadRequest{}
}

// WithPayload adds the payload to the search log query bad request response
func (o *SearchLogQueryBadRequest) WithPayload(payload *models.Error) *SearchLogQueryBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the search log query bad request response
func (o *SearchLogQueryBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *SearchLogQueryBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
SearchLogQueryDefault There was an internal error in the server while processing the request

swagger:response searchLogQueryDefault
*/
type SearchLogQueryDefault struct {
	_statusCode int

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewSearchLogQueryDefault creates SearchLogQueryDefault with default headers values
func NewSearchLogQueryDefault(code int) *SearchLogQueryDefault {
	if code <= 0 {
		code = 500
	}

	return &SearchLogQueryDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the search log query default response
func (o *SearchLogQueryDefault) WithStatusCode(code int) *SearchLogQueryDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the search log query default response
func (o *SearchLogQueryDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithPayload adds the payload to the search log query default response
func (o *SearchLogQueryDefault) WithPayload(payload *models.Error) *SearchLogQueryDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the search log query default response
func (o *SearchLogQueryDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *SearchLogQueryDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
