// Copyright (c) 2016, 2018, 2021, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Cloud Advisor API
//
// APIs for managing Cloud Advisor. Cloud Advisor provides recommendations that help you maximize cost savings and improve the security posture of your tenancy.
//

package optimizer

// StatusEnum Enum with underlying type: string
type StatusEnum string

// Set of constants representing the allowable values for StatusEnum
const (
	StatusPending     StatusEnum = "PENDING"
	StatusDismissed   StatusEnum = "DISMISSED"
	StatusPostponed   StatusEnum = "POSTPONED"
	StatusImplemented StatusEnum = "IMPLEMENTED"
)

var mappingStatus = map[string]StatusEnum{
	"PENDING":     StatusPending,
	"DISMISSED":   StatusDismissed,
	"POSTPONED":   StatusPostponed,
	"IMPLEMENTED": StatusImplemented,
}

// GetStatusEnumValues Enumerates the set of values for StatusEnum
func GetStatusEnumValues() []StatusEnum {
	values := make([]StatusEnum, 0)
	for _, v := range mappingStatus {
		values = append(values, v)
	}
	return values
}
