// Copyright (c) 2016, 2018, 2021, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

package cloudguard

import (
	"github.com/oracle/oci-go-sdk/v32/common"
	"net/http"
)

// ListDetectorsRequest wrapper for the ListDetectors operation
//
// See also
//
// Click https://docs.cloud.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/cloudguard/ListDetectors.go.html to see an example of how to use ListDetectorsRequest.
type ListDetectorsRequest struct {

	// The ID of the compartment in which to list resources.
	CompartmentId *string `mandatory:"true" contributesTo:"query" name:"compartmentId"`

	// The maximum number of items to return.
	Limit *int `mandatory:"false" contributesTo:"query" name:"limit"`

	// The field life cycle state. Only one state can be provided. Default value for state is active. If no value is specified state is active.
	LifecycleState ListDetectorsLifecycleStateEnum `mandatory:"false" contributesTo:"query" name:"lifecycleState" omitEmpty:"true"`

	// The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.
	Page *string `mandatory:"false" contributesTo:"query" name:"page"`

	// The sort order to use, either 'asc' or 'desc'.
	SortOrder ListDetectorsSortOrderEnum `mandatory:"false" contributesTo:"query" name:"sortOrder" omitEmpty:"true"`

	// The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending. If no value is specified timeCreated is default.
	SortBy ListDetectorsSortByEnum `mandatory:"false" contributesTo:"query" name:"sortBy" omitEmpty:"true"`

	// The client request ID for tracing.
	OpcRequestId *string `mandatory:"false" contributesTo:"header" name:"opc-request-id"`

	// Metadata about the request. This information will not be transmitted to the service, but
	// represents information that the SDK will consume to drive retry behavior.
	RequestMetadata common.RequestMetadata
}

func (request ListDetectorsRequest) String() string {
	return common.PointerString(request)
}

// HTTPRequest implements the OCIRequest interface
func (request ListDetectorsRequest) HTTPRequest(method, path string) (http.Request, error) {
	return common.MakeDefaultHTTPRequestWithTaggedStruct(method, path, request)
}

// RetryPolicy implements the OCIRetryableRequest interface. This retrieves the specified retry policy.
func (request ListDetectorsRequest) RetryPolicy() *common.RetryPolicy {
	return request.RequestMetadata.RetryPolicy
}

// ListDetectorsResponse wrapper for the ListDetectors operation
type ListDetectorsResponse struct {

	// The underlying http response
	RawResponse *http.Response

	// A list of DetectorCollection instances
	DetectorCollection `presentIn:"body"`

	// Unique Oracle-assigned identifier for the request. If you need to contact
	// Oracle about a particular request, please provide the request ID.
	OpcRequestId *string `presentIn:"header" name:"opc-request-id"`

	// For pagination of a list of items. When paging through a list, if this header appears in the response,
	// then a partial list might have been returned. Include this value as the `page` parameter for the
	// subsequent GET request to get the next batch of items.
	OpcNextPage *string `presentIn:"header" name:"opc-next-page"`
}

func (response ListDetectorsResponse) String() string {
	return common.PointerString(response)
}

// HTTPResponse implements the OCIResponse interface
func (response ListDetectorsResponse) HTTPResponse() *http.Response {
	return response.RawResponse
}

// ListDetectorsLifecycleStateEnum Enum with underlying type: string
type ListDetectorsLifecycleStateEnum string

// Set of constants representing the allowable values for ListDetectorsLifecycleStateEnum
const (
	ListDetectorsLifecycleStateCreating ListDetectorsLifecycleStateEnum = "CREATING"
	ListDetectorsLifecycleStateUpdating ListDetectorsLifecycleStateEnum = "UPDATING"
	ListDetectorsLifecycleStateActive   ListDetectorsLifecycleStateEnum = "ACTIVE"
	ListDetectorsLifecycleStateInactive ListDetectorsLifecycleStateEnum = "INACTIVE"
	ListDetectorsLifecycleStateDeleting ListDetectorsLifecycleStateEnum = "DELETING"
	ListDetectorsLifecycleStateDeleted  ListDetectorsLifecycleStateEnum = "DELETED"
	ListDetectorsLifecycleStateFailed   ListDetectorsLifecycleStateEnum = "FAILED"
)

var mappingListDetectorsLifecycleState = map[string]ListDetectorsLifecycleStateEnum{
	"CREATING": ListDetectorsLifecycleStateCreating,
	"UPDATING": ListDetectorsLifecycleStateUpdating,
	"ACTIVE":   ListDetectorsLifecycleStateActive,
	"INACTIVE": ListDetectorsLifecycleStateInactive,
	"DELETING": ListDetectorsLifecycleStateDeleting,
	"DELETED":  ListDetectorsLifecycleStateDeleted,
	"FAILED":   ListDetectorsLifecycleStateFailed,
}

// GetListDetectorsLifecycleStateEnumValues Enumerates the set of values for ListDetectorsLifecycleStateEnum
func GetListDetectorsLifecycleStateEnumValues() []ListDetectorsLifecycleStateEnum {
	values := make([]ListDetectorsLifecycleStateEnum, 0)
	for _, v := range mappingListDetectorsLifecycleState {
		values = append(values, v)
	}
	return values
}

// ListDetectorsSortOrderEnum Enum with underlying type: string
type ListDetectorsSortOrderEnum string

// Set of constants representing the allowable values for ListDetectorsSortOrderEnum
const (
	ListDetectorsSortOrderAsc  ListDetectorsSortOrderEnum = "ASC"
	ListDetectorsSortOrderDesc ListDetectorsSortOrderEnum = "DESC"
)

var mappingListDetectorsSortOrder = map[string]ListDetectorsSortOrderEnum{
	"ASC":  ListDetectorsSortOrderAsc,
	"DESC": ListDetectorsSortOrderDesc,
}

// GetListDetectorsSortOrderEnumValues Enumerates the set of values for ListDetectorsSortOrderEnum
func GetListDetectorsSortOrderEnumValues() []ListDetectorsSortOrderEnum {
	values := make([]ListDetectorsSortOrderEnum, 0)
	for _, v := range mappingListDetectorsSortOrder {
		values = append(values, v)
	}
	return values
}

// ListDetectorsSortByEnum Enum with underlying type: string
type ListDetectorsSortByEnum string

// Set of constants representing the allowable values for ListDetectorsSortByEnum
const (
	ListDetectorsSortByTimecreated ListDetectorsSortByEnum = "timeCreated"
	ListDetectorsSortByDisplayname ListDetectorsSortByEnum = "displayName"
)

var mappingListDetectorsSortBy = map[string]ListDetectorsSortByEnum{
	"timeCreated": ListDetectorsSortByTimecreated,
	"displayName": ListDetectorsSortByDisplayname,
}

// GetListDetectorsSortByEnumValues Enumerates the set of values for ListDetectorsSortByEnum
func GetListDetectorsSortByEnumValues() []ListDetectorsSortByEnum {
	values := make([]ListDetectorsSortByEnum, 0)
	for _, v := range mappingListDetectorsSortBy {
		values = append(values, v)
	}
	return values
}
