/*
 * CLOUD API
 *
 * IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.
 *
 * API version: 6.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionoscloud

import (
	"encoding/json"
)

// GroupMembers struct for GroupMembers
type GroupMembers struct {
	// URL to the object representation (absolute path).
	Href *string `json:"href,omitempty"`
	// The resource's unique identifier.
	Id *string `json:"id,omitempty"`
	// Array of items in the collection.
	Items *[]User `json:"items,omitempty"`
	// The type of object that has been created.
	Type *Type `json:"type,omitempty"`
}

// NewGroupMembers instantiates a new GroupMembers object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewGroupMembers() *GroupMembers {
	this := GroupMembers{}

	return &this
}

// NewGroupMembersWithDefaults instantiates a new GroupMembers object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewGroupMembersWithDefaults() *GroupMembers {
	this := GroupMembers{}
	return &this
}

// GetHref returns the Href field value
// If the value is explicit nil, nil is returned
func (o *GroupMembers) GetHref() *string {
	if o == nil {
		return nil
	}

	return o.Href

}

// GetHrefOk returns a tuple with the Href field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *GroupMembers) GetHrefOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.Href, true
}

// SetHref sets field value
func (o *GroupMembers) SetHref(v string) {

	o.Href = &v

}

// HasHref returns a boolean if a field has been set.
func (o *GroupMembers) HasHref() bool {
	if o != nil && o.Href != nil {
		return true
	}

	return false
}

// GetId returns the Id field value
// If the value is explicit nil, nil is returned
func (o *GroupMembers) GetId() *string {
	if o == nil {
		return nil
	}

	return o.Id

}

// GetIdOk returns a tuple with the Id field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *GroupMembers) GetIdOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.Id, true
}

// SetId sets field value
func (o *GroupMembers) SetId(v string) {

	o.Id = &v

}

// HasId returns a boolean if a field has been set.
func (o *GroupMembers) HasId() bool {
	if o != nil && o.Id != nil {
		return true
	}

	return false
}

// GetItems returns the Items field value
// If the value is explicit nil, nil is returned
func (o *GroupMembers) GetItems() *[]User {
	if o == nil {
		return nil
	}

	return o.Items

}

// GetItemsOk returns a tuple with the Items field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *GroupMembers) GetItemsOk() (*[]User, bool) {
	if o == nil {
		return nil, false
	}

	return o.Items, true
}

// SetItems sets field value
func (o *GroupMembers) SetItems(v []User) {

	o.Items = &v

}

// HasItems returns a boolean if a field has been set.
func (o *GroupMembers) HasItems() bool {
	if o != nil && o.Items != nil {
		return true
	}

	return false
}

// GetType returns the Type field value
// If the value is explicit nil, nil is returned
func (o *GroupMembers) GetType() *Type {
	if o == nil {
		return nil
	}

	return o.Type

}

// GetTypeOk returns a tuple with the Type field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *GroupMembers) GetTypeOk() (*Type, bool) {
	if o == nil {
		return nil, false
	}

	return o.Type, true
}

// SetType sets field value
func (o *GroupMembers) SetType(v Type) {

	o.Type = &v

}

// HasType returns a boolean if a field has been set.
func (o *GroupMembers) HasType() bool {
	if o != nil && o.Type != nil {
		return true
	}

	return false
}

func (o GroupMembers) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Href != nil {
		toSerialize["href"] = o.Href
	}

	if o.Id != nil {
		toSerialize["id"] = o.Id
	}

	if o.Items != nil {
		toSerialize["items"] = o.Items
	}

	if o.Type != nil {
		toSerialize["type"] = o.Type
	}

	return json.Marshal(toSerialize)
}

type NullableGroupMembers struct {
	value *GroupMembers
	isSet bool
}

func (v NullableGroupMembers) Get() *GroupMembers {
	return v.value
}

func (v *NullableGroupMembers) Set(val *GroupMembers) {
	v.value = val
	v.isSet = true
}

func (v NullableGroupMembers) IsSet() bool {
	return v.isSet
}

func (v *NullableGroupMembers) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableGroupMembers(val *GroupMembers) *NullableGroupMembers {
	return &NullableGroupMembers{value: val, isSet: true}
}

func (v NullableGroupMembers) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableGroupMembers) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
