// Code generated by go-swagger; DO NOT EDIT.

package vault_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-service/stable/2020-11-25/models"
)

// UnsealReader is a Reader for the Unseal structure.
type UnsealReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UnsealReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUnsealOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewUnsealDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewUnsealOK creates a UnsealOK with default headers values
func NewUnsealOK() *UnsealOK {
	return &UnsealOK{}
}

/*
UnsealOK describes a response with status code 200, with default header values.

A successful response.
*/
type UnsealOK struct {
	Payload *models.HashicorpCloudVault20201125UnsealResponse
}

// IsSuccess returns true when this unseal o k response has a 2xx status code
func (o *UnsealOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this unseal o k response has a 3xx status code
func (o *UnsealOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this unseal o k response has a 4xx status code
func (o *UnsealOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this unseal o k response has a 5xx status code
func (o *UnsealOK) IsServerError() bool {
	return false
}

// IsCode returns true when this unseal o k response a status code equal to that given
func (o *UnsealOK) IsCode(code int) bool {
	return code == 200
}

func (o *UnsealOK) Error() string {
	return fmt.Sprintf("[POST /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/unseal][%d] unsealOK  %+v", 200, o.Payload)
}

func (o *UnsealOK) String() string {
	return fmt.Sprintf("[POST /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/unseal][%d] unsealOK  %+v", 200, o.Payload)
}

func (o *UnsealOK) GetPayload() *models.HashicorpCloudVault20201125UnsealResponse {
	return o.Payload
}

func (o *UnsealOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudVault20201125UnsealResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUnsealDefault creates a UnsealDefault with default headers values
func NewUnsealDefault(code int) *UnsealDefault {
	return &UnsealDefault{
		_statusCode: code,
	}
}

/*
UnsealDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type UnsealDefault struct {
	_statusCode int

	Payload *cloud.GrpcGatewayRuntimeError
}

// Code gets the status code for the unseal default response
func (o *UnsealDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this unseal default response has a 2xx status code
func (o *UnsealDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this unseal default response has a 3xx status code
func (o *UnsealDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this unseal default response has a 4xx status code
func (o *UnsealDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this unseal default response has a 5xx status code
func (o *UnsealDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this unseal default response a status code equal to that given
func (o *UnsealDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *UnsealDefault) Error() string {
	return fmt.Sprintf("[POST /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/unseal][%d] Unseal default  %+v", o._statusCode, o.Payload)
}

func (o *UnsealDefault) String() string {
	return fmt.Sprintf("[POST /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/unseal][%d] Unseal default  %+v", o._statusCode, o.Payload)
}

func (o *UnsealDefault) GetPayload() *cloud.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *UnsealDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
