// Code generated by go-swagger; DO NOT EDIT.

package version_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewDeleteVersionParams creates a new DeleteVersionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDeleteVersionParams() *DeleteVersionParams {
	return &DeleteVersionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDeleteVersionParamsWithTimeout creates a new DeleteVersionParams object
// with the ability to set a timeout on a request.
func NewDeleteVersionParamsWithTimeout(timeout time.Duration) *DeleteVersionParams {
	return &DeleteVersionParams{
		timeout: timeout,
	}
}

// NewDeleteVersionParamsWithContext creates a new DeleteVersionParams object
// with the ability to set a context for a request.
func NewDeleteVersionParamsWithContext(ctx context.Context) *DeleteVersionParams {
	return &DeleteVersionParams{
		Context: ctx,
	}
}

// NewDeleteVersionParamsWithHTTPClient creates a new DeleteVersionParams object
// with the ability to set a custom HTTPClient for a request.
func NewDeleteVersionParamsWithHTTPClient(client *http.Client) *DeleteVersionParams {
	return &DeleteVersionParams{
		HTTPClient: client,
	}
}

/*
DeleteVersionParams contains all the parameters to send to the API endpoint

	for the delete version operation.

	Typically these are written to a http.Request.
*/
type DeleteVersionParams struct {

	/* Box.

	     The name segment of the Box. As an example, this field would represent the
	"vagrant" in "hashicorp/vagrant".
	*/
	Box string

	/* Registry.

	     The Registry segment of the Box. As an example, this field would represent
	the "hashicorp" in "hashicorp/vagrant".
	*/
	Registry string

	/* Version.

	   The name of the Version to delete.
	*/
	Version string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the delete version params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeleteVersionParams) WithDefaults() *DeleteVersionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the delete version params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeleteVersionParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the delete version params
func (o *DeleteVersionParams) WithTimeout(timeout time.Duration) *DeleteVersionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the delete version params
func (o *DeleteVersionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the delete version params
func (o *DeleteVersionParams) WithContext(ctx context.Context) *DeleteVersionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the delete version params
func (o *DeleteVersionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the delete version params
func (o *DeleteVersionParams) WithHTTPClient(client *http.Client) *DeleteVersionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the delete version params
func (o *DeleteVersionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBox adds the box to the delete version params
func (o *DeleteVersionParams) WithBox(box string) *DeleteVersionParams {
	o.SetBox(box)
	return o
}

// SetBox adds the box to the delete version params
func (o *DeleteVersionParams) SetBox(box string) {
	o.Box = box
}

// WithRegistry adds the registry to the delete version params
func (o *DeleteVersionParams) WithRegistry(registry string) *DeleteVersionParams {
	o.SetRegistry(registry)
	return o
}

// SetRegistry adds the registry to the delete version params
func (o *DeleteVersionParams) SetRegistry(registry string) {
	o.Registry = registry
}

// WithVersion adds the version to the delete version params
func (o *DeleteVersionParams) WithVersion(version string) *DeleteVersionParams {
	o.SetVersion(version)
	return o
}

// SetVersion adds the version to the delete version params
func (o *DeleteVersionParams) SetVersion(version string) {
	o.Version = version
}

// WriteToRequest writes these params to a swagger request
func (o *DeleteVersionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param box
	if err := r.SetPathParam("box", o.Box); err != nil {
		return err
	}

	// path param registry
	if err := r.SetPathParam("registry", o.Registry); err != nil {
		return err
	}

	// path param version
	if err := r.SetPathParam("version", o.Version); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
