// Code generated by go-swagger; DO NOT EDIT.

package registry_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new registry service API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for registry service API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	ActivateRegistry(params *ActivateRegistryParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ActivateRegistryOK, error)

	CreateRegistry(params *CreateRegistryParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateRegistryOK, error)

	DeactivateRegistry(params *DeactivateRegistryParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeactivateRegistryOK, error)

	DeleteRegistry(params *DeleteRegistryParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteRegistryOK, error)

	ListRegistries(params *ListRegistriesParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListRegistriesOK, error)

	ReadRegistry(params *ReadRegistryParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ReadRegistryOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
	ActivateRegistry activates registry activates a vagrant box registry at the location specified the registry must already exist and must be currently disabled

	Activation will re-enable a Registry, allowing requests and

accruing charges as normal.
*/
func (a *Client) ActivateRegistry(params *ActivateRegistryParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ActivateRegistryOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewActivateRegistryParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ActivateRegistry",
		Method:             "PUT",
		PathPattern:        "/vagrant/2022-09-30/registry/{registry}/activate",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ActivateRegistryReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ActivateRegistryOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ActivateRegistry: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
CreateRegistry creates registry creates a vagrant box registry at the location specified
*/
func (a *Client) CreateRegistry(params *CreateRegistryParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateRegistryOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateRegistryParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreateRegistry",
		Method:             "PUT",
		PathPattern:        "/vagrant/2022-09-30/registry",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &CreateRegistryReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateRegistryOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for CreateRegistry: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
	DeactivateRegistry deactivates registry deactivates a vagrant box registry at the location specified the registry must already exist and must be currently enabled

	Deactivation will disable a Registry but not delete its data.

All requests to the Registry will return not-found errors. This
can be used to temporarily block access to a Registry to prevent
access-related charges to the Registry.
*/
func (a *Client) DeactivateRegistry(params *DeactivateRegistryParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeactivateRegistryOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeactivateRegistryParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "DeactivateRegistry",
		Method:             "PUT",
		PathPattern:        "/vagrant/2022-09-30/registry/{registry}/deactivate",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DeactivateRegistryReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeactivateRegistryOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for DeactivateRegistry: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
	DeleteRegistry deletes registry deletes a vagrant box registry at the location specified

	Deletion removes the Registry and all of its Box, Version, and

Provider data, including any Hosted Providers and their
respective data. This operation is permanent and cannot be
undone.
*/
func (a *Client) DeleteRegistry(params *DeleteRegistryParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteRegistryOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteRegistryParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "DeleteRegistry",
		Method:             "DELETE",
		PathPattern:        "/vagrant/2022-09-30/registry/{registry}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DeleteRegistryReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteRegistryOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for DeleteRegistry: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ListRegistries lists registries lists available vagrant box registries the query can be scoped to a particular organization or project
*/
func (a *Client) ListRegistries(params *ListRegistriesParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListRegistriesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewListRegistriesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ListRegistries",
		Method:             "GET",
		PathPattern:        "/vagrant/2022-09-30/registry",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ListRegistriesReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListRegistriesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ListRegistries: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ReadRegistry reads registry reads a vagrant box registry by its name
*/
func (a *Client) ReadRegistry(params *ReadRegistryParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ReadRegistryOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewReadRegistryParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ReadRegistry",
		Method:             "GET",
		PathPattern:        "/vagrant/2022-09-30/registry/{registry}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ReadRegistryReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ReadRegistryOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ReadRegistry: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
