// Code generated by go-swagger; DO NOT EDIT.

package box_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vagrant-box-registry/preview/2022-09-30/models"
)

// NewUpdateBoxParams creates a new UpdateBoxParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUpdateBoxParams() *UpdateBoxParams {
	return &UpdateBoxParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUpdateBoxParamsWithTimeout creates a new UpdateBoxParams object
// with the ability to set a timeout on a request.
func NewUpdateBoxParamsWithTimeout(timeout time.Duration) *UpdateBoxParams {
	return &UpdateBoxParams{
		timeout: timeout,
	}
}

// NewUpdateBoxParamsWithContext creates a new UpdateBoxParams object
// with the ability to set a context for a request.
func NewUpdateBoxParamsWithContext(ctx context.Context) *UpdateBoxParams {
	return &UpdateBoxParams{
		Context: ctx,
	}
}

// NewUpdateBoxParamsWithHTTPClient creates a new UpdateBoxParams object
// with the ability to set a custom HTTPClient for a request.
func NewUpdateBoxParamsWithHTTPClient(client *http.Client) *UpdateBoxParams {
	return &UpdateBoxParams{
		HTTPClient: client,
	}
}

/*
UpdateBoxParams contains all the parameters to send to the API endpoint

	for the update box operation.

	Typically these are written to a http.Request.
*/
type UpdateBoxParams struct {

	// Body.
	Body *models.HashicorpCloudVagrantUpdateBoxRequest

	/* Box.

	     The name segment of the Box to update. As an example, this field would
	represent the "vagrant" in "hashicorp/vagrant".
	*/
	Box string

	/* Registry.

	     The Registry segment of the Box. As an example, this field would represent
	the "hashicorp" in "hashicorp/vagrant".
	*/
	Registry string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the update box params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateBoxParams) WithDefaults() *UpdateBoxParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the update box params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateBoxParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the update box params
func (o *UpdateBoxParams) WithTimeout(timeout time.Duration) *UpdateBoxParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the update box params
func (o *UpdateBoxParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the update box params
func (o *UpdateBoxParams) WithContext(ctx context.Context) *UpdateBoxParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the update box params
func (o *UpdateBoxParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the update box params
func (o *UpdateBoxParams) WithHTTPClient(client *http.Client) *UpdateBoxParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the update box params
func (o *UpdateBoxParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the update box params
func (o *UpdateBoxParams) WithBody(body *models.HashicorpCloudVagrantUpdateBoxRequest) *UpdateBoxParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the update box params
func (o *UpdateBoxParams) SetBody(body *models.HashicorpCloudVagrantUpdateBoxRequest) {
	o.Body = body
}

// WithBox adds the box to the update box params
func (o *UpdateBoxParams) WithBox(box string) *UpdateBoxParams {
	o.SetBox(box)
	return o
}

// SetBox adds the box to the update box params
func (o *UpdateBoxParams) SetBox(box string) {
	o.Box = box
}

// WithRegistry adds the registry to the update box params
func (o *UpdateBoxParams) WithRegistry(registry string) *UpdateBoxParams {
	o.SetRegistry(registry)
	return o
}

// SetRegistry adds the registry to the update box params
func (o *UpdateBoxParams) SetRegistry(registry string) {
	o.Registry = registry
}

// WriteToRequest writes these params to a swagger request
func (o *UpdateBoxParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param box
	if err := r.SetPathParam("box", o.Box); err != nil {
		return err
	}

	// path param registry
	if err := r.SetPathParam("registry", o.Registry); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
