// Code generated by go-swagger; DO NOT EDIT.

package packer_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-packer-service/preview/2022-04-11/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// PackerServiceGetChannelReader is a Reader for the PackerServiceGetChannel structure.
type PackerServiceGetChannelReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PackerServiceGetChannelReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPackerServiceGetChannelOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewPackerServiceGetChannelDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewPackerServiceGetChannelOK creates a PackerServiceGetChannelOK with default headers values
func NewPackerServiceGetChannelOK() *PackerServiceGetChannelOK {
	return &PackerServiceGetChannelOK{}
}

/*
PackerServiceGetChannelOK describes a response with status code 200, with default header values.

A successful response.
*/
type PackerServiceGetChannelOK struct {
	Payload *models.HashicorpCloudPacker20220411GetChannelResponse
}

// IsSuccess returns true when this packer service get channel o k response has a 2xx status code
func (o *PackerServiceGetChannelOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this packer service get channel o k response has a 3xx status code
func (o *PackerServiceGetChannelOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this packer service get channel o k response has a 4xx status code
func (o *PackerServiceGetChannelOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this packer service get channel o k response has a 5xx status code
func (o *PackerServiceGetChannelOK) IsServerError() bool {
	return false
}

// IsCode returns true when this packer service get channel o k response a status code equal to that given
func (o *PackerServiceGetChannelOK) IsCode(code int) bool {
	return code == 200
}

func (o *PackerServiceGetChannelOK) Error() string {
	return fmt.Sprintf("[GET /packer/2022-04-11/organizations/{location.organization_id}/projects/{location.project_id}/images/{bucket_slug}/channels/{slug}][%d] packerServiceGetChannelOK  %+v", 200, o.Payload)
}

func (o *PackerServiceGetChannelOK) String() string {
	return fmt.Sprintf("[GET /packer/2022-04-11/organizations/{location.organization_id}/projects/{location.project_id}/images/{bucket_slug}/channels/{slug}][%d] packerServiceGetChannelOK  %+v", 200, o.Payload)
}

func (o *PackerServiceGetChannelOK) GetPayload() *models.HashicorpCloudPacker20220411GetChannelResponse {
	return o.Payload
}

func (o *PackerServiceGetChannelOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudPacker20220411GetChannelResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPackerServiceGetChannelDefault creates a PackerServiceGetChannelDefault with default headers values
func NewPackerServiceGetChannelDefault(code int) *PackerServiceGetChannelDefault {
	return &PackerServiceGetChannelDefault{
		_statusCode: code,
	}
}

/*
PackerServiceGetChannelDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type PackerServiceGetChannelDefault struct {
	_statusCode int

	Payload *cloud.GrpcGatewayRuntimeError
}

// Code gets the status code for the packer service get channel default response
func (o *PackerServiceGetChannelDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this packer service get channel default response has a 2xx status code
func (o *PackerServiceGetChannelDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this packer service get channel default response has a 3xx status code
func (o *PackerServiceGetChannelDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this packer service get channel default response has a 4xx status code
func (o *PackerServiceGetChannelDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this packer service get channel default response has a 5xx status code
func (o *PackerServiceGetChannelDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this packer service get channel default response a status code equal to that given
func (o *PackerServiceGetChannelDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *PackerServiceGetChannelDefault) Error() string {
	return fmt.Sprintf("[GET /packer/2022-04-11/organizations/{location.organization_id}/projects/{location.project_id}/images/{bucket_slug}/channels/{slug}][%d] PackerService_GetChannel default  %+v", o._statusCode, o.Payload)
}

func (o *PackerServiceGetChannelDefault) String() string {
	return fmt.Sprintf("[GET /packer/2022-04-11/organizations/{location.organization_id}/projects/{location.project_id}/images/{bucket_slug}/channels/{slug}][%d] PackerService_GetChannel default  %+v", o._statusCode, o.Payload)
}

func (o *PackerServiceGetChannelDefault) GetPayload() *cloud.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *PackerServiceGetChannelDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
