// Code generated by go-swagger; DO NOT EDIT.

package global_network_manager_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewGetClusterAPIInfoParams creates a new GetClusterAPIInfoParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetClusterAPIInfoParams() *GetClusterAPIInfoParams {
	return &GetClusterAPIInfoParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetClusterAPIInfoParamsWithTimeout creates a new GetClusterAPIInfoParams object
// with the ability to set a timeout on a request.
func NewGetClusterAPIInfoParamsWithTimeout(timeout time.Duration) *GetClusterAPIInfoParams {
	return &GetClusterAPIInfoParams{
		timeout: timeout,
	}
}

// NewGetClusterAPIInfoParamsWithContext creates a new GetClusterAPIInfoParams object
// with the ability to set a context for a request.
func NewGetClusterAPIInfoParamsWithContext(ctx context.Context) *GetClusterAPIInfoParams {
	return &GetClusterAPIInfoParams{
		Context: ctx,
	}
}

// NewGetClusterAPIInfoParamsWithHTTPClient creates a new GetClusterAPIInfoParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetClusterAPIInfoParamsWithHTTPClient(client *http.Client) *GetClusterAPIInfoParams {
	return &GetClusterAPIInfoParams{
		HTTPClient: client,
	}
}

/*
GetClusterAPIInfoParams contains all the parameters to send to the API endpoint

	for the get cluster API info operation.

	Typically these are written to a http.Request.
*/
type GetClusterAPIInfoParams struct {

	/* ID.

	   id is the user-provided GNM cluster name
	*/
	ID string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	/* LocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure").
	*/
	LocationRegionProvider *string

	/* LocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1").
	*/
	LocationRegionRegion *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get cluster API info params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetClusterAPIInfoParams) WithDefaults() *GetClusterAPIInfoParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get cluster API info params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetClusterAPIInfoParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get cluster API info params
func (o *GetClusterAPIInfoParams) WithTimeout(timeout time.Duration) *GetClusterAPIInfoParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get cluster API info params
func (o *GetClusterAPIInfoParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get cluster API info params
func (o *GetClusterAPIInfoParams) WithContext(ctx context.Context) *GetClusterAPIInfoParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get cluster API info params
func (o *GetClusterAPIInfoParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get cluster API info params
func (o *GetClusterAPIInfoParams) WithHTTPClient(client *http.Client) *GetClusterAPIInfoParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get cluster API info params
func (o *GetClusterAPIInfoParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithID adds the id to the get cluster API info params
func (o *GetClusterAPIInfoParams) WithID(id string) *GetClusterAPIInfoParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the get cluster API info params
func (o *GetClusterAPIInfoParams) SetID(id string) {
	o.ID = id
}

// WithLocationOrganizationID adds the locationOrganizationID to the get cluster API info params
func (o *GetClusterAPIInfoParams) WithLocationOrganizationID(locationOrganizationID string) *GetClusterAPIInfoParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the get cluster API info params
func (o *GetClusterAPIInfoParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the get cluster API info params
func (o *GetClusterAPIInfoParams) WithLocationProjectID(locationProjectID string) *GetClusterAPIInfoParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the get cluster API info params
func (o *GetClusterAPIInfoParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WithLocationRegionProvider adds the locationRegionProvider to the get cluster API info params
func (o *GetClusterAPIInfoParams) WithLocationRegionProvider(locationRegionProvider *string) *GetClusterAPIInfoParams {
	o.SetLocationRegionProvider(locationRegionProvider)
	return o
}

// SetLocationRegionProvider adds the locationRegionProvider to the get cluster API info params
func (o *GetClusterAPIInfoParams) SetLocationRegionProvider(locationRegionProvider *string) {
	o.LocationRegionProvider = locationRegionProvider
}

// WithLocationRegionRegion adds the locationRegionRegion to the get cluster API info params
func (o *GetClusterAPIInfoParams) WithLocationRegionRegion(locationRegionRegion *string) *GetClusterAPIInfoParams {
	o.SetLocationRegionRegion(locationRegionRegion)
	return o
}

// SetLocationRegionRegion adds the locationRegionRegion to the get cluster API info params
func (o *GetClusterAPIInfoParams) SetLocationRegionRegion(locationRegionRegion *string) {
	o.LocationRegionRegion = locationRegionRegion
}

// WriteToRequest writes these params to a swagger request
func (o *GetClusterAPIInfoParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param id
	if err := r.SetPathParam("id", o.ID); err != nil {
		return err
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if o.LocationRegionProvider != nil {

		// query param location.region.provider
		var qrLocationRegionProvider string

		if o.LocationRegionProvider != nil {
			qrLocationRegionProvider = *o.LocationRegionProvider
		}
		qLocationRegionProvider := qrLocationRegionProvider
		if qLocationRegionProvider != "" {

			if err := r.SetQueryParam("location.region.provider", qLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.LocationRegionRegion != nil {

		// query param location.region.region
		var qrLocationRegionRegion string

		if o.LocationRegionRegion != nil {
			qrLocationRegionRegion = *o.LocationRegionRegion
		}
		qLocationRegionRegion := qrLocationRegionRegion
		if qLocationRegionRegion != "" {

			if err := r.SetQueryParam("location.region.region", qLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
