// Code generated by go-swagger; DO NOT EDIT.

package global_network_manager_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-global-network-manager-service/preview/2022-02-15/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// AgentPushServerStateReader is a Reader for the AgentPushServerState structure.
type AgentPushServerStateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AgentPushServerStateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewAgentPushServerStateOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewAgentPushServerStateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewAgentPushServerStateOK creates a AgentPushServerStateOK with default headers values
func NewAgentPushServerStateOK() *AgentPushServerStateOK {
	return &AgentPushServerStateOK{}
}

/*
AgentPushServerStateOK describes a response with status code 200, with default header values.

A successful response.
*/
type AgentPushServerStateOK struct {
	Payload models.HashicorpCloudGlobalNetworkManager20220215AgentPushServerStateResponse
}

// IsSuccess returns true when this agent push server state o k response has a 2xx status code
func (o *AgentPushServerStateOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this agent push server state o k response has a 3xx status code
func (o *AgentPushServerStateOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this agent push server state o k response has a 4xx status code
func (o *AgentPushServerStateOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this agent push server state o k response has a 5xx status code
func (o *AgentPushServerStateOK) IsServerError() bool {
	return false
}

// IsCode returns true when this agent push server state o k response a status code equal to that given
func (o *AgentPushServerStateOK) IsCode(code int) bool {
	return code == 200
}

func (o *AgentPushServerStateOK) Error() string {
	return fmt.Sprintf("[POST /global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{id}/agent/server-state][%d] agentPushServerStateOK  %+v", 200, o.Payload)
}

func (o *AgentPushServerStateOK) String() string {
	return fmt.Sprintf("[POST /global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{id}/agent/server-state][%d] agentPushServerStateOK  %+v", 200, o.Payload)
}

func (o *AgentPushServerStateOK) GetPayload() models.HashicorpCloudGlobalNetworkManager20220215AgentPushServerStateResponse {
	return o.Payload
}

func (o *AgentPushServerStateOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAgentPushServerStateDefault creates a AgentPushServerStateDefault with default headers values
func NewAgentPushServerStateDefault(code int) *AgentPushServerStateDefault {
	return &AgentPushServerStateDefault{
		_statusCode: code,
	}
}

/*
AgentPushServerStateDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type AgentPushServerStateDefault struct {
	_statusCode int

	Payload *cloud.GrpcGatewayRuntimeError
}

// Code gets the status code for the agent push server state default response
func (o *AgentPushServerStateDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this agent push server state default response has a 2xx status code
func (o *AgentPushServerStateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this agent push server state default response has a 3xx status code
func (o *AgentPushServerStateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this agent push server state default response has a 4xx status code
func (o *AgentPushServerStateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this agent push server state default response has a 5xx status code
func (o *AgentPushServerStateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this agent push server state default response a status code equal to that given
func (o *AgentPushServerStateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *AgentPushServerStateDefault) Error() string {
	return fmt.Sprintf("[POST /global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{id}/agent/server-state][%d] AgentPushServerState default  %+v", o._statusCode, o.Payload)
}

func (o *AgentPushServerStateDefault) String() string {
	return fmt.Sprintf("[POST /global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{id}/agent/server-state][%d] AgentPushServerState default  %+v", o._statusCode, o.Payload)
}

func (o *AgentPushServerStateDefault) GetPayload() *cloud.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *AgentPushServerStateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
