---
title: Amazon S3 permissions
weight: 20
---
# Amazon S3 permissions

For configuration options, refer to the storage section on the [configuration]({{< relref "configuration" >}}) page.

The following authentication methods are supported:
- AWS environment variables `AWS_ACCESS_KEY_ID` and `AWS_SECRET_ACCESS_KEY`
- Static access key and secret credentials specified in `access_key` and `secret_key`
- MinIO environment variables `MINIO_ACCESS_KEY` and `MINIO_SECRET_KEY`
- AWS shared credentials [configuration file](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/create-shared-credentials-file.html)
- MinIO client credentials [configuration file](https://github.com/minio/mc/blob/master/docs/minio-client-configuration-files.md)
- AWS IAM ([IRSA via WebIdentity](https://docs.aws.amazon.com/eks/latest/userguide/iam-roles-for-service-accounts.html),
- AWS [EC2 instance role](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-roles-for-amazon-ec2.html))

The following IAM policy shows minimal permissions required by Tempo, where the bucket has already been created.

```json
{
    "Version": "2012-10-17",
    "Statement": [
        {
            "Sid": "TempoPermissions",
            "Effect": "Allow",
            "Action": [
                "s3:PutObject",
                "s3:GetObject",
                "s3:ListBucket",
                "s3:DeleteObject",
                "s3:GetObjectTagging",
                "s3:PutObjectTagging"
            ],
            "Resource": [
                "arn:aws:s3:::<bucketname>/*",
                "arn:aws:s3:::<bucketname>"
            ]
        }
    ]
}
```

## Lifecycle policy
A lifecycle policy is recommended that deletes incomplete multipart uploads after one day.
