// This file is generated by "./lib/proto/generate"

package proto

import (
	"github.com/ysmood/gson"
)

/*

Media

This domain allows detailed inspection of media elements

*/

// MediaPlayerID Players will get an ID that is unique within the agent context.
type MediaPlayerID string

// MediaTimestamp ...
type MediaTimestamp float64

// MediaPlayerMessageLevel enum.
type MediaPlayerMessageLevel string

const (
	// MediaPlayerMessageLevelError enum const.
	MediaPlayerMessageLevelError MediaPlayerMessageLevel = "error"

	// MediaPlayerMessageLevelWarning enum const.
	MediaPlayerMessageLevelWarning MediaPlayerMessageLevel = "warning"

	// MediaPlayerMessageLevelInfo enum const.
	MediaPlayerMessageLevelInfo MediaPlayerMessageLevel = "info"

	// MediaPlayerMessageLevelDebug enum const.
	MediaPlayerMessageLevelDebug MediaPlayerMessageLevel = "debug"
)

// MediaPlayerMessage Have one type per entry in MediaLogRecord::Type
// Corresponds to kMessage.
type MediaPlayerMessage struct {
	// Level Keep in sync with MediaLogMessageLevel
	// We are currently keeping the message level 'error' separate from the
	// PlayerError type because right now they represent different things,
	// this one being a DVLOG(ERROR) style log message that gets printed
	// based on what log level is selected in the UI, and the other is a
	// representation of a media::PipelineStatus object. Soon however we're
	// going to be moving away from using PipelineStatus for errors and
	// introducing a new error type which should hopefully let us integrate
	// the error log level into the PlayerError type.
	Level MediaPlayerMessageLevel `json:"level"`

	// Message ...
	Message string `json:"message"`
}

// MediaPlayerProperty Corresponds to kMediaPropertyChange.
type MediaPlayerProperty struct {
	// Name ...
	Name string `json:"name"`

	// Value ...
	Value string `json:"value"`
}

// MediaPlayerEvent Corresponds to kMediaEventTriggered.
type MediaPlayerEvent struct {
	// Timestamp ...
	Timestamp MediaTimestamp `json:"timestamp"`

	// Value ...
	Value string `json:"value"`
}

// MediaPlayerErrorSourceLocation Represents logged source line numbers reported in an error.
// NOTE: file and line are from chromium c++ implementation code, not js.
type MediaPlayerErrorSourceLocation struct {
	// File ...
	File string `json:"file"`

	// Line ...
	Line int `json:"line"`
}

// MediaPlayerError Corresponds to kMediaError.
type MediaPlayerError struct {
	// ErrorType ...
	ErrorType string `json:"errorType"`

	// Code is the numeric enum entry for a specific set of error codes, such
	// as PipelineStatusCodes in media/base/pipeline_status.h
	Code int `json:"code"`

	// Stack A trace of where this error was caused / where it passed through.
	Stack []*MediaPlayerErrorSourceLocation `json:"stack"`

	// Cause Errors potentially have a root cause error, ie, a DecoderError might be
	// caused by an WindowsError
	Cause []*MediaPlayerError `json:"cause"`

	// Data Extra data attached to an error, such as an HRESULT, Video Codec, etc.
	Data map[string]gson.JSON `json:"data"`
}

// MediaEnable Enables the Media domain.
type MediaEnable struct{}

// ProtoReq name.
func (m MediaEnable) ProtoReq() string { return "Media.enable" }

// Call sends the request.
func (m MediaEnable) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// MediaDisable Disables the Media domain.
type MediaDisable struct{}

// ProtoReq name.
func (m MediaDisable) ProtoReq() string { return "Media.disable" }

// Call sends the request.
func (m MediaDisable) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// MediaPlayerPropertiesChanged This can be called multiple times, and can be used to set / override /
// remove player properties. A null propValue indicates removal.
type MediaPlayerPropertiesChanged struct {
	// PlayerID ...
	PlayerID MediaPlayerID `json:"playerId"`

	// Properties ...
	Properties []*MediaPlayerProperty `json:"properties"`
}

// ProtoEvent name.
func (evt MediaPlayerPropertiesChanged) ProtoEvent() string {
	return "Media.playerPropertiesChanged"
}

// MediaPlayerEventsAdded Send events as a list, allowing them to be batched on the browser for less
// congestion. If batched, events must ALWAYS be in chronological order.
type MediaPlayerEventsAdded struct {
	// PlayerID ...
	PlayerID MediaPlayerID `json:"playerId"`

	// Events ...
	Events []*MediaPlayerEvent `json:"events"`
}

// ProtoEvent name.
func (evt MediaPlayerEventsAdded) ProtoEvent() string {
	return "Media.playerEventsAdded"
}

// MediaPlayerMessagesLogged Send a list of any messages that need to be delivered.
type MediaPlayerMessagesLogged struct {
	// PlayerID ...
	PlayerID MediaPlayerID `json:"playerId"`

	// Messages ...
	Messages []*MediaPlayerMessage `json:"messages"`
}

// ProtoEvent name.
func (evt MediaPlayerMessagesLogged) ProtoEvent() string {
	return "Media.playerMessagesLogged"
}

// MediaPlayerErrorsRaised Send a list of any errors that need to be delivered.
type MediaPlayerErrorsRaised struct {
	// PlayerID ...
	PlayerID MediaPlayerID `json:"playerId"`

	// Errors ...
	Errors []*MediaPlayerError `json:"errors"`
}

// ProtoEvent name.
func (evt MediaPlayerErrorsRaised) ProtoEvent() string {
	return "Media.playerErrorsRaised"
}

// MediaPlayersCreated Called whenever a player is created, or when a new agent joins and receives
// a list of active players. If an agent is restored, it will receive the full
// list of player ids and all events again.
type MediaPlayersCreated struct {
	// Players ...
	Players []MediaPlayerID `json:"players"`
}

// ProtoEvent name.
func (evt MediaPlayersCreated) ProtoEvent() string {
	return "Media.playersCreated"
}
