// Licensed to Elasticsearch B.V. under one or more contributor
// license agreements. See the NOTICE file distributed with
// this work for additional information regarding copyright
// ownership. Elasticsearch B.V. licenses this file to you under
// the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Code generated by mk_audit_syscalls.pl  - DO NOT EDIT.

package auparse

// AuditSyscalls is a mapping of arch names to tables of syscall numbers to names.
// For example, x86_64 -> 165 = "mount".
var AuditSyscalls = map[string]map[int]string{
	"aarch64": {
		0:   "io_setup",
		1:   "io_destroy",
		2:   "io_submit",
		3:   "io_cancel",
		4:   "io_getevents",
		5:   "setxattr",
		6:   "lsetxattr",
		7:   "fsetxattr",
		8:   "getxattr",
		9:   "lgetxattr",
		10:  "fgetxattr",
		11:  "listxattr",
		12:  "llistxattr",
		13:  "flistxattr",
		14:  "removexattr",
		15:  "lremovexattr",
		16:  "fremovexattr",
		17:  "getcwd",
		18:  "lookup_dcookie",
		19:  "eventfd2",
		20:  "epoll_create1",
		21:  "epoll_ctl",
		22:  "epoll_pwait",
		23:  "dup",
		24:  "dup3",
		25:  "fcntl",
		26:  "inotify_init1",
		27:  "inotify_add_watch",
		28:  "inotify_rm_watch",
		29:  "ioctl",
		30:  "ioprio_set",
		31:  "ioprio_get",
		32:  "flock",
		33:  "mknodat",
		34:  "mkdirat",
		35:  "unlinkat",
		36:  "symlinkat",
		37:  "linkat",
		38:  "renameat",
		39:  "umount2",
		40:  "mount",
		41:  "pivot_root",
		42:  "nfsservctl",
		43:  "statfs",
		44:  "fstatfs",
		45:  "truncate",
		46:  "ftruncate",
		47:  "fallocate",
		48:  "faccessat",
		49:  "chdir",
		50:  "fchdir",
		51:  "chroot",
		52:  "fchmod",
		53:  "fchmodat",
		54:  "fchownat",
		55:  "fchown",
		56:  "openat",
		57:  "close",
		58:  "vhangup",
		59:  "pipe2",
		60:  "quotactl",
		61:  "getdents",
		62:  "lseek",
		63:  "read",
		64:  "write",
		65:  "readv",
		66:  "writev",
		67:  "pread",
		68:  "pwrite",
		69:  "preadv",
		70:  "pwritev",
		71:  "sendfile",
		72:  "pselect6",
		73:  "ppoll",
		74:  "signalfd4",
		75:  "vmsplice",
		76:  "splice",
		77:  "tee",
		78:  "readlinkat",
		79:  "newfstatat",
		80:  "newfstat",
		81:  "sync",
		82:  "fsync",
		83:  "fdatasync",
		84:  "sync_file_range",
		85:  "timerfd_create",
		86:  "timerfd_settime",
		87:  "timerfd_gettime",
		88:  "utimensat",
		89:  "acct",
		90:  "capget",
		91:  "capset",
		92:  "personality",
		93:  "exit",
		94:  "exit_group",
		95:  "waitid",
		96:  "set_tid_address",
		97:  "unshare",
		98:  "futex",
		99:  "set_robust_list",
		100: "get_robust_list",
		101: "nanosleep",
		102: "getitimer",
		103: "setitimer",
		104: "kexec_load",
		105: "init_module",
		106: "delete_module",
		107: "timer_create",
		108: "timer_gettime",
		109: "timer_getoverrun",
		110: "timer_settime",
		111: "timer_delete",
		112: "clock_settime",
		113: "clock_gettime",
		114: "clock_getres",
		115: "clock_nanosleep",
		116: "syslog",
		117: "ptrace",
		118: "sched_setparam",
		119: "sched_setscheduler",
		120: "sched_getscheduler",
		121: "sched_getparam",
		122: "sched_setaffinity",
		123: "sched_getaffinity",
		124: "sched_yield",
		125: "sched_get_priority_max",
		126: "sched_get_priority_min",
		127: "sched_rr_get_interval",
		128: "restart_syscall",
		129: "kill",
		130: "tkill",
		131: "tgkill",
		132: "sigaltstack",
		133: "rt_sigsuspend",
		134: "rt_sigaction",
		135: "rt_sigprocmask",
		136: "rt_sigpending",
		137: "rt_sigtimedwait",
		138: "rt_sigqueueinfo",
		139: "rt_sigreturn",
		140: "setpriority",
		141: "getpriority",
		142: "reboot",
		143: "setregid",
		144: "setgid",
		145: "setreuid",
		146: "setuid",
		147: "setresuid",
		148: "getresuid",
		149: "setresgid",
		150: "getresgid",
		151: "setfsuid",
		152: "setfsgid",
		153: "times",
		154: "setpgid",
		155: "getpgid",
		156: "getsid",
		157: "setsid",
		158: "getgroups",
		159: "setgroups",
		160: "uname",
		161: "sethostname",
		162: "setdomainname",
		163: "getrlimit",
		164: "setrlimit",
		165: "getrusage",
		166: "umask",
		167: "prctl",
		168: "getcpu",
		169: "gettimeofday",
		170: "settimeofday",
		171: "adjtimex",
		172: "getpid",
		173: "getppid",
		174: "getuid",
		175: "geteuid",
		176: "getgid",
		177: "getegid",
		178: "gettid",
		179: "sysinfo",
		180: "mq_open",
		181: "mq_unlink",
		182: "mq_timedsend",
		183: "mq_timedreceive",
		184: "mq_notify",
		185: "mq_getsetattr",
		186: "msgget",
		187: "msgctl",
		188: "msgrcv",
		189: "msgsnd",
		190: "semget",
		191: "semctl",
		192: "semtimedop",
		193: "semop",
		194: "shmget",
		195: "shmctl",
		196: "shmat",
		197: "shmdt",
		198: "socket",
		199: "socketpair",
		200: "bind",
		201: "listen",
		202: "accept",
		203: "connect",
		204: "getsockname",
		205: "getpeername",
		206: "sendto",
		207: "recvfrom",
		208: "setsockopt",
		209: "getsockopt",
		210: "shutdown",
		211: "sendmsg",
		212: "recvmsg",
		213: "readahead",
		214: "brk",
		215: "munmap",
		216: "mremap",
		217: "add_key",
		218: "request_key",
		219: "keyctl",
		220: "clone",
		221: "execve",
		222: "mmap",
		223: "fadvise64",
		224: "swapon",
		225: "swapoff",
		226: "mprotect",
		227: "msync",
		228: "mlock",
		229: "munlock",
		230: "mlockall",
		231: "munlockall",
		232: "mincore",
		233: "madvise",
		234: "remap_file_pages",
		235: "mbind",
		236: "get_mempolicy",
		237: "set_mempolicy",
		238: "migrate_pages",
		239: "move_pages",
		240: "rt_tgsigqueueinfo",
		241: "perf_event_open",
		242: "accept4",
		243: "recvmmsg",
		260: "wait4",
		261: "prlimit64",
		262: "fanotify_init",
		263: "fanotify_mark",
		264: "name_to_handle_at",
		265: "open_by_handle_at",
		266: "clock_adjtime",
		267: "syncfs",
		268: "setns",
		269: "sendmmsg",
		270: "process_vm_readv",
		271: "process_vm_writev",
		272: "kcmp",
		273: "finit_module",
		274: "sched_setattr",
		275: "sched_getattr",
		276: "renameat2",
		277: "seccomp",
		278: "getrandom",
		279: "memfd_create",
		280: "bpf",
		281: "execveat",
		282: "userfaultfd",
		283: "membarrier",
		284: "mlock2",
		285: "copy_file_range",
		286: "preadv2",
		287: "pwritev2",
		288: "pkey_mprotect",
		289: "pkey_alloc",
		290: "pkey_free",
		291: "statx",
		292: "io_pgetevents",
		293: "rseq",
		294: "kexec_file_load",
		424: "pidfd_send_signal",
		425: "io_uring_setup",
		426: "io_uring_enter",
		427: "io_uring_register",
		428: "open_tree",
		429: "move_mount",
		430: "fsopen",
		431: "fsconfig",
		432: "fsmount",
		433: "fspick",
		434: "pidfd_open",
		435: "clone3",
		436: "close_range",
		437: "openat2",
		438: "pidfd_getfd",
		439: "faccessat2",
		440: "process_madvise",
		441: "epoll_pwait2",
		442: "mount_setattr",
		443: "quotactl_fd",
		444: "landlock_create_ruleset",
		445: "landlock_add_rule",
		446: "landlock_restrict_self",
		447: "memfd_secret",
		448: "process_mrelease",
		449: "futex_waitv",
		450: "set_mempolicy_home_node",
		451: "cachestat",
		452: "fchmodat2",
		453: "map_shadow_stack",
		454: "futex_wake",
		455: "futex_wait",
		456: "futex_requeue",
		457: "statmount",
		458: "listmount",
		459: "lsm_get_self_attr",
		460: "lsm_set_self_attr",
		461: "lsm_list_modules",
		462: "mseal",
	},
	"arm": {
		0:   "restart_syscall",
		1:   "exit",
		2:   "fork",
		3:   "read",
		4:   "write",
		5:   "open",
		6:   "close",
		8:   "creat",
		9:   "link",
		10:  "unlink",
		11:  "execve",
		12:  "chdir",
		13:  "time",
		14:  "mknod",
		15:  "chmod",
		16:  "lchown",
		19:  "lseek",
		20:  "getpid",
		21:  "mount",
		22:  "umount",
		23:  "setuid",
		24:  "getuid",
		25:  "stime",
		26:  "ptrace",
		27:  "alarm",
		29:  "pause",
		30:  "utime",
		33:  "access",
		34:  "nice",
		36:  "sync",
		37:  "kill",
		38:  "rename",
		39:  "mkdir",
		40:  "rmdir",
		41:  "dup",
		42:  "pipe",
		43:  "times",
		45:  "brk",
		46:  "setgid",
		47:  "getgid",
		49:  "geteuid",
		50:  "getegid",
		51:  "acct",
		52:  "umount2",
		54:  "ioctl",
		55:  "fcntl",
		57:  "setpgid",
		60:  "umask",
		61:  "chroot",
		62:  "ustat",
		63:  "dup2",
		64:  "getppid",
		65:  "getpgrp",
		66:  "setsid",
		67:  "sigaction",
		70:  "setreuid",
		71:  "setregid",
		72:  "sigsuspend",
		73:  "sigpending",
		74:  "sethostname",
		75:  "setrlimit",
		76:  "getrlimit",
		77:  "getrusage",
		78:  "gettimeofday",
		79:  "settimeofday",
		80:  "getgroups",
		81:  "setgroups",
		82:  "select",
		83:  "symlink",
		85:  "readlink",
		86:  "uselib",
		87:  "swapon",
		88:  "reboot",
		89:  "readdir",
		90:  "mmap",
		91:  "munmap",
		92:  "truncate",
		93:  "ftruncate",
		94:  "fchmod",
		95:  "fchown",
		96:  "getpriority",
		97:  "setpriority",
		99:  "statfs",
		100: "fstatfs",
		102: "socketcall",
		103: "syslog",
		104: "setitimer",
		105: "getitimer",
		106: "stat",
		107: "lstat",
		108: "fstat",
		111: "vhangup",
		113: "syscall",
		114: "wait4",
		115: "swapoff",
		116: "sysinfo",
		117: "ipc",
		118: "fsync",
		119: "sigreturn",
		120: "clone",
		121: "setdomainname",
		122: "uname",
		124: "adjtimex",
		125: "mprotect",
		126: "sigprocmask",
		128: "init_module",
		129: "delete_module",
		131: "quotactl",
		132: "getpgid",
		133: "fchdir",
		134: "bdflush",
		135: "sysfs",
		136: "personality",
		138: "setfsuid",
		139: "setfsgid",
		140: "llseek",
		141: "getdents",
		142: "newselect",
		143: "flock",
		144: "msync",
		145: "readv",
		146: "writev",
		147: "getsid",
		148: "fdatasync",
		149: "sysctl",
		150: "mlock",
		151: "munlock",
		152: "mlockall",
		153: "munlockall",
		154: "sched_setparam",
		155: "sched_getparam",
		156: "sched_setscheduler",
		157: "sched_getscheduler",
		158: "sched_yield",
		159: "sched_get_priority_max",
		160: "sched_get_priority_min",
		161: "sched_rr_get_interval",
		162: "nanosleep",
		163: "mremap",
		164: "setresuid",
		165: "getresuid",
		168: "poll",
		169: "nfsservctl",
		170: "setresgid",
		171: "getresgid",
		172: "prctl",
		173: "rt_sigreturn",
		174: "rt_sigaction",
		175: "rt_sigprocmask",
		176: "rt_sigpending",
		177: "rt_sigtimedwait",
		178: "rt_sigqueueinfo",
		179: "rt_sigsuspend",
		180: "pread64",
		181: "pwrite64",
		182: "chown",
		183: "getcwd",
		184: "capget",
		185: "capset",
		186: "sigaltstack",
		187: "sendfile",
		190: "vfork",
		191: "ugetrlimit",
		192: "mmap2",
		193: "truncate64",
		194: "ftruncate64",
		195: "stat64",
		196: "lstat64",
		197: "fstat64",
		198: "lchown32",
		199: "getuid32",
		200: "getgid32",
		201: "geteuid32",
		202: "getegid32",
		203: "setreuid32",
		204: "setregid32",
		205: "getgroups32",
		206: "setgroups32",
		207: "fchown32",
		208: "setresuid32",
		209: "getresuid32",
		210: "setresgid32",
		211: "getresgid32",
		212: "chown32",
		213: "setuid32",
		214: "setgid32",
		215: "setfsuid32",
		216: "setfsgid32",
		217: "getdents64",
		218: "pivot_root",
		219: "mincore",
		220: "madvise",
		221: "fcntl64",
		224: "gettid",
		225: "readahead",
		226: "setxattr",
		227: "lsetxattr",
		228: "fsetxattr",
		229: "getxattr",
		230: "lgetxattr",
		231: "fgetxattr",
		232: "listxattr",
		233: "llistxattr",
		234: "flistxattr",
		235: "removexattr",
		236: "lremovexattr",
		237: "fremovexattr",
		238: "tkill",
		239: "sendfile64",
		240: "futex",
		241: "sched_setaffinity",
		242: "sched_getaffinity",
		243: "io_setup",
		244: "io_destroy",
		245: "io_getevents",
		246: "io_submit",
		247: "io_cancel",
		248: "exit_group",
		249: "lookup_dcookie",
		250: "epoll_create",
		251: "epoll_ctl",
		252: "epoll_wait",
		253: "remap_file_pages",
		256: "set_tid_address",
		257: "timer_create",
		258: "timer_settime",
		259: "timer_gettime",
		260: "timer_getoverrun",
		261: "timer_delete",
		262: "clock_settime",
		263: "clock_gettime",
		264: "clock_getres",
		265: "clock_nanosleep",
		266: "statfs64",
		267: "fstatfs64",
		268: "tgkill",
		269: "utimes",
		270: "fadvise64_64",
		271: "pciconfig_iobase",
		272: "pciconfig_read",
		273: "pciconfig_write",
		274: "mq_open",
		275: "mq_unlink",
		276: "mq_timedsend",
		277: "mq_timedreceive",
		278: "mq_notify",
		279: "mq_getsetattr",
		280: "waitid",
		281: "socket",
		282: "bind",
		283: "connect",
		284: "listen",
		285: "accept",
		286: "getsockname",
		287: "getpeername",
		288: "socketpair",
		289: "send",
		290: "sendto",
		291: "recv",
		292: "recvfrom",
		293: "shutdown",
		294: "setsockopt",
		295: "getsockopt",
		296: "sendmsg",
		297: "recvmsg",
		298: "semop",
		299: "semget",
		300: "semctl",
		301: "msgsnd",
		302: "msgrcv",
		303: "msgget",
		304: "msgctl",
		305: "shmat",
		306: "shmdt",
		307: "shmget",
		308: "shmctl",
		309: "add_key",
		310: "request_key",
		311: "keyctl",
		312: "semtimedop",
		313: "vserver",
		314: "ioprio_set",
		315: "ioprio_get",
		316: "inotify_init",
		317: "inotify_add_watch",
		318: "inotify_rm_watch",
		319: "mbind",
		320: "get_mempolicy",
		321: "set_mempolicy",
		322: "openat",
		323: "mkdirat",
		324: "mknodat",
		325: "fchownat",
		326: "futimesat",
		327: "fstatat64",
		328: "unlinkat",
		329: "renameat",
		330: "linkat",
		331: "symlinkat",
		332: "readlinkat",
		333: "fchmodat",
		334: "faccessat",
		337: "unshare",
		338: "set_robust_list",
		339: "get_robust_list",
		340: "splice",
		341: "sync_file_range",
		342: "tee",
		343: "vmsplice",
		344: "move_pages",
		345: "getcpu",
		347: "kexec_load",
		348: "utimensat",
		349: "signalfd",
		350: "timerfd_create",
		351: "eventfd",
		352: "fallocate",
		353: "timerfd_settime",
		354: "timerfd_gettime",
		355: "signalfd4",
		356: "eventfd2",
		357: "epoll_create1",
		358: "dup3",
		359: "pipe2",
		360: "inotify_init1",
		361: "preadv",
		362: "pwritev",
		363: "rt_tgsigqueueinfo",
		364: "perf_event_open",
		365: "recvmmsg",
		366: "accept4",
		367: "fanotify_init",
		368: "fanotify_mark",
		369: "prlimit64",
		370: "name_to_handle_at",
		371: "open_by_handle_at",
		372: "clock_adjtime",
		373: "syncfs",
		374: "sendmmsg",
		375: "setns",
		376: "process_vm_readv",
		377: "process_vm_writev",
		378: "kcmp",
		379: "finit_module",
		380: "sched_setattr",
		381: "sched_getattr",
		382: "renameat2",
		383: "seccomp",
		384: "getrandom",
		385: "memfd_create",
		386: "bpf",
		387: "execveat",
		388: "userfaultfd",
		389: "membarrier",
		390: "mlock2",
		391: "copy_file_range",
		392: "preadv2",
		393: "pwritev2",
		394: "pkey_mprotect",
		395: "pkey_alloc",
		396: "pkey_free",
		397: "statx",
		398: "rseq",
		399: "io_pgetevents",
		400: "migrate_pages",
		401: "kexec_file_load",
		403: "clock_gettime64",
		404: "clock_settime64",
		405: "clock_adjtime64",
		406: "clock_getres_time64",
		407: "clock_nanosleep_time64",
		408: "timer_gettime64",
		409: "timer_settime64",
		410: "timerfd_gettime64",
		411: "timerfd_settime64",
		412: "utimensat_time64",
		413: "pselect6_time64",
		414: "ppoll_time64",
		416: "io_pgetevents_time64",
		417: "recvmmsg_time64",
		418: "mq_timedsend_time64",
		419: "mq_timedreceive_time64",
		420: "semtimedop_time64",
		421: "rt_sigtimedwait_time64",
		422: "futex_time64",
		423: "sched_rr_get_interval64",
		424: "pidfd_send_signal",
		425: "io_uring_setup",
		426: "io_uring_enter",
		427: "io_uring_register",
		428: "open_tree",
		429: "move_mount",
		430: "fsopen",
		431: "fsconfig",
		432: "fsmount",
		433: "fspick",
		434: "pidfd_open",
		435: "clone3",
		436: "close_range",
		437: "openat2",
		438: "pidfd_getfd",
		439: "faccessat2",
		440: "process_madvise",
		441: "epoll_pwait2",
		442: "mount_setattr",
		443: "quotactl_fd",
		444: "landlock_create_ruleset",
		445: "landlock_add_rule",
		446: "landlock_restrict_self",
		448: "process_mrelease",
		449: "futex_waitv",
		450: "set_mempolicy_home_node",
		451: "cachestat",
		452: "fchmodat2",
		453: "map_shadow_stack",
		454: "futex_wake",
		455: "futex_wait",
		456: "futex_requeue",
		457: "statmount",
		458: "listmount",
		459: "lsm_get_self_attr",
		460: "lsm_set_self_attr",
		461: "lsm_list_modules",
		462: "mseal",
	},
	"i386": {
		0:   "restart_syscall",
		1:   "exit",
		2:   "fork",
		3:   "read",
		4:   "write",
		5:   "open",
		6:   "close",
		7:   "waitpid",
		8:   "creat",
		9:   "link",
		10:  "unlink",
		11:  "execve",
		12:  "chdir",
		13:  "time",
		14:  "mknod",
		15:  "chmod",
		16:  "lchown",
		17:  "break",
		18:  "oldstat",
		19:  "lseek",
		20:  "getpid",
		21:  "mount",
		22:  "umount",
		23:  "setuid",
		24:  "getuid",
		25:  "stime",
		26:  "ptrace",
		27:  "alarm",
		28:  "oldfstat",
		29:  "pause",
		30:  "utime",
		31:  "stty",
		32:  "gtty",
		33:  "access",
		34:  "nice",
		35:  "ftime",
		36:  "sync",
		37:  "kill",
		38:  "rename",
		39:  "mkdir",
		40:  "rmdir",
		41:  "dup",
		42:  "pipe",
		43:  "times",
		44:  "prof",
		45:  "brk",
		46:  "setgid",
		47:  "getgid",
		48:  "signal",
		49:  "geteuid",
		50:  "getegid",
		51:  "acct",
		52:  "umount2",
		53:  "lock",
		54:  "ioctl",
		55:  "fcntl",
		56:  "mpx",
		57:  "setpgid",
		58:  "ulimit",
		59:  "oldolduname",
		60:  "umask",
		61:  "chroot",
		62:  "ustat",
		63:  "dup2",
		64:  "getppid",
		65:  "getpgrp",
		66:  "setsid",
		67:  "sigaction",
		68:  "sgetmask",
		69:  "ssetmask",
		70:  "setreuid",
		71:  "setregid",
		72:  "sigsuspend",
		73:  "sigpending",
		74:  "sethostname",
		75:  "setrlimit",
		76:  "getrlimit",
		77:  "getrusage",
		78:  "gettimeofday",
		79:  "settimeofday",
		80:  "getgroups",
		81:  "setgroups",
		82:  "select",
		83:  "symlink",
		84:  "oldlstat",
		85:  "readlink",
		86:  "uselib",
		87:  "swapon",
		88:  "reboot",
		89:  "readdir",
		90:  "mmap",
		91:  "munmap",
		92:  "truncate",
		93:  "ftruncate",
		94:  "fchmod",
		95:  "fchown",
		96:  "getpriority",
		97:  "setpriority",
		98:  "profil",
		99:  "statfs",
		100: "fstatfs",
		101: "ioperm",
		102: "socketcall",
		103: "syslog",
		104: "setitimer",
		105: "getitimer",
		106: "stat",
		107: "lstat",
		108: "fstat",
		109: "olduname",
		110: "iopl",
		111: "vhangup",
		112: "idle",
		113: "vm86old",
		114: "wait4",
		115: "swapoff",
		116: "sysinfo",
		117: "ipc",
		118: "fsync",
		119: "sigreturn",
		120: "clone",
		121: "setdomainname",
		122: "uname",
		123: "modify_ldt",
		124: "adjtimex",
		125: "mprotect",
		126: "sigprocmask",
		127: "create_module",
		128: "init_module",
		129: "delete_module",
		130: "get_kernel_syms",
		131: "quotactl",
		132: "getpgid",
		133: "fchdir",
		134: "bdflush",
		135: "sysfs",
		136: "personality",
		137: "afs_syscall",
		138: "setfsuid",
		139: "setfsgid",
		140: "_llseek",
		141: "getdents",
		142: "_newselect",
		143: "flock",
		144: "msync",
		145: "readv",
		146: "writev",
		147: "getsid",
		148: "fdatasync",
		149: "_sysctl",
		150: "mlock",
		151: "munlock",
		152: "mlockall",
		153: "munlockall",
		154: "sched_setparam",
		155: "sched_getparam",
		156: "sched_setscheduler",
		157: "sched_getscheduler",
		158: "sched_yield",
		159: "sched_get_priority_max",
		160: "sched_get_priority_min",
		161: "sched_rr_get_interval",
		162: "nanosleep",
		163: "mremap",
		164: "setresuid",
		165: "getresuid",
		166: "vm86",
		167: "query_module",
		168: "poll",
		169: "nfsservctl",
		170: "setresgid",
		171: "getresgid",
		172: "prctl",
		173: "rt_sigreturn",
		174: "rt_sigaction",
		175: "rt_sigprocmask",
		176: "rt_sigpending",
		177: "rt_sigtimedwait",
		178: "rt_sigqueueinfo",
		179: "rt_sigsuspend",
		180: "pread64",
		181: "pwrite64",
		182: "chown",
		183: "getcwd",
		184: "capget",
		185: "capset",
		186: "sigaltstack",
		187: "sendfile",
		188: "getpmsg",
		189: "putpmsg",
		190: "vfork",
		191: "ugetrlimit",
		192: "mmap2",
		193: "truncate64",
		194: "ftruncate64",
		195: "stat64",
		196: "lstat64",
		197: "fstat64",
		198: "lchown32",
		199: "getuid32",
		200: "getgid32",
		201: "geteuid32",
		202: "getegid32",
		203: "setreuid32",
		204: "setregid32",
		205: "getgroups32",
		206: "setgroups32",
		207: "fchown32",
		208: "setresuid32",
		209: "getresuid32",
		210: "setresgid32",
		211: "getresgid32",
		212: "chown32",
		213: "setuid32",
		214: "setgid32",
		215: "setfsuid32",
		216: "setfsgid32",
		217: "pivot_root",
		218: "mincore",
		219: "madvise1",
		220: "getdents64",
		221: "fcntl64",
		224: "gettid",
		225: "readahead",
		226: "setxattr",
		227: "lsetxattr",
		228: "fsetxattr",
		229: "getxattr",
		230: "lgetxattr",
		231: "fgetxattr",
		232: "listxattr",
		233: "llistxattr",
		234: "flistxattr",
		235: "removexattr",
		236: "lremovexattr",
		237: "fremovexattr",
		238: "tkill",
		239: "sendfile64",
		240: "futex",
		241: "sched_setaffinity",
		242: "sched_getaffinity",
		243: "set_thread_area",
		244: "get_thread_area",
		245: "io_setup",
		246: "io_destroy",
		247: "io_getevents",
		248: "io_submit",
		249: "io_cancel",
		250: "fadvise64",
		252: "exit_group",
		253: "lookup_dcookie",
		254: "epoll_create",
		255: "epoll_ctl",
		256: "epoll_wait",
		257: "remap_file_pages",
		258: "set_tid_address",
		259: "timer_create",
		260: "timer_settime",
		261: "timer_gettime",
		262: "timer_getoverrun",
		263: "timer_delete",
		264: "clock_settime",
		265: "clock_gettime",
		266: "clock_getres",
		267: "clock_nanosleep",
		268: "statfs64",
		269: "fstatfs64",
		270: "tgkill",
		271: "utimes",
		272: "fadvise64_64",
		273: "vserver",
		274: "mbind",
		275: "get_mempolicy",
		276: "set_mempolicy",
		277: "mq_open",
		278: "mq_unlink",
		279: "mq_timedsend",
		280: "mq_timedreceive",
		281: "mq_notify",
		282: "mq_getsetattr",
		283: "sys_kexec_load",
		284: "waitid",
		286: "add_key",
		287: "request_key",
		288: "keyctl",
		289: "ioprio_set",
		290: "ioprio_get",
		291: "inotify_init",
		292: "inotify_add_watch",
		293: "inotify_rm_watch",
		294: "migrate_pages",
		295: "openat",
		296: "mkdirat",
		297: "mknodat",
		298: "fchownat",
		299: "futimesat",
		300: "fstatat64",
		301: "unlinkat",
		302: "renameat",
		303: "linkat",
		304: "symlinkat",
		305: "readlinkat",
		306: "fchmodat",
		307: "faccessat",
		308: "pselect6",
		309: "ppoll",
		310: "unshare",
		311: "set_robust_list",
		312: "get_robust_list",
		313: "splice",
		314: "sync_file_range",
		315: "tee",
		316: "vmsplice",
		317: "move_pages",
		318: "getcpu",
		319: "epoll_pwait",
		320: "utimensat",
		321: "signalfd",
		322: "timerfd_create",
		323: "eventfd",
		324: "fallocate",
		325: "timerfd_settime",
		326: "timerfd_gettime",
		327: "signalfd4",
		328: "eventfd2",
		329: "epoll_create1",
		330: "dup3",
		331: "pipe2",
		332: "inotify_init1",
		333: "preadv",
		334: "pwritev",
		335: "rt_tgsigqueueinfo",
		336: "perf_event_open",
		337: "recvmmsg",
		338: "fanotify_init",
		339: "fanotify_mark",
		340: "prlimit64",
		341: "name_to_handle_at",
		342: "open_by_handle_at",
		343: "clock_adjtime",
		344: "syncfs",
		345: "sendmmsg",
		346: "setns",
		347: "process_vm_readv",
		348: "process_vm_writev",
		349: "kcmp",
		350: "finit_module",
		351: "sched_setattr",
		352: "sched_getattr",
		353: "renameat2",
		354: "seccomp",
		355: "getrandom",
		356: "memfd_create",
		357: "bpf",
		358: "execveat",
		359: "socket",
		360: "socketpair",
		361: "bind",
		362: "connect",
		363: "listen",
		364: "accept4",
		365: "getsockopt",
		366: "setsockopt",
		367: "getsockname",
		368: "getpeername",
		369: "sendto",
		370: "sendmsg",
		371: "recvfrom",
		372: "recvmsg",
		373: "shutdown",
		374: "userfaultfd",
		375: "membarrier",
		376: "mlock2",
		377: "copy_file_range",
		378: "preadv2",
		379: "pwritev2",
		380: "pkey_mprotect",
		381: "pkey_alloc",
		382: "pkey_free",
		383: "statx",
		384: "arch_prctl",
		385: "io_pgetevents",
		386: "rseq",
		393: "semget",
		394: "semctl",
		395: "shmget",
		396: "shmctl",
		397: "shmat",
		398: "shmdt",
		399: "msgget",
		400: "msgsnd",
		401: "msgrcv",
		402: "msgctl",
		403: "clock_gettime64",
		404: "clock_settime64",
		405: "clock_adjtime64",
		406: "clock_getres_time64",
		407: "clock_nanosleep_time64",
		408: "timer_gettime64",
		409: "timer_settime64",
		410: "timerfd_gettime64",
		411: "timerfd_settime64",
		412: "utimensat_time64",
		413: "pselect6_time64",
		414: "ppoll_time64",
		416: "io_pgetevents_time64",
		417: "recvmmsg_time64",
		418: "mq_timedsend_time64",
		419: "mq_timedreceive_time64",
		420: "semtimedop_time64",
		421: "rt_sigtimedwait_time64",
		422: "futex_time64",
		423: "sched_rr_get_interval64",
		424: "pidfd_send_signal",
		425: "io_uring_setup",
		426: "io_uring_enter",
		427: "io_uring_register",
		428: "open_tree",
		429: "move_mount",
		430: "fsopen",
		431: "fsconfig",
		432: "fsmount",
		433: "fspick",
		434: "pidfd_open",
		435: "clone3",
		436: "close_range",
		437: "openat2",
		438: "pidfd_getfd",
		439: "faccessat2",
		440: "process_madvise",
		441: "epoll_pwait2",
		442: "mount_setattr",
		443: "quotactl_fd",
		444: "landlock_create_ruleset",
		445: "landlock_add_rule",
		446: "landlock_restrict_self",
		447: "memfd_secret",
		448: "process_mrelease",
		449: "futex_waitv",
		450: "set_mempolicy_home_node",
		451: "cachestat",
		452: "fchmodat2",
		453: "map_shadow_stack",
		454: "futex_wake",
		455: "futex_wait",
		456: "futex_requeue",
		457: "statmount",
		458: "listmount",
		459: "lsm_get_self_attr",
		460: "lsm_set_self_attr",
		461: "lsm_list_modules",
		462: "mseal",
	},
	"ppc": {
		1:   "exit",
		2:   "fork",
		3:   "read",
		4:   "write",
		5:   "open",
		6:   "close",
		7:   "waitpid",
		8:   "creat",
		9:   "link",
		10:  "unlink",
		11:  "execve",
		12:  "chdir",
		13:  "time",
		14:  "mknod",
		15:  "chmod",
		16:  "lchown",
		17:  "break",
		18:  "oldstat",
		19:  "lseek",
		20:  "getpid",
		21:  "mount",
		22:  "umount",
		23:  "setuid",
		24:  "getuid",
		25:  "stime",
		26:  "ptrace",
		27:  "alarm",
		28:  "oldfstat",
		29:  "pause",
		30:  "utime",
		31:  "stty",
		32:  "gtty",
		33:  "access",
		34:  "nice",
		35:  "ftime",
		36:  "sync",
		37:  "kill",
		38:  "rename",
		39:  "mkdir",
		40:  "rmdir",
		41:  "dup",
		42:  "pipe",
		43:  "times",
		44:  "prof",
		45:  "brk",
		46:  "setgid",
		47:  "getgid",
		48:  "signal",
		49:  "geteuid",
		50:  "getegid",
		51:  "acct",
		52:  "umount2",
		53:  "lock",
		54:  "ioctl",
		55:  "fcntl",
		56:  "mpx",
		57:  "setpgid",
		58:  "ulimit",
		59:  "oldolduname",
		60:  "umask",
		61:  "chroot",
		62:  "ustat",
		63:  "dup2",
		64:  "getppid",
		65:  "getpgrp",
		66:  "setsid",
		67:  "sigaction",
		68:  "sgetmask",
		69:  "ssetmask",
		70:  "setreuid",
		71:  "setregid",
		72:  "sigsuspend",
		73:  "sigpending",
		74:  "sethostname",
		75:  "setrlimit",
		76:  "getrlimit",
		77:  "getrusage",
		78:  "gettimeofday",
		79:  "settimeofday",
		80:  "getgroups",
		81:  "setgroups",
		82:  "select",
		83:  "symlink",
		84:  "oldlstat",
		85:  "readlink",
		86:  "uselib",
		87:  "swapon",
		88:  "reboot",
		89:  "readdir",
		90:  "mmap",
		91:  "munmap",
		92:  "truncate",
		93:  "ftruncate",
		94:  "fchmod",
		95:  "fchown",
		96:  "getpriority",
		97:  "setpriority",
		98:  "profil",
		99:  "statfs",
		100: "fstatfs",
		101: "ioperm",
		102: "socketcall",
		103: "syslog",
		104: "setitimer",
		105: "getitimer",
		106: "stat",
		107: "lstat",
		108: "fstat",
		109: "olduname",
		110: "iopl",
		111: "vhangup",
		112: "idle",
		113: "vm86",
		114: "wait4",
		115: "swapoff",
		116: "sysinfo",
		117: "ipc",
		118: "fsync",
		119: "sigreturn",
		120: "clone",
		121: "setdomainname",
		122: "uname",
		123: "modify_ldt",
		124: "adjtimex",
		125: "mprotect",
		126: "sigprocmask",
		127: "create_module",
		128: "init_module",
		129: "delete_module",
		130: "get_kernel_syms",
		131: "quotactl",
		132: "getpgid",
		133: "fchdir",
		134: "bdflush",
		135: "sysfs",
		136: "personality",
		137: "afs_syscall",
		138: "setfsuid",
		139: "setfsgid",
		140: "_llseek",
		141: "getdents",
		142: "_newselect",
		143: "flock",
		144: "msync",
		145: "readv",
		146: "writev",
		147: "getsid",
		148: "fdatasync",
		149: "_sysctl",
		150: "mlock",
		151: "munlock",
		152: "mlockall",
		153: "munlockall",
		154: "sched_setparam",
		155: "sched_getparam",
		156: "sched_setscheduler",
		157: "sched_getscheduler",
		158: "sched_yield",
		159: "sched_get_priority_max",
		160: "sched_get_priority_min",
		161: "sched_rr_get_interval",
		162: "nanosleep",
		163: "mremap",
		164: "setresuid",
		165: "getresuid",
		166: "query_module",
		167: "poll",
		168: "nfsservctl",
		169: "setresgid",
		170: "getresgid",
		171: "prctl",
		172: "rt_sigreturn",
		173: "rt_sigaction",
		174: "rt_sigprocmask",
		175: "rt_sigpending",
		176: "rt_sigtimedwait",
		177: "rt_sigqueueinfo",
		178: "rt_sigsuspend",
		179: "pread",
		180: "pwrite",
		181: "chown",
		182: "getcwd",
		183: "capget",
		184: "capset",
		185: "sigaltstack",
		186: "sendfile",
		187: "getpmsg",
		188: "putpmsg",
		189: "vfork",
		190: "ugetrlimit",
		191: "readahead",
		192: "mmap2",
		193: "truncate64",
		194: "ftruncate64",
		195: "stat64",
		196: "lstat64",
		197: "fstat64",
		198: "pciconfig_read",
		199: "pciconfig_write",
		200: "pciconfig_iobase",
		201: "multiplexer",
		202: "getdents64",
		203: "pivot_root",
		204: "fcntl64",
		205: "madvise",
		206: "mincore",
		207: "gettid",
		208: "tkill",
		209: "setxattr",
		210: "lsetxattr",
		211: "fsetxattr",
		212: "getxattr",
		213: "lgetxattr",
		214: "fgetxattr",
		215: "listxattr",
		216: "llistxattr",
		217: "flistxattr",
		218: "removexattr",
		219: "lremovexattr",
		220: "fremovexattr",
		221: "futex",
		222: "sched_setaffinity",
		223: "sched_getaffinity",
		225: "tuxcall",
		226: "sendfile64",
		227: "io_setup",
		228: "io_destroy",
		229: "io_getevents",
		230: "io_submit",
		231: "io_cancel",
		232: "set_tid_address",
		233: "fadvise64",
		234: "exit_group",
		235: "lookup_dcookie",
		236: "epoll_create",
		237: "epoll_ctl",
		238: "epoll_wait",
		239: "remap_file_pages",
		240: "timer_create",
		241: "timer_settime",
		242: "timer_gettime",
		243: "timer_getoverrun",
		244: "timer_delete",
		245: "clock_settime",
		246: "clock_gettime",
		247: "clock_getres",
		248: "clock_nanosleep",
		249: "swapcontext",
		250: "tgkill",
		251: "utimes",
		252: "statfs64",
		253: "fstatfs64",
		254: "fadvise64_64",
		255: "rtas",
		262: "mq_open",
		263: "mq_unlink",
		264: "mq_timedsend",
		265: "mq_timedreceive",
		266: "mq_notify",
		267: "mq_getsetattr",
		268: "kexec_load",
		269: "add_key",
		270: "request_key",
		271: "keyctl",
		272: "waitid",
		273: "ioprio_set",
		274: "ioprio_get",
		275: "inotify_init",
		276: "inotify_add_watch",
		277: "inotify_rm_watch",
		278: "spu_run",
		279: "spu_create",
		280: "pselect6",
		281: "ppoll",
		282: "unshare",
		283: "splice",
		284: "tee",
		285: "vmsplice",
		286: "openat",
		287: "mkdirat",
		288: "mknodat",
		289: "fchownat",
		290: "futimesat",
		291: "fstatat64",
		292: "unlinkat",
		293: "renameat",
		294: "linkat",
		295: "symlinkat",
		296: "readlinkat",
		297: "fchmodat",
		298: "faccessat",
		299: "get_robust_list",
		300: "set_robust_list",
		301: "move_pages",
		302: "getcpu",
		303: "epoll_pwait",
		304: "utimensat",
		305: "signalfd",
		306: "timerfd",
		307: "eventfd",
		308: "sync_file_range2",
		309: "fallocate",
		310: "subpage_prot",
		311: "timerfd_settime",
		312: "timerfd_gettime",
		313: "signalfd4",
		314: "eventfd2",
		315: "epoll_create1",
		316: "dup3",
		317: "pipe2",
		318: "inotify_init1",
		319: "perf_counter_open",
		320: "preadv",
		321: "pwritev",
		322: "rt_tgsigqueueinfo",
		323: "fanotify_init",
		324: "fanotify_mark",
		325: "prlimit64",
		326: "socket",
		327: "bind",
		328: "connect",
		329: "listen",
		330: "accept",
		331: "getsockname",
		332: "getpeername",
		333: "socketpair",
		334: "send",
		335: "sendto",
		336: "recv",
		337: "recvfrom",
		338: "shutdown",
		339: "setsockopt",
		340: "getsockopt",
		341: "sendmsg",
		342: "recvmsg",
		343: "recvmmsg",
		344: "accept4",
		345: "name_to_handle_at",
		346: "open_by_handle_at",
		347: "clock_adjtime",
		348: "syncfs",
		349: "sendmmsg",
		350: "setns",
		351: "process_vm_readv",
		352: "process_vm_writev",
		353: "finit_module",
		354: "kcmp",
		355: "sched_setattr",
		356: "sched_getattr",
		357: "renameat2",
		358: "seccomp",
		359: "getrandom",
		360: "memfd_create",
		361: "bpf",
		362: "execveat",
		363: "switch_endian",
		364: "userfaultfd",
		365: "membarrier",
		378: "mlock2",
		379: "copy_file_range",
		380: "preadv2",
		381: "pwritev2",
		382: "kexec_file_load",
		383: "statx",
		384: "pkey_alloc",
		385: "pkey_free",
		386: "pkey_mprotect",
		387: "rseq",
		388: "io_pgetevents",
		392: "semtimedop",
		393: "semget",
		394: "semctl",
		395: "shmget",
		396: "shmctl",
		397: "shmat",
		398: "shmdt",
		399: "msgget",
		400: "msgsnd",
		401: "msgrcv",
		402: "msgctl",
		403: "clock_gettime64",
		404: "clock_settime64",
		405: "clock_adjtime64",
		406: "clock_getres_time64",
		407: "clock_nanosleep_time64",
		408: "timer_gettime64",
		409: "timer_settime64",
		410: "timerfd_gettime64",
		411: "timerfd_settime64",
		412: "utimensat_time64",
		413: "pselect6_time64",
		414: "ppoll_time64",
		416: "io_pgetevents_time64",
		417: "recvmmsg_time64",
		418: "mq_timedsend_time64",
		419: "mq_timedreceive_time64",
		420: "semtimedop_time64",
		421: "rt_sigtimedwait_time64",
		422: "futex_time64",
		423: "sched_rr_get_interval_time64",
		424: "pidfd_send_signal",
		425: "io_uring_setup",
		426: "io_uring_enter",
		427: "io_uring_register",
		428: "open_tree",
		429: "move_mount",
		430: "fsopen",
		431: "fsconfig",
		432: "fsmount",
		433: "fspick",
		434: "pidfd_open",
		435: "clone3",
		436: "close_range",
		437: "openat2",
		438: "pidfd_getfd",
		439: "faccessat2",
		440: "process_madvise",
		441: "epoll_pwait2",
		442: "mount_setattr",
		443: "quotactl_fd",
		444: "landlock_create_ruleset",
		445: "landlock_add_rule",
		446: "landlock_restrict_self",
		448: "process_mrelease",
		449: "futex_waitv",
		450: "set_mempolicy_home_node",
		451: "cachestat",
		452: "fchmodat2",
		453: "map_shadow_stack",
		454: "futex_wake",
		455: "futex_wait",
		456: "futex_requeue",
		457: "statmount",
		458: "listmount",
		459: "lsm_get_self_attr",
		460: "lsm_set_self_attr",
		461: "lsm_list_modules",
		462: "mseal",
	},
	"s390": {
		1:   "exit",
		2:   "fork",
		3:   "read",
		4:   "write",
		5:   "open",
		6:   "close",
		8:   "creat",
		9:   "link",
		10:  "unlink",
		11:  "execve",
		12:  "chdir",
		13:  "time",
		14:  "mknod",
		15:  "chmod",
		16:  "lchown",
		19:  "lseek",
		20:  "getpid",
		21:  "mount",
		22:  "umount",
		23:  "setuid",
		24:  "getuid",
		25:  "stime",
		26:  "ptrace",
		27:  "alarm",
		29:  "pause",
		30:  "utime",
		33:  "access",
		34:  "nice",
		36:  "sync",
		37:  "kill",
		38:  "rename",
		39:  "mkdir",
		40:  "rmdir",
		41:  "dup",
		42:  "pipe",
		43:  "times",
		45:  "brk",
		46:  "setgid",
		47:  "getgid",
		48:  "signal",
		49:  "geteuid",
		50:  "getegid",
		51:  "acct",
		52:  "umount2",
		54:  "ioctl",
		55:  "fcntl",
		57:  "setpgid",
		60:  "umask",
		61:  "chroot",
		62:  "ustat",
		63:  "dup2",
		64:  "getppid",
		65:  "getpgrp",
		66:  "setsid",
		67:  "sigaction",
		70:  "setreuid",
		71:  "setregid",
		72:  "sigsuspend",
		73:  "sigpending",
		74:  "sethostname",
		75:  "setrlimit",
		76:  "getrlimit",
		77:  "getrusage",
		78:  "gettimeofday",
		79:  "settimeofday",
		80:  "getgroups",
		81:  "setgroups",
		83:  "symlink",
		85:  "readlink",
		86:  "uselib",
		87:  "swapon",
		88:  "reboot",
		89:  "readdir",
		90:  "mmap",
		91:  "munmap",
		92:  "truncate",
		93:  "ftruncate",
		94:  "fchmod",
		95:  "fchown",
		96:  "getpriority",
		97:  "setpriority",
		99:  "statfs",
		100: "fstatfs",
		101: "ioperm",
		102: "socketcall",
		103: "syslog",
		104: "setitimer",
		105: "getitimer",
		106: "stat",
		107: "lstat",
		108: "fstat",
		111: "vhangup",
		112: "idle",
		114: "wait4",
		115: "swapoff",
		116: "sysinfo",
		117: "ipc",
		118: "fsync",
		119: "sigreturn",
		120: "clone",
		121: "setdomainname",
		122: "uname",
		124: "adjtimex",
		125: "mprotect",
		126: "sigprocmask",
		127: "create_module",
		128: "init_module",
		129: "delete_module",
		130: "get_kernel_syms",
		131: "quotactl",
		132: "getpgid",
		133: "fchdir",
		134: "bdflush",
		135: "sysfs",
		136: "personality",
		137: "afs_syscall",
		138: "setfsuid",
		139: "setfsgid",
		140: "_llseek",
		141: "getdents",
		142: "_newselect",
		143: "flock",
		144: "msync",
		145: "readv",
		146: "writev",
		147: "getsid",
		148: "fdatasync",
		149: "_sysctl",
		150: "mlock",
		151: "munlock",
		152: "mlockall",
		153: "munlockall",
		154: "sched_setparam",
		155: "sched_getparam",
		156: "sched_setscheduler",
		157: "sched_getscheduler",
		158: "sched_yield",
		159: "sched_get_priority_max",
		160: "sched_get_priority_min",
		161: "sched_rr_get_interval",
		162: "nanosleep",
		163: "mremap",
		164: "setresuid",
		165: "getresuid",
		167: "query_module",
		168: "poll",
		169: "nfsservctl",
		170: "setresgid",
		171: "getresgid",
		172: "prctl",
		173: "rt_sigreturn",
		174: "rt_sigaction",
		175: "rt_sigprocmask",
		176: "rt_sigpending",
		177: "rt_sigtimedwait",
		178: "rt_sigqueueinfo",
		179: "rt_sigsuspend",
		180: "pread",
		181: "pwrite",
		182: "chown",
		183: "getcwd",
		184: "capget",
		185: "capset",
		186: "sigaltstack",
		187: "sendfile",
		188: "getpmsg",
		189: "putpmsg",
		190: "vfork",
		191: "ugetrlimit",
		192: "mmap2",
		193: "truncate64",
		194: "ftruncate64",
		195: "stat64",
		196: "lstat64",
		197: "fstat64",
		198: "lchown32",
		199: "getuid32",
		200: "getgid32",
		201: "geteuid32",
		202: "getegid32",
		203: "setreuid32",
		204: "setregid32",
		205: "getgroups32",
		206: "setgroups32",
		207: "fchown32",
		208: "setresuid32",
		209: "getresuid32",
		210: "setresgid32",
		211: "getresgid32",
		212: "chown32",
		213: "setuid32",
		214: "setgid32",
		215: "setfsuid32",
		216: "setfsgid32",
		217: "pivot_root",
		218: "mincore",
		219: "madvise",
		220: "getdents64",
		221: "fcntl64",
		222: "readahead",
		223: "sendfile64",
		224: "setxattr",
		225: "lsetxattr",
		226: "fsetxattr",
		227: "getxattr",
		228: "lgetxattr",
		229: "fgetxattr",
		230: "listxattr",
		231: "llistxattr",
		232: "flistxattr",
		233: "removexattr",
		234: "lremovexattr",
		235: "fremovexattr",
		236: "gettid",
		237: "tkill",
		238: "futex",
		239: "sched_setaffinity",
		240: "sched_getaffinity",
		241: "tgkill",
		243: "io_setup",
		244: "io_destroy",
		245: "io_getevents",
		246: "io_submit",
		247: "io_cancel",
		248: "exit_group",
		249: "epoll_create",
		250: "epoll_ctl",
		251: "epoll_wait",
		252: "set_tid_address",
		253: "fadvise64",
		254: "timer_create",
		255: "timer_settime",
		256: "timer_gettime",
		257: "timer_getoverrun",
		258: "timer_delete",
		259: "clock_settime",
		260: "clock_gettime",
		261: "clock_getres",
		262: "clock_nanosleep",
		264: "fadvise64_64",
		265: "statfs64",
		266: "fstatfs64",
		267: "remap_file_pages",
		271: "mq_open",
		272: "mq_unlink",
		273: "mq_timedsend",
		274: "mq_timedreceive",
		275: "mq_notify",
		276: "mq_getsetattr",
		277: "kexec_load",
		278: "add_key",
		279: "request_key",
		280: "keyctl",
		281: "waitid",
		282: "ioprio_set",
		283: "ioprio_get",
		284: "inotify_init",
		285: "inotify_add_watch",
		286: "inotify_rm_watch",
		288: "openat",
		289: "mkdirat",
		290: "mknodat",
		291: "fchownat",
		292: "futimesat",
		293: "fstatat64",
		294: "unlinkat",
		295: "renameat",
		296: "linkat",
		297: "symlinkat",
		298: "readlinkat",
		299: "fchmodat",
		300: "faccessat",
		301: "pselect6",
		302: "ppoll",
		303: "unshare",
		304: "set_robust_list",
		305: "get_robust_list",
		306: "splice",
		307: "sync_file_range",
		308: "tee",
		309: "vmsplice",
		311: "getcpu",
		312: "epoll_pwait",
		313: "utimes",
		314: "fallocate",
		315: "utimensat",
		316: "signalfd",
		317: "timerfd",
		318: "eventfd",
		319: "timerfd_create",
		320: "timerfd_settime",
		321: "timerfd_gettime",
		322: "signalfd4",
		323: "eventfd2",
		324: "inotify_init1",
		325: "pipe2",
		326: "dup3",
		327: "epoll_create1",
		328: "preadv",
		329: "pwritev",
		330: "rt_tgsigqueueinfo",
		331: "perf_event_open",
		332: "fanotify_init",
		333: "fanotify_mark",
		334: "prlimit64",
		335: "name_to_handle_at",
		336: "open_by_handle_at",
		337: "clock_adjtime",
		338: "syncfs",
		339: "setns",
		340: "process_vm_readv",
		341: "process_vm_writev",
		342: "s390_runtime_instr",
		343: "kcmp",
		344: "finit_module",
		345: "sched_setattr",
		346: "sched_getattr",
		347: "renameat2",
		348: "seccomp",
		349: "getrandom",
		350: "memfd_create",
		351: "bpf",
		352: "s390_pci_mmio_write",
		353: "s390_pci_mmio_read",
		354: "execveat",
		355: "userfaultfd",
		356: "membarrier",
		357: "recvmmsg",
		358: "sendmmsg",
		359: "socket",
		360: "socketpair",
		361: "bind",
		362: "connect",
		363: "listen",
		364: "accept4",
		365: "getsockopt",
		366: "setsockopt",
		367: "getsockname",
		368: "getpeername",
		369: "sendto",
		370: "sendmsg",
		371: "recvfrom",
		372: "recvmsg",
		373: "shutdown",
		374: "mlock2",
		375: "copy_file_range",
		376: "preadv2",
		377: "pwritev2",
		379: "statx",
		380: "s390_sthyi",
		381: "kexec_file_load",
		382: "io_pgetevents",
		383: "rseq",
		384: "pkey_mprotect",
		385: "pkey_alloc",
		386: "pkey_free",
		424: "pidfd_send_signal",
		425: "io_uring_setup",
		426: "io_uring_enter",
		427: "io_uring_register",
		428: "open_tree",
		429: "move_mount",
		430: "fsopen",
		431: "fsconfig",
		432: "fsmount",
		433: "fspick",
		434: "pidfd_open",
		435: "clone3",
		436: "close_range",
		437: "openat2",
		438: "pidfd_getfd",
		439: "faccessat2",
		440: "process_madvise",
		441: "epoll_pwait2",
		442: "mount_setattr",
		443: "quotactl_fd",
		444: "landlock_create_ruleset",
		445: "landlock_add_rule",
		446: "landlock_restrict_self",
		448: "process_mrelease",
		449: "futex_waitv",
		450: "set_mempolicy_home_node",
		451: "cachestat",
		452: "fchmodat2",
		453: "map_shadow_stack",
		454: "futex_wake",
		455: "futex_wait",
		456: "futex_requeue",
		457: "statmount",
		458: "listmount",
		459: "lsm_get_self_attr",
		460: "lsm_set_self_attr",
		461: "lsm_list_modules",
		462: "mseal",
	},
	"s390x": {
		1:   "exit",
		2:   "fork",
		3:   "read",
		4:   "write",
		5:   "open",
		6:   "close",
		8:   "creat",
		9:   "link",
		10:  "unlink",
		11:  "execve",
		12:  "chdir",
		14:  "mknod",
		15:  "chmod",
		19:  "lseek",
		20:  "getpid",
		21:  "mount",
		22:  "umount",
		26:  "ptrace",
		27:  "alarm",
		29:  "pause",
		30:  "utime",
		33:  "access",
		34:  "nice",
		36:  "sync",
		37:  "kill",
		38:  "rename",
		39:  "mkdir",
		40:  "rmdir",
		41:  "dup",
		42:  "pipe",
		43:  "times",
		45:  "brk",
		48:  "signal",
		51:  "acct",
		52:  "umount2",
		54:  "ioctl",
		55:  "fcntl",
		57:  "setpgid",
		60:  "umask",
		61:  "chroot",
		62:  "ustat",
		63:  "dup2",
		64:  "getppid",
		65:  "getpgrp",
		66:  "setsid",
		67:  "sigaction",
		72:  "sigsuspend",
		73:  "sigpending",
		74:  "sethostname",
		75:  "setrlimit",
		77:  "getrusage",
		78:  "gettimeofday",
		79:  "settimeofday",
		83:  "symlink",
		85:  "readlink",
		86:  "uselib",
		87:  "swapon",
		88:  "reboot",
		89:  "readdir",
		90:  "mmap",
		91:  "munmap",
		92:  "truncate",
		93:  "ftruncate",
		94:  "fchmod",
		96:  "getpriority",
		97:  "setpriority",
		99:  "statfs",
		100: "fstatfs",
		102: "socketcall",
		103: "syslog",
		104: "setitimer",
		105: "getitimer",
		106: "stat",
		107: "lstat",
		108: "fstat",
		111: "vhangup",
		112: "idle",
		114: "wait4",
		115: "swapoff",
		116: "sysinfo",
		117: "ipc",
		118: "fsync",
		119: "sigreturn",
		120: "clone",
		121: "setdomainname",
		122: "uname",
		124: "adjtimex",
		125: "mprotect",
		126: "sigprocmask",
		127: "create_module",
		128: "init_module",
		129: "delete_module",
		130: "get_kernel_syms",
		131: "quotactl",
		132: "getpgid",
		133: "fchdir",
		134: "bdflush",
		135: "sysfs",
		136: "personality",
		137: "afs_syscall",
		141: "getdents",
		142: "select",
		143: "flock",
		144: "msync",
		145: "readv",
		146: "writev",
		147: "getsid",
		148: "fdatasync",
		149: "_sysctl",
		150: "mlock",
		151: "munlock",
		152: "mlockall",
		153: "munlockall",
		154: "sched_setparam",
		155: "sched_getparam",
		156: "sched_setscheduler",
		157: "sched_getscheduler",
		158: "sched_yield",
		159: "sched_get_priority_max",
		160: "sched_get_priority_min",
		161: "sched_rr_get_interval",
		162: "nanosleep",
		163: "mremap",
		167: "query_module",
		168: "poll",
		169: "nfsservctl",
		172: "prctl",
		173: "rt_sigreturn",
		174: "rt_sigaction",
		175: "rt_sigprocmask",
		176: "rt_sigpending",
		177: "rt_sigtimedwait",
		178: "rt_sigqueueinfo",
		179: "rt_sigsuspend",
		180: "pread",
		181: "pwrite",
		183: "getcwd",
		184: "capget",
		185: "capset",
		186: "sigaltstack",
		187: "sendfile",
		188: "getpmsg",
		189: "putpmsg",
		190: "vfork",
		191: "getrlimit",
		198: "lchown",
		199: "getuid",
		200: "getgid",
		201: "geteuid",
		202: "getegid",
		203: "setreuid",
		204: "setregid",
		205: "getgroups",
		206: "setgroups",
		207: "fchown",
		208: "setresuid",
		209: "getresuid",
		210: "setresgid",
		211: "getresgid",
		212: "chown",
		213: "setuid",
		214: "setgid",
		215: "setfsuid",
		216: "setfsgid",
		217: "pivot_root",
		218: "mincore",
		219: "madvise",
		222: "readahead",
		224: "setxattr",
		225: "lsetxattr",
		226: "fsetxattr",
		227: "getxattr",
		228: "lgetxattr",
		229: "fgetxattr",
		230: "listxattr",
		231: "llistxattr",
		232: "flistxattr",
		233: "removexattr",
		234: "lremovexattr",
		235: "fremovexattr",
		236: "gettid",
		237: "tkill",
		238: "futex",
		239: "sched_setaffinity",
		240: "sched_getaffinity",
		241: "tgkill",
		243: "io_setup",
		244: "io_destroy",
		245: "io_getevents",
		246: "io_submit",
		247: "io_cancel",
		248: "exit_group",
		249: "epoll_create",
		250: "epoll_ctl",
		251: "epoll_wait",
		252: "set_tid_address",
		253: "fadvise64",
		254: "timer_create",
		255: "timer_settime",
		256: "timer_gettime",
		257: "timer_getoverrun",
		258: "timer_delete",
		259: "clock_settime",
		260: "clock_gettime",
		261: "clock_getres",
		262: "clock_nanosleep",
		265: "statfs64",
		266: "fstatfs64",
		267: "remap_file_pages",
		271: "mq_open",
		272: "mq_unlink",
		273: "mq_timedsend",
		274: "mq_timedreceive",
		275: "mq_notify",
		276: "mq_getsetattr",
		277: "kexec_load",
		278: "add_key",
		279: "request_key",
		280: "keyctl",
		281: "waitid",
		282: "ioprio_set",
		283: "ioprio_get",
		284: "inotify_init",
		285: "inotify_add_watch",
		286: "inotify_rm_watch",
		288: "openat",
		289: "mkdirat",
		290: "mknodat",
		291: "fchownat",
		292: "futimesat",
		293: "newfstatat",
		294: "unlinkat",
		295: "renameat",
		296: "linkat",
		297: "symlinkat",
		298: "readlinkat",
		299: "fchmodat",
		300: "faccessat",
		301: "pselect6",
		302: "ppoll",
		303: "unshare",
		304: "set_robust_list",
		305: "get_robust_list",
		306: "splice",
		307: "sync_file_range",
		308: "tee",
		309: "vmsplice",
		311: "getcpu",
		312: "epoll_pwait",
		313: "utimes",
		314: "fallocate",
		315: "utimensat",
		316: "signalfd",
		317: "timerfd",
		318: "eventfd",
		319: "timerfd_create",
		320: "timerfd_settime",
		321: "timerfd_gettime",
		322: "signalfd4",
		323: "eventfd2",
		324: "inotify_init1",
		325: "pipe2",
		326: "dup3",
		327: "epoll_create1",
		328: "preadv",
		329: "pwritev",
		330: "rt_tgsigqueueinfo",
		331: "perf_event_open",
		332: "fanotify_init",
		333: "fanotify_mark",
		334: "prlimit64",
		335: "name_to_handle_at",
		336: "open_by_handle_at",
		337: "clock_adjtime",
		338: "syncfs",
		339: "setns",
		340: "process_vm_readv",
		341: "process_vm_writev",
		342: "s390_runtime_instr",
		343: "kcmp",
		344: "finit_module",
		345: "sched_setattr",
		346: "sched_getattr",
		347: "renameat2",
		348: "seccomp",
		349: "getrandom",
		350: "memfd_create",
		351: "bpf",
		352: "s390_pci_mmio_write",
		353: "s390_pci_mmio_read",
		354: "execveat",
		355: "userfaultfd",
		356: "membarrier",
		357: "recvmmsg",
		358: "sendmmsg",
		359: "socket",
		360: "socketpair",
		361: "bind",
		362: "connect",
		363: "listen",
		364: "accept4",
		365: "getsockopt",
		366: "setsockopt",
		367: "getsockname",
		368: "getpeername",
		369: "sendto",
		370: "sendmsg",
		371: "recvfrom",
		372: "recvmsg",
		373: "shutdown",
		374: "mlock2",
		375: "copy_file_range",
		376: "preadv2",
		377: "pwritev2",
		379: "statx",
		380: "s390_sthyi",
		381: "kexec_file_load",
		382: "io_pgetevents",
		383: "rseq",
		384: "pkey_mprotect",
		385: "pkey_alloc",
		386: "pkey_free",
		424: "pidfd_send_signal",
		425: "io_uring_setup",
		426: "io_uring_enter",
		427: "io_uring_register",
		428: "open_tree",
		429: "move_mount",
		430: "fsopen",
		431: "fsconfig",
		432: "fsmount",
		433: "fspick",
		434: "pidfd_open",
		435: "clone3",
		436: "close_range",
		437: "openat2",
		438: "pidfd_getfd",
		439: "faccessat2",
		440: "process_madvise",
		441: "epoll_pwait2",
		442: "mount_setattr",
		443: "quotactl_fd",
		444: "landlock_create_ruleset",
		445: "landlock_add_rule",
		446: "landlock_restrict_self",
		448: "process_mrelease",
		449: "futex_waitv",
		450: "set_mempolicy_home_node",
		451: "cachestat",
		452: "fchmodat2",
		453: "map_shadow_stack",
		454: "futex_wake",
		455: "futex_wait",
		456: "futex_requeue",
		457: "statmount",
		458: "listmount",
		459: "lsm_get_self_attr",
		460: "lsm_set_self_attr",
		461: "lsm_list_modules",
		462: "mseal",
	},
	"x86_64": {
		0:   "read",
		1:   "write",
		2:   "open",
		3:   "close",
		4:   "stat",
		5:   "fstat",
		6:   "lstat",
		7:   "poll",
		8:   "lseek",
		9:   "mmap",
		10:  "mprotect",
		11:  "munmap",
		12:  "brk",
		13:  "rt_sigaction",
		14:  "rt_sigprocmask",
		15:  "rt_sigreturn",
		16:  "ioctl",
		17:  "pread",
		18:  "pwrite",
		19:  "readv",
		20:  "writev",
		21:  "access",
		22:  "pipe",
		23:  "select",
		24:  "sched_yield",
		25:  "mremap",
		26:  "msync",
		27:  "mincore",
		28:  "madvise",
		29:  "shmget",
		30:  "shmat",
		31:  "shmctl",
		32:  "dup",
		33:  "dup2",
		34:  "pause",
		35:  "nanosleep",
		36:  "getitimer",
		37:  "alarm",
		38:  "setitimer",
		39:  "getpid",
		40:  "sendfile",
		41:  "socket",
		42:  "connect",
		43:  "accept",
		44:  "sendto",
		45:  "recvfrom",
		46:  "sendmsg",
		47:  "recvmsg",
		48:  "shutdown",
		49:  "bind",
		50:  "listen",
		51:  "getsockname",
		52:  "getpeername",
		53:  "socketpair",
		54:  "setsockopt",
		55:  "getsockopt",
		56:  "clone",
		57:  "fork",
		58:  "vfork",
		59:  "execve",
		60:  "exit",
		61:  "wait4",
		62:  "kill",
		63:  "uname",
		64:  "semget",
		65:  "semop",
		66:  "semctl",
		67:  "shmdt",
		68:  "msgget",
		69:  "msgsnd",
		70:  "msgrcv",
		71:  "msgctl",
		72:  "fcntl",
		73:  "flock",
		74:  "fsync",
		75:  "fdatasync",
		76:  "truncate",
		77:  "ftruncate",
		78:  "getdents",
		79:  "getcwd",
		80:  "chdir",
		81:  "fchdir",
		82:  "rename",
		83:  "mkdir",
		84:  "rmdir",
		85:  "creat",
		86:  "link",
		87:  "unlink",
		88:  "symlink",
		89:  "readlink",
		90:  "chmod",
		91:  "fchmod",
		92:  "chown",
		93:  "fchown",
		94:  "lchown",
		95:  "umask",
		96:  "gettimeofday",
		97:  "getrlimit",
		98:  "getrusage",
		99:  "sysinfo",
		100: "times",
		101: "ptrace",
		102: "getuid",
		103: "syslog",
		104: "getgid",
		105: "setuid",
		106: "setgid",
		107: "geteuid",
		108: "getegid",
		109: "setpgid",
		110: "getppid",
		111: "getpgrp",
		112: "setsid",
		113: "setreuid",
		114: "setregid",
		115: "getgroups",
		116: "setgroups",
		117: "setresuid",
		118: "getresuid",
		119: "setresgid",
		120: "getresgid",
		121: "getpgid",
		122: "setfsuid",
		123: "setfsgid",
		124: "getsid",
		125: "capget",
		126: "capset",
		127: "rt_sigpending",
		128: "rt_sigtimedwait",
		129: "rt_sigqueueinfo",
		130: "rt_sigsuspend",
		131: "sigaltstack",
		132: "utime",
		133: "mknod",
		134: "uselib",
		135: "personality",
		136: "ustat",
		137: "statfs",
		138: "fstatfs",
		139: "sysfs",
		140: "getpriority",
		141: "setpriority",
		142: "sched_setparam",
		143: "sched_getparam",
		144: "sched_setscheduler",
		145: "sched_getscheduler",
		146: "sched_get_priority_max",
		147: "sched_get_priority_min",
		148: "sched_rr_get_interval",
		149: "mlock",
		150: "munlock",
		151: "mlockall",
		152: "munlockall",
		153: "vhangup",
		154: "modify_ldt",
		155: "pivot_root",
		156: "_sysctl",
		157: "prctl",
		158: "arch_prctl",
		159: "adjtimex",
		160: "setrlimit",
		161: "chroot",
		162: "sync",
		163: "acct",
		164: "settimeofday",
		165: "mount",
		166: "umount2",
		167: "swapon",
		168: "swapoff",
		169: "reboot",
		170: "sethostname",
		171: "setdomainname",
		172: "iopl",
		173: "ioperm",
		174: "create_module",
		175: "init_module",
		176: "delete_module",
		177: "get_kernel_syms",
		178: "query_module",
		179: "quotactl",
		180: "nfsservctl",
		181: "getpmsg",
		182: "putpmsg",
		183: "afs_syscall",
		184: "tuxcall",
		185: "security",
		186: "gettid",
		187: "readahead",
		188: "setxattr",
		189: "lsetxattr",
		190: "fsetxattr",
		191: "getxattr",
		192: "lgetxattr",
		193: "fgetxattr",
		194: "listxattr",
		195: "llistxattr",
		196: "flistxattr",
		197: "removexattr",
		198: "lremovexattr",
		199: "fremovexattr",
		200: "tkill",
		201: "time",
		202: "futex",
		203: "sched_setaffinity",
		204: "sched_getaffinity",
		205: "set_thread_area",
		206: "io_setup",
		207: "io_destroy",
		208: "io_getevents",
		209: "io_submit",
		210: "io_cancel",
		211: "get_thread_area",
		212: "lookup_dcookie",
		213: "epoll_create",
		214: "epoll_ctl_old",
		215: "epoll_wait_old",
		216: "remap_file_pages",
		217: "getdents64",
		218: "set_tid_address",
		219: "restart_syscall",
		220: "semtimedop",
		221: "fadvise64",
		222: "timer_create",
		223: "timer_settime",
		224: "timer_gettime",
		225: "timer_getoverrun",
		226: "timer_delete",
		227: "clock_settime",
		228: "clock_gettime",
		229: "clock_getres",
		230: "clock_nanosleep",
		231: "exit_group",
		232: "epoll_wait",
		233: "epoll_ctl",
		234: "tgkill",
		235: "utimes",
		236: "vserver",
		237: "mbind",
		238: "set_mempolicy",
		239: "get_mempolicy",
		240: "mq_open",
		241: "mq_unlink",
		242: "mq_timedsend",
		243: "mq_timedreceive",
		244: "mq_notify",
		245: "mq_getsetattr",
		246: "kexec_load",
		247: "waitid",
		248: "add_key",
		249: "request_key",
		250: "keyctl",
		251: "ioprio_set",
		252: "ioprio_get",
		253: "inotify_init",
		254: "inotify_add_watch",
		255: "inotify_rm_watch",
		256: "migrate_pages",
		257: "openat",
		258: "mkdirat",
		259: "mknodat",
		260: "fchownat",
		261: "futimesat",
		262: "newfstatat",
		263: "unlinkat",
		264: "renameat",
		265: "linkat",
		266: "symlinkat",
		267: "readlinkat",
		268: "fchmodat",
		269: "faccessat",
		270: "pselect6",
		271: "ppoll",
		272: "unshare",
		273: "set_robust_list",
		274: "get_robust_list",
		275: "splice",
		276: "tee",
		277: "sync_file_range",
		278: "vmsplice",
		279: "move_pages",
		280: "utimensat",
		281: "epoll_pwait",
		282: "signalfd",
		283: "timerfd_create",
		284: "eventfd",
		285: "fallocate",
		286: "timerfd_settime",
		287: "timerfd_gettime",
		288: "accept4",
		289: "signalfd4",
		290: "eventfd2",
		291: "epoll_create1",
		292: "dup3",
		293: "pipe2",
		294: "inotify_init1",
		295: "preadv",
		296: "pwritev",
		297: "rt_tgsigqueueinfo",
		298: "perf_event_open",
		299: "recvmmsg",
		300: "fanotify_init",
		301: "fanotify_mark",
		302: "prlimit64",
		303: "name_to_handle_at",
		304: "open_by_handle_at",
		305: "clock_adjtime",
		306: "syncfs",
		307: "sendmmsg",
		308: "setns",
		309: "getcpu",
		310: "process_vm_readv",
		311: "process_vm_writev",
		312: "kcmp",
		313: "finit_module",
		314: "sched_setattr",
		315: "sched_getattr",
		316: "renameat2",
		317: "seccomp",
		318: "getrandom",
		319: "memfd_create",
		320: "kexec_file_load",
		321: "bpf",
		322: "execveat",
		323: "userfaultfd",
		324: "membarrier",
		325: "mlock2",
		326: "copy_file_range",
		327: "preadv2",
		328: "pwritev2",
		329: "pkey_mprotect",
		330: "pkey_alloc",
		331: "pkey_free",
		332: "statx",
		333: "io_pgetevents",
		334: "rseq",
		424: "pidfd_send_signal",
		425: "io_uring_setup",
		426: "io_uring_enter",
		427: "io_uring_register",
		428: "open_tree",
		429: "move_mount",
		430: "fsopen",
		431: "fsconfig",
		432: "fsmount",
		433: "fspick",
		434: "pidfd_open",
		435: "clone3",
		436: "close_range",
		437: "openat2",
		438: "pidfd_getfd",
		439: "faccessat2",
		440: "process_madvise",
		441: "epoll_pwait2",
		442: "mount_setattr",
		443: "quotactl_fd",
		444: "landlock_create_ruleset",
		445: "landlock_add_rule",
		446: "landlock_restrict_self",
		447: "memfd_secret",
		448: "process_mrelease",
		449: "futex_waitv",
		450: "set_mempolicy_home_node",
		451: "cachestat",
		452: "fchmodat2",
		453: "map_shadow_stack",
		454: "futex_wake",
		455: "futex_wait",
		456: "futex_requeue",
		457: "statmount",
		458: "listmount",
		459: "lsm_get_self_attr",
		460: "lsm_set_self_attr",
		461: "lsm_list_modules",
		462: "mseal",
	},
}

func init() {
	// Add "aliases" to ppc for ppc64 and ppc64le. They share the same tables.
	ppcTable, found := AuditSyscalls["ppc"]
	if !found {
		panic("missing ppc syscall table")
	}
	AuditSyscalls["ppc64"] = ppcTable
	AuditSyscalls["ppc64le"] = ppcTable
}
