// Code generated by protoc-gen-go-aip. DO NOT EDIT.
//
// versions:
// 	protoc-gen-go-aip development
// 	protoc (unknown)
// source: coinbase/cloud/blockchain/v1/blockchain.proto

package v1

import (
	fmt "fmt"
	resourcename "go.einride.tech/aip/resourcename"
	strings "strings"
)

type NetworkResourceName struct {
	NetworkId string
}

func (n NetworkResourceName) Validate() error {
	if n.NetworkId == "" {
		return fmt.Errorf("network_id: empty")
	}
	if strings.IndexByte(n.NetworkId, '/') != -1 {
		return fmt.Errorf("network_id: contains illegal character '/'")
	}
	return nil
}

func (n NetworkResourceName) ContainsWildcard() bool {
	return false || n.NetworkId == "-"
}

func (n NetworkResourceName) String() string {
	return resourcename.Sprint(
		"networks/{network_id}",
		n.NetworkId,
	)
}

func (n NetworkResourceName) MarshalString() (string, error) {
	if err := n.Validate(); err != nil {
		return "", err
	}
	return n.String(), nil
}

func (n *NetworkResourceName) UnmarshalString(name string) error {
	return resourcename.Sscan(
		name,
		"networks/{network_id}",
		&n.NetworkId,
	)
}

type AssetResourceName struct {
	NetworkId string
	AssetId   string
}

func (n NetworkResourceName) AssetResourceName(
	assetId string,
) AssetResourceName {
	return AssetResourceName{
		NetworkId: n.NetworkId,
		AssetId:   assetId,
	}
}

func (n AssetResourceName) Validate() error {
	if n.NetworkId == "" {
		return fmt.Errorf("network_id: empty")
	}
	if strings.IndexByte(n.NetworkId, '/') != -1 {
		return fmt.Errorf("network_id: contains illegal character '/'")
	}
	if n.AssetId == "" {
		return fmt.Errorf("asset_id: empty")
	}
	if strings.IndexByte(n.AssetId, '/') != -1 {
		return fmt.Errorf("asset_id: contains illegal character '/'")
	}
	return nil
}

func (n AssetResourceName) ContainsWildcard() bool {
	return false || n.NetworkId == "-" || n.AssetId == "-"
}

func (n AssetResourceName) String() string {
	return resourcename.Sprint(
		"networks/{network_id}/assets/{asset_id}",
		n.NetworkId,
		n.AssetId,
	)
}

func (n AssetResourceName) MarshalString() (string, error) {
	if err := n.Validate(); err != nil {
		return "", err
	}
	return n.String(), nil
}

func (n *AssetResourceName) UnmarshalString(name string) error {
	return resourcename.Sscan(
		name,
		"networks/{network_id}/assets/{asset_id}",
		&n.NetworkId,
		&n.AssetId,
	)
}

func (n AssetResourceName) NetworkResourceName() NetworkResourceName {
	return NetworkResourceName{
		NetworkId: n.NetworkId,
	}
}
