// Code generated by cmd/lexgen (see Makefile's lexgen); DO NOT EDIT.

package ozone

// schema: tools.ozone.moderation.defs

import (
	"encoding/json"
	"fmt"

	comatprototypes "github.com/bluesky-social/indigo/api/atproto"
	chatbskytypes "github.com/bluesky-social/indigo/api/chat"
	"github.com/bluesky-social/indigo/lex/util"
)

// ModerationDefs_BlobView is a "blobView" in the tools.ozone.moderation.defs schema.
type ModerationDefs_BlobView struct {
	Cid        string                           `json:"cid" cborgen:"cid"`
	CreatedAt  string                           `json:"createdAt" cborgen:"createdAt"`
	Details    *ModerationDefs_BlobView_Details `json:"details,omitempty" cborgen:"details,omitempty"`
	MimeType   string                           `json:"mimeType" cborgen:"mimeType"`
	Moderation *ModerationDefs_Moderation       `json:"moderation,omitempty" cborgen:"moderation,omitempty"`
	Size       int64                            `json:"size" cborgen:"size"`
}

type ModerationDefs_BlobView_Details struct {
	ModerationDefs_ImageDetails *ModerationDefs_ImageDetails
	ModerationDefs_VideoDetails *ModerationDefs_VideoDetails
}

func (t *ModerationDefs_BlobView_Details) MarshalJSON() ([]byte, error) {
	if t.ModerationDefs_ImageDetails != nil {
		t.ModerationDefs_ImageDetails.LexiconTypeID = "tools.ozone.moderation.defs#imageDetails"
		return json.Marshal(t.ModerationDefs_ImageDetails)
	}
	if t.ModerationDefs_VideoDetails != nil {
		t.ModerationDefs_VideoDetails.LexiconTypeID = "tools.ozone.moderation.defs#videoDetails"
		return json.Marshal(t.ModerationDefs_VideoDetails)
	}
	return nil, fmt.Errorf("cannot marshal empty enum")
}
func (t *ModerationDefs_BlobView_Details) UnmarshalJSON(b []byte) error {
	typ, err := util.TypeExtract(b)
	if err != nil {
		return err
	}

	switch typ {
	case "tools.ozone.moderation.defs#imageDetails":
		t.ModerationDefs_ImageDetails = new(ModerationDefs_ImageDetails)
		return json.Unmarshal(b, t.ModerationDefs_ImageDetails)
	case "tools.ozone.moderation.defs#videoDetails":
		t.ModerationDefs_VideoDetails = new(ModerationDefs_VideoDetails)
		return json.Unmarshal(b, t.ModerationDefs_VideoDetails)

	default:
		return nil
	}
}

// ModerationDefs_ImageDetails is a "imageDetails" in the tools.ozone.moderation.defs schema.
//
// RECORDTYPE: ModerationDefs_ImageDetails
type ModerationDefs_ImageDetails struct {
	LexiconTypeID string `json:"$type,const=tools.ozone.moderation.defs#imageDetails" cborgen:"$type,const=tools.ozone.moderation.defs#imageDetails"`
	Height        int64  `json:"height" cborgen:"height"`
	Width         int64  `json:"width" cborgen:"width"`
}

// ModerationDefs_ModEventAcknowledge is a "modEventAcknowledge" in the tools.ozone.moderation.defs schema.
//
// RECORDTYPE: ModerationDefs_ModEventAcknowledge
type ModerationDefs_ModEventAcknowledge struct {
	LexiconTypeID string  `json:"$type,const=tools.ozone.moderation.defs#modEventAcknowledge" cborgen:"$type,const=tools.ozone.moderation.defs#modEventAcknowledge"`
	Comment       *string `json:"comment,omitempty" cborgen:"comment,omitempty"`
}

// ModerationDefs_ModEventComment is a "modEventComment" in the tools.ozone.moderation.defs schema.
//
// # Add a comment to a subject
//
// RECORDTYPE: ModerationDefs_ModEventComment
type ModerationDefs_ModEventComment struct {
	LexiconTypeID string `json:"$type,const=tools.ozone.moderation.defs#modEventComment" cborgen:"$type,const=tools.ozone.moderation.defs#modEventComment"`
	Comment       string `json:"comment" cborgen:"comment"`
	// sticky: Make the comment persistent on the subject
	Sticky *bool `json:"sticky,omitempty" cborgen:"sticky,omitempty"`
}

// ModerationDefs_ModEventDivert is a "modEventDivert" in the tools.ozone.moderation.defs schema.
//
// Divert a record's blobs to a 3rd party service for further scanning/tagging
//
// RECORDTYPE: ModerationDefs_ModEventDivert
type ModerationDefs_ModEventDivert struct {
	LexiconTypeID string  `json:"$type,const=tools.ozone.moderation.defs#modEventDivert" cborgen:"$type,const=tools.ozone.moderation.defs#modEventDivert"`
	Comment       *string `json:"comment,omitempty" cborgen:"comment,omitempty"`
}

// ModerationDefs_ModEventEmail is a "modEventEmail" in the tools.ozone.moderation.defs schema.
//
// # Keep a log of outgoing email to a user
//
// RECORDTYPE: ModerationDefs_ModEventEmail
type ModerationDefs_ModEventEmail struct {
	LexiconTypeID string `json:"$type,const=tools.ozone.moderation.defs#modEventEmail" cborgen:"$type,const=tools.ozone.moderation.defs#modEventEmail"`
	// comment: Additional comment about the outgoing comm.
	Comment *string `json:"comment,omitempty" cborgen:"comment,omitempty"`
	// content: The content of the email sent to the user.
	Content *string `json:"content,omitempty" cborgen:"content,omitempty"`
	// subjectLine: The subject line of the email sent to the user.
	SubjectLine string `json:"subjectLine" cborgen:"subjectLine"`
}

// ModerationDefs_ModEventEscalate is a "modEventEscalate" in the tools.ozone.moderation.defs schema.
//
// RECORDTYPE: ModerationDefs_ModEventEscalate
type ModerationDefs_ModEventEscalate struct {
	LexiconTypeID string  `json:"$type,const=tools.ozone.moderation.defs#modEventEscalate" cborgen:"$type,const=tools.ozone.moderation.defs#modEventEscalate"`
	Comment       *string `json:"comment,omitempty" cborgen:"comment,omitempty"`
}

// ModerationDefs_ModEventLabel is a "modEventLabel" in the tools.ozone.moderation.defs schema.
//
// Apply/Negate labels on a subject
//
// RECORDTYPE: ModerationDefs_ModEventLabel
type ModerationDefs_ModEventLabel struct {
	LexiconTypeID   string   `json:"$type,const=tools.ozone.moderation.defs#modEventLabel" cborgen:"$type,const=tools.ozone.moderation.defs#modEventLabel"`
	Comment         *string  `json:"comment,omitempty" cborgen:"comment,omitempty"`
	CreateLabelVals []string `json:"createLabelVals" cborgen:"createLabelVals"`
	NegateLabelVals []string `json:"negateLabelVals" cborgen:"negateLabelVals"`
}

// ModerationDefs_ModEventMute is a "modEventMute" in the tools.ozone.moderation.defs schema.
//
// # Mute incoming reports on a subject
//
// RECORDTYPE: ModerationDefs_ModEventMute
type ModerationDefs_ModEventMute struct {
	LexiconTypeID string  `json:"$type,const=tools.ozone.moderation.defs#modEventMute" cborgen:"$type,const=tools.ozone.moderation.defs#modEventMute"`
	Comment       *string `json:"comment,omitempty" cborgen:"comment,omitempty"`
	// durationInHours: Indicates how long the subject should remain muted.
	DurationInHours int64 `json:"durationInHours" cborgen:"durationInHours"`
}

// ModerationDefs_ModEventMuteReporter is a "modEventMuteReporter" in the tools.ozone.moderation.defs schema.
//
// # Mute incoming reports from an account
//
// RECORDTYPE: ModerationDefs_ModEventMuteReporter
type ModerationDefs_ModEventMuteReporter struct {
	LexiconTypeID string  `json:"$type,const=tools.ozone.moderation.defs#modEventMuteReporter" cborgen:"$type,const=tools.ozone.moderation.defs#modEventMuteReporter"`
	Comment       *string `json:"comment,omitempty" cborgen:"comment,omitempty"`
	// durationInHours: Indicates how long the account should remain muted.
	DurationInHours int64 `json:"durationInHours" cborgen:"durationInHours"`
}

// ModerationDefs_ModEventReport is a "modEventReport" in the tools.ozone.moderation.defs schema.
//
// # Report a subject
//
// RECORDTYPE: ModerationDefs_ModEventReport
type ModerationDefs_ModEventReport struct {
	LexiconTypeID string  `json:"$type,const=tools.ozone.moderation.defs#modEventReport" cborgen:"$type,const=tools.ozone.moderation.defs#modEventReport"`
	Comment       *string `json:"comment,omitempty" cborgen:"comment,omitempty"`
	// isReporterMuted: Set to true if the reporter was muted from reporting at the time of the event. These reports won't impact the reviewState of the subject.
	IsReporterMuted *bool   `json:"isReporterMuted,omitempty" cborgen:"isReporterMuted,omitempty"`
	ReportType      *string `json:"reportType" cborgen:"reportType"`
}

// ModerationDefs_ModEventResolveAppeal is a "modEventResolveAppeal" in the tools.ozone.moderation.defs schema.
//
// # Resolve appeal on a subject
//
// RECORDTYPE: ModerationDefs_ModEventResolveAppeal
type ModerationDefs_ModEventResolveAppeal struct {
	LexiconTypeID string `json:"$type,const=tools.ozone.moderation.defs#modEventResolveAppeal" cborgen:"$type,const=tools.ozone.moderation.defs#modEventResolveAppeal"`
	// comment: Describe resolution.
	Comment *string `json:"comment,omitempty" cborgen:"comment,omitempty"`
}

// ModerationDefs_ModEventReverseTakedown is a "modEventReverseTakedown" in the tools.ozone.moderation.defs schema.
//
// # Revert take down action on a subject
//
// RECORDTYPE: ModerationDefs_ModEventReverseTakedown
type ModerationDefs_ModEventReverseTakedown struct {
	LexiconTypeID string `json:"$type,const=tools.ozone.moderation.defs#modEventReverseTakedown" cborgen:"$type,const=tools.ozone.moderation.defs#modEventReverseTakedown"`
	// comment: Describe reasoning behind the reversal.
	Comment *string `json:"comment,omitempty" cborgen:"comment,omitempty"`
}

// ModerationDefs_ModEventTag is a "modEventTag" in the tools.ozone.moderation.defs schema.
//
// Add/Remove a tag on a subject
//
// RECORDTYPE: ModerationDefs_ModEventTag
type ModerationDefs_ModEventTag struct {
	LexiconTypeID string `json:"$type,const=tools.ozone.moderation.defs#modEventTag" cborgen:"$type,const=tools.ozone.moderation.defs#modEventTag"`
	// add: Tags to be added to the subject. If already exists, won't be duplicated.
	Add []string `json:"add" cborgen:"add"`
	// comment: Additional comment about added/removed tags.
	Comment *string `json:"comment,omitempty" cborgen:"comment,omitempty"`
	// remove: Tags to be removed to the subject. Ignores a tag If it doesn't exist, won't be duplicated.
	Remove []string `json:"remove" cborgen:"remove"`
}

// ModerationDefs_ModEventTakedown is a "modEventTakedown" in the tools.ozone.moderation.defs schema.
//
// # Take down a subject permanently or temporarily
//
// RECORDTYPE: ModerationDefs_ModEventTakedown
type ModerationDefs_ModEventTakedown struct {
	LexiconTypeID string `json:"$type,const=tools.ozone.moderation.defs#modEventTakedown" cborgen:"$type,const=tools.ozone.moderation.defs#modEventTakedown"`
	// acknowledgeAccountSubjects: If true, all other reports on content authored by this account will be resolved (acknowledged).
	AcknowledgeAccountSubjects *bool   `json:"acknowledgeAccountSubjects,omitempty" cborgen:"acknowledgeAccountSubjects,omitempty"`
	Comment                    *string `json:"comment,omitempty" cborgen:"comment,omitempty"`
	// durationInHours: Indicates how long the takedown should be in effect before automatically expiring.
	DurationInHours *int64 `json:"durationInHours,omitempty" cborgen:"durationInHours,omitempty"`
}

// ModerationDefs_ModEventUnmute is a "modEventUnmute" in the tools.ozone.moderation.defs schema.
//
// # Unmute action on a subject
//
// RECORDTYPE: ModerationDefs_ModEventUnmute
type ModerationDefs_ModEventUnmute struct {
	LexiconTypeID string `json:"$type,const=tools.ozone.moderation.defs#modEventUnmute" cborgen:"$type,const=tools.ozone.moderation.defs#modEventUnmute"`
	// comment: Describe reasoning behind the reversal.
	Comment *string `json:"comment,omitempty" cborgen:"comment,omitempty"`
}

// ModerationDefs_ModEventUnmuteReporter is a "modEventUnmuteReporter" in the tools.ozone.moderation.defs schema.
//
// # Unmute incoming reports from an account
//
// RECORDTYPE: ModerationDefs_ModEventUnmuteReporter
type ModerationDefs_ModEventUnmuteReporter struct {
	LexiconTypeID string `json:"$type,const=tools.ozone.moderation.defs#modEventUnmuteReporter" cborgen:"$type,const=tools.ozone.moderation.defs#modEventUnmuteReporter"`
	// comment: Describe reasoning behind the reversal.
	Comment *string `json:"comment,omitempty" cborgen:"comment,omitempty"`
}

// ModerationDefs_ModEventView is a "modEventView" in the tools.ozone.moderation.defs schema.
type ModerationDefs_ModEventView struct {
	CreatedAt       string                               `json:"createdAt" cborgen:"createdAt"`
	CreatedBy       string                               `json:"createdBy" cborgen:"createdBy"`
	CreatorHandle   *string                              `json:"creatorHandle,omitempty" cborgen:"creatorHandle,omitempty"`
	Event           *ModerationDefs_ModEventView_Event   `json:"event" cborgen:"event"`
	Id              int64                                `json:"id" cborgen:"id"`
	Subject         *ModerationDefs_ModEventView_Subject `json:"subject" cborgen:"subject"`
	SubjectBlobCids []string                             `json:"subjectBlobCids" cborgen:"subjectBlobCids"`
	SubjectHandle   *string                              `json:"subjectHandle,omitempty" cborgen:"subjectHandle,omitempty"`
}

// ModerationDefs_ModEventViewDetail is a "modEventViewDetail" in the tools.ozone.moderation.defs schema.
type ModerationDefs_ModEventViewDetail struct {
	CreatedAt    string                                     `json:"createdAt" cborgen:"createdAt"`
	CreatedBy    string                                     `json:"createdBy" cborgen:"createdBy"`
	Event        *ModerationDefs_ModEventViewDetail_Event   `json:"event" cborgen:"event"`
	Id           int64                                      `json:"id" cborgen:"id"`
	Subject      *ModerationDefs_ModEventViewDetail_Subject `json:"subject" cborgen:"subject"`
	SubjectBlobs []*ModerationDefs_BlobView                 `json:"subjectBlobs" cborgen:"subjectBlobs"`
}

type ModerationDefs_ModEventViewDetail_Event struct {
	ModerationDefs_ModEventTakedown        *ModerationDefs_ModEventTakedown
	ModerationDefs_ModEventReverseTakedown *ModerationDefs_ModEventReverseTakedown
	ModerationDefs_ModEventComment         *ModerationDefs_ModEventComment
	ModerationDefs_ModEventReport          *ModerationDefs_ModEventReport
	ModerationDefs_ModEventLabel           *ModerationDefs_ModEventLabel
	ModerationDefs_ModEventAcknowledge     *ModerationDefs_ModEventAcknowledge
	ModerationDefs_ModEventEscalate        *ModerationDefs_ModEventEscalate
	ModerationDefs_ModEventMute            *ModerationDefs_ModEventMute
	ModerationDefs_ModEventUnmute          *ModerationDefs_ModEventUnmute
	ModerationDefs_ModEventMuteReporter    *ModerationDefs_ModEventMuteReporter
	ModerationDefs_ModEventUnmuteReporter  *ModerationDefs_ModEventUnmuteReporter
	ModerationDefs_ModEventEmail           *ModerationDefs_ModEventEmail
	ModerationDefs_ModEventResolveAppeal   *ModerationDefs_ModEventResolveAppeal
	ModerationDefs_ModEventDivert          *ModerationDefs_ModEventDivert
	ModerationDefs_ModEventTag             *ModerationDefs_ModEventTag
}

func (t *ModerationDefs_ModEventViewDetail_Event) MarshalJSON() ([]byte, error) {
	if t.ModerationDefs_ModEventTakedown != nil {
		t.ModerationDefs_ModEventTakedown.LexiconTypeID = "tools.ozone.moderation.defs#modEventTakedown"
		return json.Marshal(t.ModerationDefs_ModEventTakedown)
	}
	if t.ModerationDefs_ModEventReverseTakedown != nil {
		t.ModerationDefs_ModEventReverseTakedown.LexiconTypeID = "tools.ozone.moderation.defs#modEventReverseTakedown"
		return json.Marshal(t.ModerationDefs_ModEventReverseTakedown)
	}
	if t.ModerationDefs_ModEventComment != nil {
		t.ModerationDefs_ModEventComment.LexiconTypeID = "tools.ozone.moderation.defs#modEventComment"
		return json.Marshal(t.ModerationDefs_ModEventComment)
	}
	if t.ModerationDefs_ModEventReport != nil {
		t.ModerationDefs_ModEventReport.LexiconTypeID = "tools.ozone.moderation.defs#modEventReport"
		return json.Marshal(t.ModerationDefs_ModEventReport)
	}
	if t.ModerationDefs_ModEventLabel != nil {
		t.ModerationDefs_ModEventLabel.LexiconTypeID = "tools.ozone.moderation.defs#modEventLabel"
		return json.Marshal(t.ModerationDefs_ModEventLabel)
	}
	if t.ModerationDefs_ModEventAcknowledge != nil {
		t.ModerationDefs_ModEventAcknowledge.LexiconTypeID = "tools.ozone.moderation.defs#modEventAcknowledge"
		return json.Marshal(t.ModerationDefs_ModEventAcknowledge)
	}
	if t.ModerationDefs_ModEventEscalate != nil {
		t.ModerationDefs_ModEventEscalate.LexiconTypeID = "tools.ozone.moderation.defs#modEventEscalate"
		return json.Marshal(t.ModerationDefs_ModEventEscalate)
	}
	if t.ModerationDefs_ModEventMute != nil {
		t.ModerationDefs_ModEventMute.LexiconTypeID = "tools.ozone.moderation.defs#modEventMute"
		return json.Marshal(t.ModerationDefs_ModEventMute)
	}
	if t.ModerationDefs_ModEventUnmute != nil {
		t.ModerationDefs_ModEventUnmute.LexiconTypeID = "tools.ozone.moderation.defs#modEventUnmute"
		return json.Marshal(t.ModerationDefs_ModEventUnmute)
	}
	if t.ModerationDefs_ModEventMuteReporter != nil {
		t.ModerationDefs_ModEventMuteReporter.LexiconTypeID = "tools.ozone.moderation.defs#modEventMuteReporter"
		return json.Marshal(t.ModerationDefs_ModEventMuteReporter)
	}
	if t.ModerationDefs_ModEventUnmuteReporter != nil {
		t.ModerationDefs_ModEventUnmuteReporter.LexiconTypeID = "tools.ozone.moderation.defs#modEventUnmuteReporter"
		return json.Marshal(t.ModerationDefs_ModEventUnmuteReporter)
	}
	if t.ModerationDefs_ModEventEmail != nil {
		t.ModerationDefs_ModEventEmail.LexiconTypeID = "tools.ozone.moderation.defs#modEventEmail"
		return json.Marshal(t.ModerationDefs_ModEventEmail)
	}
	if t.ModerationDefs_ModEventResolveAppeal != nil {
		t.ModerationDefs_ModEventResolveAppeal.LexiconTypeID = "tools.ozone.moderation.defs#modEventResolveAppeal"
		return json.Marshal(t.ModerationDefs_ModEventResolveAppeal)
	}
	if t.ModerationDefs_ModEventDivert != nil {
		t.ModerationDefs_ModEventDivert.LexiconTypeID = "tools.ozone.moderation.defs#modEventDivert"
		return json.Marshal(t.ModerationDefs_ModEventDivert)
	}
	if t.ModerationDefs_ModEventTag != nil {
		t.ModerationDefs_ModEventTag.LexiconTypeID = "tools.ozone.moderation.defs#modEventTag"
		return json.Marshal(t.ModerationDefs_ModEventTag)
	}
	return nil, fmt.Errorf("cannot marshal empty enum")
}
func (t *ModerationDefs_ModEventViewDetail_Event) UnmarshalJSON(b []byte) error {
	typ, err := util.TypeExtract(b)
	if err != nil {
		return err
	}

	switch typ {
	case "tools.ozone.moderation.defs#modEventTakedown":
		t.ModerationDefs_ModEventTakedown = new(ModerationDefs_ModEventTakedown)
		return json.Unmarshal(b, t.ModerationDefs_ModEventTakedown)
	case "tools.ozone.moderation.defs#modEventReverseTakedown":
		t.ModerationDefs_ModEventReverseTakedown = new(ModerationDefs_ModEventReverseTakedown)
		return json.Unmarshal(b, t.ModerationDefs_ModEventReverseTakedown)
	case "tools.ozone.moderation.defs#modEventComment":
		t.ModerationDefs_ModEventComment = new(ModerationDefs_ModEventComment)
		return json.Unmarshal(b, t.ModerationDefs_ModEventComment)
	case "tools.ozone.moderation.defs#modEventReport":
		t.ModerationDefs_ModEventReport = new(ModerationDefs_ModEventReport)
		return json.Unmarshal(b, t.ModerationDefs_ModEventReport)
	case "tools.ozone.moderation.defs#modEventLabel":
		t.ModerationDefs_ModEventLabel = new(ModerationDefs_ModEventLabel)
		return json.Unmarshal(b, t.ModerationDefs_ModEventLabel)
	case "tools.ozone.moderation.defs#modEventAcknowledge":
		t.ModerationDefs_ModEventAcknowledge = new(ModerationDefs_ModEventAcknowledge)
		return json.Unmarshal(b, t.ModerationDefs_ModEventAcknowledge)
	case "tools.ozone.moderation.defs#modEventEscalate":
		t.ModerationDefs_ModEventEscalate = new(ModerationDefs_ModEventEscalate)
		return json.Unmarshal(b, t.ModerationDefs_ModEventEscalate)
	case "tools.ozone.moderation.defs#modEventMute":
		t.ModerationDefs_ModEventMute = new(ModerationDefs_ModEventMute)
		return json.Unmarshal(b, t.ModerationDefs_ModEventMute)
	case "tools.ozone.moderation.defs#modEventUnmute":
		t.ModerationDefs_ModEventUnmute = new(ModerationDefs_ModEventUnmute)
		return json.Unmarshal(b, t.ModerationDefs_ModEventUnmute)
	case "tools.ozone.moderation.defs#modEventMuteReporter":
		t.ModerationDefs_ModEventMuteReporter = new(ModerationDefs_ModEventMuteReporter)
		return json.Unmarshal(b, t.ModerationDefs_ModEventMuteReporter)
	case "tools.ozone.moderation.defs#modEventUnmuteReporter":
		t.ModerationDefs_ModEventUnmuteReporter = new(ModerationDefs_ModEventUnmuteReporter)
		return json.Unmarshal(b, t.ModerationDefs_ModEventUnmuteReporter)
	case "tools.ozone.moderation.defs#modEventEmail":
		t.ModerationDefs_ModEventEmail = new(ModerationDefs_ModEventEmail)
		return json.Unmarshal(b, t.ModerationDefs_ModEventEmail)
	case "tools.ozone.moderation.defs#modEventResolveAppeal":
		t.ModerationDefs_ModEventResolveAppeal = new(ModerationDefs_ModEventResolveAppeal)
		return json.Unmarshal(b, t.ModerationDefs_ModEventResolveAppeal)
	case "tools.ozone.moderation.defs#modEventDivert":
		t.ModerationDefs_ModEventDivert = new(ModerationDefs_ModEventDivert)
		return json.Unmarshal(b, t.ModerationDefs_ModEventDivert)
	case "tools.ozone.moderation.defs#modEventTag":
		t.ModerationDefs_ModEventTag = new(ModerationDefs_ModEventTag)
		return json.Unmarshal(b, t.ModerationDefs_ModEventTag)

	default:
		return nil
	}
}

type ModerationDefs_ModEventViewDetail_Subject struct {
	ModerationDefs_RepoView           *ModerationDefs_RepoView
	ModerationDefs_RepoViewNotFound   *ModerationDefs_RepoViewNotFound
	ModerationDefs_RecordView         *ModerationDefs_RecordView
	ModerationDefs_RecordViewNotFound *ModerationDefs_RecordViewNotFound
}

func (t *ModerationDefs_ModEventViewDetail_Subject) MarshalJSON() ([]byte, error) {
	if t.ModerationDefs_RepoView != nil {
		t.ModerationDefs_RepoView.LexiconTypeID = "tools.ozone.moderation.defs#repoView"
		return json.Marshal(t.ModerationDefs_RepoView)
	}
	if t.ModerationDefs_RepoViewNotFound != nil {
		t.ModerationDefs_RepoViewNotFound.LexiconTypeID = "tools.ozone.moderation.defs#repoViewNotFound"
		return json.Marshal(t.ModerationDefs_RepoViewNotFound)
	}
	if t.ModerationDefs_RecordView != nil {
		t.ModerationDefs_RecordView.LexiconTypeID = "tools.ozone.moderation.defs#recordView"
		return json.Marshal(t.ModerationDefs_RecordView)
	}
	if t.ModerationDefs_RecordViewNotFound != nil {
		t.ModerationDefs_RecordViewNotFound.LexiconTypeID = "tools.ozone.moderation.defs#recordViewNotFound"
		return json.Marshal(t.ModerationDefs_RecordViewNotFound)
	}
	return nil, fmt.Errorf("cannot marshal empty enum")
}
func (t *ModerationDefs_ModEventViewDetail_Subject) UnmarshalJSON(b []byte) error {
	typ, err := util.TypeExtract(b)
	if err != nil {
		return err
	}

	switch typ {
	case "tools.ozone.moderation.defs#repoView":
		t.ModerationDefs_RepoView = new(ModerationDefs_RepoView)
		return json.Unmarshal(b, t.ModerationDefs_RepoView)
	case "tools.ozone.moderation.defs#repoViewNotFound":
		t.ModerationDefs_RepoViewNotFound = new(ModerationDefs_RepoViewNotFound)
		return json.Unmarshal(b, t.ModerationDefs_RepoViewNotFound)
	case "tools.ozone.moderation.defs#recordView":
		t.ModerationDefs_RecordView = new(ModerationDefs_RecordView)
		return json.Unmarshal(b, t.ModerationDefs_RecordView)
	case "tools.ozone.moderation.defs#recordViewNotFound":
		t.ModerationDefs_RecordViewNotFound = new(ModerationDefs_RecordViewNotFound)
		return json.Unmarshal(b, t.ModerationDefs_RecordViewNotFound)

	default:
		return nil
	}
}

type ModerationDefs_ModEventView_Event struct {
	ModerationDefs_ModEventTakedown        *ModerationDefs_ModEventTakedown
	ModerationDefs_ModEventReverseTakedown *ModerationDefs_ModEventReverseTakedown
	ModerationDefs_ModEventComment         *ModerationDefs_ModEventComment
	ModerationDefs_ModEventReport          *ModerationDefs_ModEventReport
	ModerationDefs_ModEventLabel           *ModerationDefs_ModEventLabel
	ModerationDefs_ModEventAcknowledge     *ModerationDefs_ModEventAcknowledge
	ModerationDefs_ModEventEscalate        *ModerationDefs_ModEventEscalate
	ModerationDefs_ModEventMute            *ModerationDefs_ModEventMute
	ModerationDefs_ModEventUnmute          *ModerationDefs_ModEventUnmute
	ModerationDefs_ModEventMuteReporter    *ModerationDefs_ModEventMuteReporter
	ModerationDefs_ModEventUnmuteReporter  *ModerationDefs_ModEventUnmuteReporter
	ModerationDefs_ModEventEmail           *ModerationDefs_ModEventEmail
	ModerationDefs_ModEventResolveAppeal   *ModerationDefs_ModEventResolveAppeal
	ModerationDefs_ModEventDivert          *ModerationDefs_ModEventDivert
	ModerationDefs_ModEventTag             *ModerationDefs_ModEventTag
}

func (t *ModerationDefs_ModEventView_Event) MarshalJSON() ([]byte, error) {
	if t.ModerationDefs_ModEventTakedown != nil {
		t.ModerationDefs_ModEventTakedown.LexiconTypeID = "tools.ozone.moderation.defs#modEventTakedown"
		return json.Marshal(t.ModerationDefs_ModEventTakedown)
	}
	if t.ModerationDefs_ModEventReverseTakedown != nil {
		t.ModerationDefs_ModEventReverseTakedown.LexiconTypeID = "tools.ozone.moderation.defs#modEventReverseTakedown"
		return json.Marshal(t.ModerationDefs_ModEventReverseTakedown)
	}
	if t.ModerationDefs_ModEventComment != nil {
		t.ModerationDefs_ModEventComment.LexiconTypeID = "tools.ozone.moderation.defs#modEventComment"
		return json.Marshal(t.ModerationDefs_ModEventComment)
	}
	if t.ModerationDefs_ModEventReport != nil {
		t.ModerationDefs_ModEventReport.LexiconTypeID = "tools.ozone.moderation.defs#modEventReport"
		return json.Marshal(t.ModerationDefs_ModEventReport)
	}
	if t.ModerationDefs_ModEventLabel != nil {
		t.ModerationDefs_ModEventLabel.LexiconTypeID = "tools.ozone.moderation.defs#modEventLabel"
		return json.Marshal(t.ModerationDefs_ModEventLabel)
	}
	if t.ModerationDefs_ModEventAcknowledge != nil {
		t.ModerationDefs_ModEventAcknowledge.LexiconTypeID = "tools.ozone.moderation.defs#modEventAcknowledge"
		return json.Marshal(t.ModerationDefs_ModEventAcknowledge)
	}
	if t.ModerationDefs_ModEventEscalate != nil {
		t.ModerationDefs_ModEventEscalate.LexiconTypeID = "tools.ozone.moderation.defs#modEventEscalate"
		return json.Marshal(t.ModerationDefs_ModEventEscalate)
	}
	if t.ModerationDefs_ModEventMute != nil {
		t.ModerationDefs_ModEventMute.LexiconTypeID = "tools.ozone.moderation.defs#modEventMute"
		return json.Marshal(t.ModerationDefs_ModEventMute)
	}
	if t.ModerationDefs_ModEventUnmute != nil {
		t.ModerationDefs_ModEventUnmute.LexiconTypeID = "tools.ozone.moderation.defs#modEventUnmute"
		return json.Marshal(t.ModerationDefs_ModEventUnmute)
	}
	if t.ModerationDefs_ModEventMuteReporter != nil {
		t.ModerationDefs_ModEventMuteReporter.LexiconTypeID = "tools.ozone.moderation.defs#modEventMuteReporter"
		return json.Marshal(t.ModerationDefs_ModEventMuteReporter)
	}
	if t.ModerationDefs_ModEventUnmuteReporter != nil {
		t.ModerationDefs_ModEventUnmuteReporter.LexiconTypeID = "tools.ozone.moderation.defs#modEventUnmuteReporter"
		return json.Marshal(t.ModerationDefs_ModEventUnmuteReporter)
	}
	if t.ModerationDefs_ModEventEmail != nil {
		t.ModerationDefs_ModEventEmail.LexiconTypeID = "tools.ozone.moderation.defs#modEventEmail"
		return json.Marshal(t.ModerationDefs_ModEventEmail)
	}
	if t.ModerationDefs_ModEventResolveAppeal != nil {
		t.ModerationDefs_ModEventResolveAppeal.LexiconTypeID = "tools.ozone.moderation.defs#modEventResolveAppeal"
		return json.Marshal(t.ModerationDefs_ModEventResolveAppeal)
	}
	if t.ModerationDefs_ModEventDivert != nil {
		t.ModerationDefs_ModEventDivert.LexiconTypeID = "tools.ozone.moderation.defs#modEventDivert"
		return json.Marshal(t.ModerationDefs_ModEventDivert)
	}
	if t.ModerationDefs_ModEventTag != nil {
		t.ModerationDefs_ModEventTag.LexiconTypeID = "tools.ozone.moderation.defs#modEventTag"
		return json.Marshal(t.ModerationDefs_ModEventTag)
	}
	return nil, fmt.Errorf("cannot marshal empty enum")
}
func (t *ModerationDefs_ModEventView_Event) UnmarshalJSON(b []byte) error {
	typ, err := util.TypeExtract(b)
	if err != nil {
		return err
	}

	switch typ {
	case "tools.ozone.moderation.defs#modEventTakedown":
		t.ModerationDefs_ModEventTakedown = new(ModerationDefs_ModEventTakedown)
		return json.Unmarshal(b, t.ModerationDefs_ModEventTakedown)
	case "tools.ozone.moderation.defs#modEventReverseTakedown":
		t.ModerationDefs_ModEventReverseTakedown = new(ModerationDefs_ModEventReverseTakedown)
		return json.Unmarshal(b, t.ModerationDefs_ModEventReverseTakedown)
	case "tools.ozone.moderation.defs#modEventComment":
		t.ModerationDefs_ModEventComment = new(ModerationDefs_ModEventComment)
		return json.Unmarshal(b, t.ModerationDefs_ModEventComment)
	case "tools.ozone.moderation.defs#modEventReport":
		t.ModerationDefs_ModEventReport = new(ModerationDefs_ModEventReport)
		return json.Unmarshal(b, t.ModerationDefs_ModEventReport)
	case "tools.ozone.moderation.defs#modEventLabel":
		t.ModerationDefs_ModEventLabel = new(ModerationDefs_ModEventLabel)
		return json.Unmarshal(b, t.ModerationDefs_ModEventLabel)
	case "tools.ozone.moderation.defs#modEventAcknowledge":
		t.ModerationDefs_ModEventAcknowledge = new(ModerationDefs_ModEventAcknowledge)
		return json.Unmarshal(b, t.ModerationDefs_ModEventAcknowledge)
	case "tools.ozone.moderation.defs#modEventEscalate":
		t.ModerationDefs_ModEventEscalate = new(ModerationDefs_ModEventEscalate)
		return json.Unmarshal(b, t.ModerationDefs_ModEventEscalate)
	case "tools.ozone.moderation.defs#modEventMute":
		t.ModerationDefs_ModEventMute = new(ModerationDefs_ModEventMute)
		return json.Unmarshal(b, t.ModerationDefs_ModEventMute)
	case "tools.ozone.moderation.defs#modEventUnmute":
		t.ModerationDefs_ModEventUnmute = new(ModerationDefs_ModEventUnmute)
		return json.Unmarshal(b, t.ModerationDefs_ModEventUnmute)
	case "tools.ozone.moderation.defs#modEventMuteReporter":
		t.ModerationDefs_ModEventMuteReporter = new(ModerationDefs_ModEventMuteReporter)
		return json.Unmarshal(b, t.ModerationDefs_ModEventMuteReporter)
	case "tools.ozone.moderation.defs#modEventUnmuteReporter":
		t.ModerationDefs_ModEventUnmuteReporter = new(ModerationDefs_ModEventUnmuteReporter)
		return json.Unmarshal(b, t.ModerationDefs_ModEventUnmuteReporter)
	case "tools.ozone.moderation.defs#modEventEmail":
		t.ModerationDefs_ModEventEmail = new(ModerationDefs_ModEventEmail)
		return json.Unmarshal(b, t.ModerationDefs_ModEventEmail)
	case "tools.ozone.moderation.defs#modEventResolveAppeal":
		t.ModerationDefs_ModEventResolveAppeal = new(ModerationDefs_ModEventResolveAppeal)
		return json.Unmarshal(b, t.ModerationDefs_ModEventResolveAppeal)
	case "tools.ozone.moderation.defs#modEventDivert":
		t.ModerationDefs_ModEventDivert = new(ModerationDefs_ModEventDivert)
		return json.Unmarshal(b, t.ModerationDefs_ModEventDivert)
	case "tools.ozone.moderation.defs#modEventTag":
		t.ModerationDefs_ModEventTag = new(ModerationDefs_ModEventTag)
		return json.Unmarshal(b, t.ModerationDefs_ModEventTag)

	default:
		return nil
	}
}

type ModerationDefs_ModEventView_Subject struct {
	AdminDefs_RepoRef    *comatprototypes.AdminDefs_RepoRef
	RepoStrongRef        *comatprototypes.RepoStrongRef
	ConvoDefs_MessageRef *chatbskytypes.ConvoDefs_MessageRef
}

func (t *ModerationDefs_ModEventView_Subject) MarshalJSON() ([]byte, error) {
	if t.AdminDefs_RepoRef != nil {
		t.AdminDefs_RepoRef.LexiconTypeID = "com.atproto.admin.defs#repoRef"
		return json.Marshal(t.AdminDefs_RepoRef)
	}
	if t.RepoStrongRef != nil {
		t.RepoStrongRef.LexiconTypeID = "com.atproto.repo.strongRef"
		return json.Marshal(t.RepoStrongRef)
	}
	if t.ConvoDefs_MessageRef != nil {
		t.ConvoDefs_MessageRef.LexiconTypeID = "chat.bsky.convo.defs#messageRef"
		return json.Marshal(t.ConvoDefs_MessageRef)
	}
	return nil, fmt.Errorf("cannot marshal empty enum")
}
func (t *ModerationDefs_ModEventView_Subject) UnmarshalJSON(b []byte) error {
	typ, err := util.TypeExtract(b)
	if err != nil {
		return err
	}

	switch typ {
	case "com.atproto.admin.defs#repoRef":
		t.AdminDefs_RepoRef = new(comatprototypes.AdminDefs_RepoRef)
		return json.Unmarshal(b, t.AdminDefs_RepoRef)
	case "com.atproto.repo.strongRef":
		t.RepoStrongRef = new(comatprototypes.RepoStrongRef)
		return json.Unmarshal(b, t.RepoStrongRef)
	case "chat.bsky.convo.defs#messageRef":
		t.ConvoDefs_MessageRef = new(chatbskytypes.ConvoDefs_MessageRef)
		return json.Unmarshal(b, t.ConvoDefs_MessageRef)

	default:
		return nil
	}
}

// ModerationDefs_Moderation is a "moderation" in the tools.ozone.moderation.defs schema.
type ModerationDefs_Moderation struct {
	SubjectStatus *ModerationDefs_SubjectStatusView `json:"subjectStatus,omitempty" cborgen:"subjectStatus,omitempty"`
}

// ModerationDefs_ModerationDetail is a "moderationDetail" in the tools.ozone.moderation.defs schema.
type ModerationDefs_ModerationDetail struct {
	SubjectStatus *ModerationDefs_SubjectStatusView `json:"subjectStatus,omitempty" cborgen:"subjectStatus,omitempty"`
}

// ModerationDefs_RecordView is a "recordView" in the tools.ozone.moderation.defs schema.
//
// RECORDTYPE: ModerationDefs_RecordView
type ModerationDefs_RecordView struct {
	LexiconTypeID string                     `json:"$type,const=tools.ozone.moderation.defs#recordView" cborgen:"$type,const=tools.ozone.moderation.defs#recordView"`
	BlobCids      []string                   `json:"blobCids" cborgen:"blobCids"`
	Cid           string                     `json:"cid" cborgen:"cid"`
	IndexedAt     string                     `json:"indexedAt" cborgen:"indexedAt"`
	Moderation    *ModerationDefs_Moderation `json:"moderation" cborgen:"moderation"`
	Repo          *ModerationDefs_RepoView   `json:"repo" cborgen:"repo"`
	Uri           string                     `json:"uri" cborgen:"uri"`
	Value         *util.LexiconTypeDecoder   `json:"value" cborgen:"value"`
}

// ModerationDefs_RecordViewDetail is a "recordViewDetail" in the tools.ozone.moderation.defs schema.
//
// RECORDTYPE: ModerationDefs_RecordViewDetail
type ModerationDefs_RecordViewDetail struct {
	LexiconTypeID string                             `json:"$type,const=tools.ozone.moderation.defs#recordViewDetail" cborgen:"$type,const=tools.ozone.moderation.defs#recordViewDetail"`
	Blobs         []*ModerationDefs_BlobView         `json:"blobs" cborgen:"blobs"`
	Cid           string                             `json:"cid" cborgen:"cid"`
	IndexedAt     string                             `json:"indexedAt" cborgen:"indexedAt"`
	Labels        []*comatprototypes.LabelDefs_Label `json:"labels,omitempty" cborgen:"labels,omitempty"`
	Moderation    *ModerationDefs_ModerationDetail   `json:"moderation" cborgen:"moderation"`
	Repo          *ModerationDefs_RepoView           `json:"repo" cborgen:"repo"`
	Uri           string                             `json:"uri" cborgen:"uri"`
	Value         *util.LexiconTypeDecoder           `json:"value" cborgen:"value"`
}

// ModerationDefs_RecordViewNotFound is a "recordViewNotFound" in the tools.ozone.moderation.defs schema.
//
// RECORDTYPE: ModerationDefs_RecordViewNotFound
type ModerationDefs_RecordViewNotFound struct {
	LexiconTypeID string `json:"$type,const=tools.ozone.moderation.defs#recordViewNotFound" cborgen:"$type,const=tools.ozone.moderation.defs#recordViewNotFound"`
	Uri           string `json:"uri" cborgen:"uri"`
}

// ModerationDefs_RepoView is a "repoView" in the tools.ozone.moderation.defs schema.
//
// RECORDTYPE: ModerationDefs_RepoView
type ModerationDefs_RepoView struct {
	LexiconTypeID   string                                 `json:"$type,const=tools.ozone.moderation.defs#repoView" cborgen:"$type,const=tools.ozone.moderation.defs#repoView"`
	DeactivatedAt   *string                                `json:"deactivatedAt,omitempty" cborgen:"deactivatedAt,omitempty"`
	Did             string                                 `json:"did" cborgen:"did"`
	Email           *string                                `json:"email,omitempty" cborgen:"email,omitempty"`
	Handle          string                                 `json:"handle" cborgen:"handle"`
	IndexedAt       string                                 `json:"indexedAt" cborgen:"indexedAt"`
	InviteNote      *string                                `json:"inviteNote,omitempty" cborgen:"inviteNote,omitempty"`
	InvitedBy       *comatprototypes.ServerDefs_InviteCode `json:"invitedBy,omitempty" cborgen:"invitedBy,omitempty"`
	InvitesDisabled *bool                                  `json:"invitesDisabled,omitempty" cborgen:"invitesDisabled,omitempty"`
	Moderation      *ModerationDefs_Moderation             `json:"moderation" cborgen:"moderation"`
	RelatedRecords  []*util.LexiconTypeDecoder             `json:"relatedRecords" cborgen:"relatedRecords"`
}

// ModerationDefs_RepoViewDetail is a "repoViewDetail" in the tools.ozone.moderation.defs schema.
//
// RECORDTYPE: ModerationDefs_RepoViewDetail
type ModerationDefs_RepoViewDetail struct {
	LexiconTypeID    string                                   `json:"$type,const=tools.ozone.moderation.defs#repoViewDetail" cborgen:"$type,const=tools.ozone.moderation.defs#repoViewDetail"`
	DeactivatedAt    *string                                  `json:"deactivatedAt,omitempty" cborgen:"deactivatedAt,omitempty"`
	Did              string                                   `json:"did" cborgen:"did"`
	Email            *string                                  `json:"email,omitempty" cborgen:"email,omitempty"`
	EmailConfirmedAt *string                                  `json:"emailConfirmedAt,omitempty" cborgen:"emailConfirmedAt,omitempty"`
	Handle           string                                   `json:"handle" cborgen:"handle"`
	IndexedAt        string                                   `json:"indexedAt" cborgen:"indexedAt"`
	InviteNote       *string                                  `json:"inviteNote,omitempty" cborgen:"inviteNote,omitempty"`
	InvitedBy        *comatprototypes.ServerDefs_InviteCode   `json:"invitedBy,omitempty" cborgen:"invitedBy,omitempty"`
	Invites          []*comatprototypes.ServerDefs_InviteCode `json:"invites,omitempty" cborgen:"invites,omitempty"`
	InvitesDisabled  *bool                                    `json:"invitesDisabled,omitempty" cborgen:"invitesDisabled,omitempty"`
	Labels           []*comatprototypes.LabelDefs_Label       `json:"labels,omitempty" cborgen:"labels,omitempty"`
	Moderation       *ModerationDefs_ModerationDetail         `json:"moderation" cborgen:"moderation"`
	RelatedRecords   []*util.LexiconTypeDecoder               `json:"relatedRecords" cborgen:"relatedRecords"`
}

// ModerationDefs_RepoViewNotFound is a "repoViewNotFound" in the tools.ozone.moderation.defs schema.
//
// RECORDTYPE: ModerationDefs_RepoViewNotFound
type ModerationDefs_RepoViewNotFound struct {
	LexiconTypeID string `json:"$type,const=tools.ozone.moderation.defs#repoViewNotFound" cborgen:"$type,const=tools.ozone.moderation.defs#repoViewNotFound"`
	Did           string `json:"did" cborgen:"did"`
}

// ModerationDefs_SubjectStatusView is a "subjectStatusView" in the tools.ozone.moderation.defs schema.
type ModerationDefs_SubjectStatusView struct {
	// appealed: True indicates that the a previously taken moderator action was appealed against, by the author of the content. False indicates last appeal was resolved by moderators.
	Appealed *bool `json:"appealed,omitempty" cborgen:"appealed,omitempty"`
	// comment: Sticky comment on the subject.
	Comment *string `json:"comment,omitempty" cborgen:"comment,omitempty"`
	// createdAt: Timestamp referencing the first moderation status impacting event was emitted on the subject
	CreatedAt string `json:"createdAt" cborgen:"createdAt"`
	Id        int64  `json:"id" cborgen:"id"`
	// lastAppealedAt: Timestamp referencing when the author of the subject appealed a moderation action
	LastAppealedAt     *string                                   `json:"lastAppealedAt,omitempty" cborgen:"lastAppealedAt,omitempty"`
	LastReportedAt     *string                                   `json:"lastReportedAt,omitempty" cborgen:"lastReportedAt,omitempty"`
	LastReviewedAt     *string                                   `json:"lastReviewedAt,omitempty" cborgen:"lastReviewedAt,omitempty"`
	LastReviewedBy     *string                                   `json:"lastReviewedBy,omitempty" cborgen:"lastReviewedBy,omitempty"`
	MuteReportingUntil *string                                   `json:"muteReportingUntil,omitempty" cborgen:"muteReportingUntil,omitempty"`
	MuteUntil          *string                                   `json:"muteUntil,omitempty" cborgen:"muteUntil,omitempty"`
	ReviewState        *string                                   `json:"reviewState" cborgen:"reviewState"`
	Subject            *ModerationDefs_SubjectStatusView_Subject `json:"subject" cborgen:"subject"`
	SubjectBlobCids    []string                                  `json:"subjectBlobCids,omitempty" cborgen:"subjectBlobCids,omitempty"`
	SubjectRepoHandle  *string                                   `json:"subjectRepoHandle,omitempty" cborgen:"subjectRepoHandle,omitempty"`
	SuspendUntil       *string                                   `json:"suspendUntil,omitempty" cborgen:"suspendUntil,omitempty"`
	Tags               []string                                  `json:"tags,omitempty" cborgen:"tags,omitempty"`
	Takendown          *bool                                     `json:"takendown,omitempty" cborgen:"takendown,omitempty"`
	// updatedAt: Timestamp referencing when the last update was made to the moderation status of the subject
	UpdatedAt string `json:"updatedAt" cborgen:"updatedAt"`
}

type ModerationDefs_SubjectStatusView_Subject struct {
	AdminDefs_RepoRef *comatprototypes.AdminDefs_RepoRef
	RepoStrongRef     *comatprototypes.RepoStrongRef
}

func (t *ModerationDefs_SubjectStatusView_Subject) MarshalJSON() ([]byte, error) {
	if t.AdminDefs_RepoRef != nil {
		t.AdminDefs_RepoRef.LexiconTypeID = "com.atproto.admin.defs#repoRef"
		return json.Marshal(t.AdminDefs_RepoRef)
	}
	if t.RepoStrongRef != nil {
		t.RepoStrongRef.LexiconTypeID = "com.atproto.repo.strongRef"
		return json.Marshal(t.RepoStrongRef)
	}
	return nil, fmt.Errorf("cannot marshal empty enum")
}
func (t *ModerationDefs_SubjectStatusView_Subject) UnmarshalJSON(b []byte) error {
	typ, err := util.TypeExtract(b)
	if err != nil {
		return err
	}

	switch typ {
	case "com.atproto.admin.defs#repoRef":
		t.AdminDefs_RepoRef = new(comatprototypes.AdminDefs_RepoRef)
		return json.Unmarshal(b, t.AdminDefs_RepoRef)
	case "com.atproto.repo.strongRef":
		t.RepoStrongRef = new(comatprototypes.RepoStrongRef)
		return json.Unmarshal(b, t.RepoStrongRef)

	default:
		return nil
	}
}

// ModerationDefs_VideoDetails is a "videoDetails" in the tools.ozone.moderation.defs schema.
//
// RECORDTYPE: ModerationDefs_VideoDetails
type ModerationDefs_VideoDetails struct {
	LexiconTypeID string `json:"$type,const=tools.ozone.moderation.defs#videoDetails" cborgen:"$type,const=tools.ozone.moderation.defs#videoDetails"`
	Height        int64  `json:"height" cborgen:"height"`
	Length        int64  `json:"length" cborgen:"length"`
	Width         int64  `json:"width" cborgen:"width"`
}
