// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package supportappiface provides an interface to enable mocking the AWS Support App service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package supportappiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/supportapp"
)

// SupportAppAPI provides an interface to enable mocking the
// supportapp.SupportApp service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// AWS Support App.
//	func myFunc(svc supportappiface.SupportAppAPI) bool {
//	    // Make svc.CreateSlackChannelConfiguration request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := supportapp.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockSupportAppClient struct {
//	    supportappiface.SupportAppAPI
//	}
//	func (m *mockSupportAppClient) CreateSlackChannelConfiguration(input *supportapp.CreateSlackChannelConfigurationInput) (*supportapp.CreateSlackChannelConfigurationOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockSupportAppClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type SupportAppAPI interface {
	CreateSlackChannelConfiguration(*supportapp.CreateSlackChannelConfigurationInput) (*supportapp.CreateSlackChannelConfigurationOutput, error)
	CreateSlackChannelConfigurationWithContext(aws.Context, *supportapp.CreateSlackChannelConfigurationInput, ...request.Option) (*supportapp.CreateSlackChannelConfigurationOutput, error)
	CreateSlackChannelConfigurationRequest(*supportapp.CreateSlackChannelConfigurationInput) (*request.Request, *supportapp.CreateSlackChannelConfigurationOutput)

	DeleteAccountAlias(*supportapp.DeleteAccountAliasInput) (*supportapp.DeleteAccountAliasOutput, error)
	DeleteAccountAliasWithContext(aws.Context, *supportapp.DeleteAccountAliasInput, ...request.Option) (*supportapp.DeleteAccountAliasOutput, error)
	DeleteAccountAliasRequest(*supportapp.DeleteAccountAliasInput) (*request.Request, *supportapp.DeleteAccountAliasOutput)

	DeleteSlackChannelConfiguration(*supportapp.DeleteSlackChannelConfigurationInput) (*supportapp.DeleteSlackChannelConfigurationOutput, error)
	DeleteSlackChannelConfigurationWithContext(aws.Context, *supportapp.DeleteSlackChannelConfigurationInput, ...request.Option) (*supportapp.DeleteSlackChannelConfigurationOutput, error)
	DeleteSlackChannelConfigurationRequest(*supportapp.DeleteSlackChannelConfigurationInput) (*request.Request, *supportapp.DeleteSlackChannelConfigurationOutput)

	DeleteSlackWorkspaceConfiguration(*supportapp.DeleteSlackWorkspaceConfigurationInput) (*supportapp.DeleteSlackWorkspaceConfigurationOutput, error)
	DeleteSlackWorkspaceConfigurationWithContext(aws.Context, *supportapp.DeleteSlackWorkspaceConfigurationInput, ...request.Option) (*supportapp.DeleteSlackWorkspaceConfigurationOutput, error)
	DeleteSlackWorkspaceConfigurationRequest(*supportapp.DeleteSlackWorkspaceConfigurationInput) (*request.Request, *supportapp.DeleteSlackWorkspaceConfigurationOutput)

	GetAccountAlias(*supportapp.GetAccountAliasInput) (*supportapp.GetAccountAliasOutput, error)
	GetAccountAliasWithContext(aws.Context, *supportapp.GetAccountAliasInput, ...request.Option) (*supportapp.GetAccountAliasOutput, error)
	GetAccountAliasRequest(*supportapp.GetAccountAliasInput) (*request.Request, *supportapp.GetAccountAliasOutput)

	ListSlackChannelConfigurations(*supportapp.ListSlackChannelConfigurationsInput) (*supportapp.ListSlackChannelConfigurationsOutput, error)
	ListSlackChannelConfigurationsWithContext(aws.Context, *supportapp.ListSlackChannelConfigurationsInput, ...request.Option) (*supportapp.ListSlackChannelConfigurationsOutput, error)
	ListSlackChannelConfigurationsRequest(*supportapp.ListSlackChannelConfigurationsInput) (*request.Request, *supportapp.ListSlackChannelConfigurationsOutput)

	ListSlackChannelConfigurationsPages(*supportapp.ListSlackChannelConfigurationsInput, func(*supportapp.ListSlackChannelConfigurationsOutput, bool) bool) error
	ListSlackChannelConfigurationsPagesWithContext(aws.Context, *supportapp.ListSlackChannelConfigurationsInput, func(*supportapp.ListSlackChannelConfigurationsOutput, bool) bool, ...request.Option) error

	ListSlackWorkspaceConfigurations(*supportapp.ListSlackWorkspaceConfigurationsInput) (*supportapp.ListSlackWorkspaceConfigurationsOutput, error)
	ListSlackWorkspaceConfigurationsWithContext(aws.Context, *supportapp.ListSlackWorkspaceConfigurationsInput, ...request.Option) (*supportapp.ListSlackWorkspaceConfigurationsOutput, error)
	ListSlackWorkspaceConfigurationsRequest(*supportapp.ListSlackWorkspaceConfigurationsInput) (*request.Request, *supportapp.ListSlackWorkspaceConfigurationsOutput)

	ListSlackWorkspaceConfigurationsPages(*supportapp.ListSlackWorkspaceConfigurationsInput, func(*supportapp.ListSlackWorkspaceConfigurationsOutput, bool) bool) error
	ListSlackWorkspaceConfigurationsPagesWithContext(aws.Context, *supportapp.ListSlackWorkspaceConfigurationsInput, func(*supportapp.ListSlackWorkspaceConfigurationsOutput, bool) bool, ...request.Option) error

	PutAccountAlias(*supportapp.PutAccountAliasInput) (*supportapp.PutAccountAliasOutput, error)
	PutAccountAliasWithContext(aws.Context, *supportapp.PutAccountAliasInput, ...request.Option) (*supportapp.PutAccountAliasOutput, error)
	PutAccountAliasRequest(*supportapp.PutAccountAliasInput) (*request.Request, *supportapp.PutAccountAliasOutput)

	UpdateSlackChannelConfiguration(*supportapp.UpdateSlackChannelConfigurationInput) (*supportapp.UpdateSlackChannelConfigurationOutput, error)
	UpdateSlackChannelConfigurationWithContext(aws.Context, *supportapp.UpdateSlackChannelConfigurationInput, ...request.Option) (*supportapp.UpdateSlackChannelConfigurationOutput, error)
	UpdateSlackChannelConfigurationRequest(*supportapp.UpdateSlackChannelConfigurationInput) (*request.Request, *supportapp.UpdateSlackChannelConfigurationOutput)
}

var _ SupportAppAPI = (*supportapp.SupportApp)(nil)
