package resourcemanager

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListControlPolicyAttachmentsForTarget invokes the resourcemanager.ListControlPolicyAttachmentsForTarget API synchronously
func (client *Client) ListControlPolicyAttachmentsForTarget(request *ListControlPolicyAttachmentsForTargetRequest) (response *ListControlPolicyAttachmentsForTargetResponse, err error) {
	response = CreateListControlPolicyAttachmentsForTargetResponse()
	err = client.DoAction(request, response)
	return
}

// ListControlPolicyAttachmentsForTargetWithChan invokes the resourcemanager.ListControlPolicyAttachmentsForTarget API asynchronously
func (client *Client) ListControlPolicyAttachmentsForTargetWithChan(request *ListControlPolicyAttachmentsForTargetRequest) (<-chan *ListControlPolicyAttachmentsForTargetResponse, <-chan error) {
	responseChan := make(chan *ListControlPolicyAttachmentsForTargetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListControlPolicyAttachmentsForTarget(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListControlPolicyAttachmentsForTargetWithCallback invokes the resourcemanager.ListControlPolicyAttachmentsForTarget API asynchronously
func (client *Client) ListControlPolicyAttachmentsForTargetWithCallback(request *ListControlPolicyAttachmentsForTargetRequest, callback func(response *ListControlPolicyAttachmentsForTargetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListControlPolicyAttachmentsForTargetResponse
		var err error
		defer close(result)
		response, err = client.ListControlPolicyAttachmentsForTarget(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListControlPolicyAttachmentsForTargetRequest is the request struct for api ListControlPolicyAttachmentsForTarget
type ListControlPolicyAttachmentsForTargetRequest struct {
	*requests.RpcRequest
	TargetId string `position:"Query" name:"TargetId"`
	Language string `position:"Query" name:"Language"`
}

// ListControlPolicyAttachmentsForTargetResponse is the response struct for api ListControlPolicyAttachmentsForTarget
type ListControlPolicyAttachmentsForTargetResponse struct {
	*responses.BaseResponse
	RequestId                string                   `json:"RequestId" xml:"RequestId"`
	ControlPolicyAttachments ControlPolicyAttachments `json:"ControlPolicyAttachments" xml:"ControlPolicyAttachments"`
}

// CreateListControlPolicyAttachmentsForTargetRequest creates a request to invoke ListControlPolicyAttachmentsForTarget API
func CreateListControlPolicyAttachmentsForTargetRequest() (request *ListControlPolicyAttachmentsForTargetRequest) {
	request = &ListControlPolicyAttachmentsForTargetRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceManager", "2020-03-31", "ListControlPolicyAttachmentsForTarget", "", "")
	request.Method = requests.POST
	return
}

// CreateListControlPolicyAttachmentsForTargetResponse creates a response to parse from ListControlPolicyAttachmentsForTarget response
func CreateListControlPolicyAttachmentsForTargetResponse() (response *ListControlPolicyAttachmentsForTargetResponse) {
	response = &ListControlPolicyAttachmentsForTargetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
