package resourcemanager

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateResourceGroup invokes the resourcemanager.CreateResourceGroup API synchronously
func (client *Client) CreateResourceGroup(request *CreateResourceGroupRequest) (response *CreateResourceGroupResponse, err error) {
	response = CreateCreateResourceGroupResponse()
	err = client.DoAction(request, response)
	return
}

// CreateResourceGroupWithChan invokes the resourcemanager.CreateResourceGroup API asynchronously
func (client *Client) CreateResourceGroupWithChan(request *CreateResourceGroupRequest) (<-chan *CreateResourceGroupResponse, <-chan error) {
	responseChan := make(chan *CreateResourceGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateResourceGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateResourceGroupWithCallback invokes the resourcemanager.CreateResourceGroup API asynchronously
func (client *Client) CreateResourceGroupWithCallback(request *CreateResourceGroupRequest, callback func(response *CreateResourceGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateResourceGroupResponse
		var err error
		defer close(result)
		response, err = client.CreateResourceGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateResourceGroupRequest is the request struct for api CreateResourceGroup
type CreateResourceGroupRequest struct {
	*requests.RpcRequest
	DisplayName string `position:"Query" name:"DisplayName"`
	Name        string `position:"Query" name:"Name"`
}

// CreateResourceGroupResponse is the response struct for api CreateResourceGroup
type CreateResourceGroupResponse struct {
	*responses.BaseResponse
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	ResourceGroup ResourceGroup `json:"ResourceGroup" xml:"ResourceGroup"`
}

// CreateCreateResourceGroupRequest creates a request to invoke CreateResourceGroup API
func CreateCreateResourceGroupRequest() (request *CreateResourceGroupRequest) {
	request = &CreateResourceGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceManager", "2020-03-31", "CreateResourceGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateResourceGroupResponse creates a response to parse from CreateResourceGroup response
func CreateCreateResourceGroupResponse() (response *CreateResourceGroupResponse) {
	response = &CreateResourceGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
