package dts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartDtsJobs invokes the dts.StartDtsJobs API synchronously
func (client *Client) StartDtsJobs(request *StartDtsJobsRequest) (response *StartDtsJobsResponse, err error) {
	response = CreateStartDtsJobsResponse()
	err = client.DoAction(request, response)
	return
}

// StartDtsJobsWithChan invokes the dts.StartDtsJobs API asynchronously
func (client *Client) StartDtsJobsWithChan(request *StartDtsJobsRequest) (<-chan *StartDtsJobsResponse, <-chan error) {
	responseChan := make(chan *StartDtsJobsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartDtsJobs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartDtsJobsWithCallback invokes the dts.StartDtsJobs API asynchronously
func (client *Client) StartDtsJobsWithCallback(request *StartDtsJobsRequest, callback func(response *StartDtsJobsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartDtsJobsResponse
		var err error
		defer close(result)
		response, err = client.StartDtsJobs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartDtsJobsRequest is the request struct for api StartDtsJobs
type StartDtsJobsRequest struct {
	*requests.RpcRequest
	DtsJobIds string `position:"Query" name:"DtsJobIds"`
}

// StartDtsJobsResponse is the response struct for api StartDtsJobs
type StartDtsJobsResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	ErrCode        string `json:"ErrCode" xml:"ErrCode"`
	Success        bool   `json:"Success" xml:"Success"`
	ErrMessage     string `json:"ErrMessage" xml:"ErrMessage"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
}

// CreateStartDtsJobsRequest creates a request to invoke StartDtsJobs API
func CreateStartDtsJobsRequest() (request *StartDtsJobsRequest) {
	request = &StartDtsJobsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2020-01-01", "StartDtsJobs", "dts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStartDtsJobsResponse creates a response to parse from StartDtsJobs response
func CreateStartDtsJobsResponse() (response *StartDtsJobsResponse) {
	response = &StartDtsJobsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
