package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCdnSMCertificateDetail invokes the cdn.DescribeCdnSMCertificateDetail API synchronously
func (client *Client) DescribeCdnSMCertificateDetail(request *DescribeCdnSMCertificateDetailRequest) (response *DescribeCdnSMCertificateDetailResponse, err error) {
	response = CreateDescribeCdnSMCertificateDetailResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCdnSMCertificateDetailWithChan invokes the cdn.DescribeCdnSMCertificateDetail API asynchronously
func (client *Client) DescribeCdnSMCertificateDetailWithChan(request *DescribeCdnSMCertificateDetailRequest) (<-chan *DescribeCdnSMCertificateDetailResponse, <-chan error) {
	responseChan := make(chan *DescribeCdnSMCertificateDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCdnSMCertificateDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCdnSMCertificateDetailWithCallback invokes the cdn.DescribeCdnSMCertificateDetail API asynchronously
func (client *Client) DescribeCdnSMCertificateDetailWithCallback(request *DescribeCdnSMCertificateDetailRequest, callback func(response *DescribeCdnSMCertificateDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCdnSMCertificateDetailResponse
		var err error
		defer close(result)
		response, err = client.DescribeCdnSMCertificateDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCdnSMCertificateDetailRequest is the request struct for api DescribeCdnSMCertificateDetail
type DescribeCdnSMCertificateDetailRequest struct {
	*requests.RpcRequest
	OwnerId        requests.Integer `position:"Query" name:"OwnerId"`
	SecurityToken  string           `position:"Query" name:"SecurityToken"`
	CertIdentifier string           `position:"Query" name:"CertIdentifier"`
}

// DescribeCdnSMCertificateDetailResponse is the response struct for api DescribeCdnSMCertificateDetail
type DescribeCdnSMCertificateDetailResponse struct {
	*responses.BaseResponse
	RequestId          string `json:"RequestId" xml:"RequestId"`
	SignCertificate    string `json:"SignCertificate" xml:"SignCertificate"`
	EncryptCertificate string `json:"EncryptCertificate" xml:"EncryptCertificate"`
	CertIdentifier     string `json:"CertIdentifier" xml:"CertIdentifier"`
	CertName           string `json:"CertName" xml:"CertName"`
	CommonName         string `json:"CommonName" xml:"CommonName"`
	Sans               string `json:"Sans" xml:"Sans"`
	CertOrg            string `json:"CertOrg" xml:"CertOrg"`
	CertExpireTime     string `json:"CertExpireTime" xml:"CertExpireTime"`
}

// CreateDescribeCdnSMCertificateDetailRequest creates a request to invoke DescribeCdnSMCertificateDetail API
func CreateDescribeCdnSMCertificateDetailRequest() (request *DescribeCdnSMCertificateDetailRequest) {
	request = &DescribeCdnSMCertificateDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2018-05-10", "DescribeCdnSMCertificateDetail", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeCdnSMCertificateDetailResponse creates a response to parse from DescribeCdnSMCertificateDetail response
func CreateDescribeCdnSMCertificateDetailResponse() (response *DescribeCdnSMCertificateDetailResponse) {
	response = &DescribeCdnSMCertificateDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
