---
date: "2023-05-23T09:00:00+08:00"
title: "权限"
slug: "permissions"
sidebar_position: 14
toc: false
draft: false
aliases:
  - /zh-cn/permissions
menu:
  sidebar:
    parent: "usage"
    name: "权限"
    sidebar_position: 14
    identifier: "permissions"
---

# 权限

Gitea 支持对仓库进行权限管理，这样您就可以为不同的人员提供不同的访问权限。首先，我们需要了解 `单元（Unit）`。

## 单元（Unit）

在 Gitea 中，我们将仓库的子模块称为 `单元（Unit）`。现在我们有以下几个单元。

| 名称              | 描述                                                | 权限         |
| ----------------- | --------------------------------------------------- | ------------ |
| 代码              | 访问源代码、文件、提交和分支。                       | 读取 写入    |
| 工单              | 组织缺陷报告、任务和里程碑。                        | 读取 写入    |
| 合并请求          | 启用合并请求和代码审核。                             | 读取 写入    |
| 发布              | 跟踪项目版本和下载。                                | 读取 写入    |
| 百科              | 与协作者编写和共享文档。                            | 读取 写入    |
| 外部百科          | 链接到外部维基。                                    | 读取         |
| 外部工单跟踪器    | 链接到外部工单跟踪器。                              | 读取         |
| 项目              | 模板仓库的 URL。                                   | 读取 写入    |
| 包                | 链接到仓库                                          | 读取 写入   |
| Actions           | 审查Actions日志或重启/取消工作流                   | 读取 写入  |
| 设置              | 管理仓库。                                         | 管理员       |

通过不同的权限，用户可以在这些单元上执行不同的操作。

| 名称              | 读取                                                | 写入                           | 管理员                     |
| ----------------- | -------------------------------------------------- | ------------------------------ | ------------------------- |
| 代码              | 查看代码树、文件、提交、分支等。                     | 推送代码。                     | -                         |
| 工单              | 查看工单并创建新工单。                              | 添加标签、分配、关闭工单。     | -                         |
| 合并请求          | 查看合并请求并创建新合并请求。                       | 添加标签、分配、关闭合并请求。 | -                         |
| 发布              | 查看发布和下载文件。                                | 创建/编辑发布。                | -                         |
| 百科              | 查看百科页面。克隆百科仓库。                        | 创建/编辑百科页面，推送更改。 | -                         |
| 外部百科          | 链接到外部百科。                                    | -                             | -                         |
| 外部工单跟踪器    | 链接到外部工单跟踪器。                              | -                             | -                         |
| 项目              | 查看面板。                                         | 在面板之间移动工单。           | -                         |
| 包                | 查看包                                            | 上传/删除包      | -                         |
| Actions         | 查看 Actions日志                              | 同意 / 取消 / 重启   | -                         |
| 设置              | -                                                  | -                             | 管理仓库                   |

个人仓库和组织仓库之间的权限存在一些差异。

## 个人仓库

对于个人仓库，创建者是仓库的唯一所有者，对于该仓库的任何更改或删除没有限制。
仓库所有者可以添加协作者来帮助维护仓库。协作者可以拥有 `读取（Read）`、`写入（Write）` 和 `管理员（Admin）` 权限。

访问私有仓库的体验与访问匿名公共仓库类似。您可以访问仓库中的所有可用内容，包括克隆代码、创建工单、回复工单评论、提交拉取请求等。如果你有 "写"权限，只要分支保护规则允许，你就可以向仓库的特定分支推送代码。此外，你还可以修改百科页面。有了 "管理"权限，你就可以修改仓库的设置。

但如果你不是该仓库的所有者，就不能删除或转移该仓库。

## 组织仓库

对于个人仓库，所有者是创建它的用户。而对于组织仓库，所有者是该组织中的所有者团队成员。对该组织仓库的所有权限都取决于团队权限设置。

### 所有者团队

创建组织时将自动创建所有者团队，创建者将成为所有者团队的第一名成员。所有者团队不可删除，且至少有一名成员。

### 管理员团队

创建团队时，有两种类型的团队。一种是管理员团队，另一种是普通团队。可以创建一个管理员团队来管理某些版本库，其成员可以对这些版本库做任何事情。只有所有者或管理员团队的成员才能创建新团队。

### 普通团队

组织中的普通团队具有可以根据`单元(Unit)`进行权限设置。它可以有成员和存储库范围。

- 一个团队可以访问所属组织的所有仓库或特殊仓库。
- 也可以设置该团队是否有创建新仓库的权限。

可以通过创建 "普通团队"，并通过权限控制对其行为进行限制。一名成员可以加入多个团队。
