package internal

import "git.sr.ht/~charles/rq/util"

var sfakeStore map[[2]string]interface{} = make(map[[2]string]interface{})

// SfakeTemplate is the tempalte version of Sfake.
func SfakeTemplate(kind, sym string) string {
	key := [2]string{kind, sym}
	if val, ok := sfakeStore[key]; ok {
		return util.ValueToString(val)
	}

	out, err := util.Fake(string(kind))
	if err != nil {
		return "sfake error: " + err.Error()
	}

	sfakeStore[key] = out
	return util.ValueToString(out)
}

// Sfake implements the core logic for rq.sfake(), and for {{sfake}}. It needs
// to be in it's own package, because the previously generated values are
// stored in a package level variable. This was initially going to be in
// builtins, but that would cause a circular import with the io package.
func Sfake(kind, sym string) (interface{}, error) {

	key := [2]string{kind, sym}
	if val, ok := sfakeStore[key]; ok {
		return val, nil
	}

	out, err := FakeOptions.Fake(string(kind))
	if err != nil {
		return nil, err
	}

	sfakeStore[key] = out
	return out, nil
}
