/* gtkcolormapeditor.h
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999-2003 DindinX <David@dindinx.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU  
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GTK_COLOR_MAP_EDITOR_H__
#define __GTK_COLOR_MAP_EDITOR_H__

#include <gtk/gtk.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define GTK_TYPE_COLOR_MAP_EDITOR            (gtk_color_map_editor_get_type())
#define GTK_COLOR_MAP_EDITOR(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_COLOR_MAP_EDITOR, GtkColorMapEditor))
#define GTK_COLOR_MAP_EDITOR_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_COLOR_MAP_EDITOR, GtkColorMapEditorClass))
#define GTK_IS_COLOR_MAP_EDITOR(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_COLOR_MAP_EDITOR))
#define GTK_IS_COLOR_MAP_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_COLOR_MAP_EDITOR))
#define GTK_COLOR_MAP_EDITOR_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_COLOR_MAP_EDITOR, GtkColorMapEditorClass))

typedef struct _GtkColorMapEditor       GtkColorMapEditor;
typedef struct _GtkColorMapEditorClass  GtkColorMapEditorClass;


struct _GtkColorMapEditor
{
  GtkWindow  window;
  
  GList     *color_map;
  GtkWidget *preview;
  guchar    *preview_rows[2];

  guint      zoom_factor;
  GtkObject *scroll_data;
  GtkWidget *scrollbar;
};

struct _GtkColorMapEditorClass
{
  GtkWindowClass parent_class;
};

GType    gtk_color_map_editor_get_type      (void) G_GNUC_CONST;
GtkWidget* gtk_color_map_editor_new           (GList *color_map);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __GTK_COLOR_MAP_EDITOR_H__ */
