/* Giram: a simple 3D modeller
 * Copyright (C) 2001 DindinX <David@dindinx.org>
 *  
 * giramvectorframe.h
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GIRAM_VECTOR_FRAME_H__
#define __GIRAM_VECTOR_FRAME_H__

#include <gtk/gtkframe.h>
#include "giramlib/vectors.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* For information look into the C source or the html documentation */

#define GIRAM_TYPE_VECTOR_FRAME            (giram_vector_frame_get_type())
#define GIRAM_VECTOR_FRAME(obj)            (GTK_CHECK_CAST((obj), GIRAM_TYPE_VECTOR_FRAME, GiramVectorFrame))
#define GIRAM_VECTOR_FRAME_CLASS(klass)    (GTK_CHECK_CLASS_CAST((klass), GIRAM_TYPE_VECTOR_FRAME, GiramVectorFrameClass))
#define GIRAM_IS_VECTOR_FRAME(obj)         (GTK_CHECK_TYPE((obj), GIRAM_TYPE_VECTOR_FRAME))
#define GIRAM_IS_VECTOR_FRAME_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GIRAM_TYPE_VECTOR_FRAME))

typedef struct _GiramVectorFrame       GiramVectorFrame;
typedef struct _GiramVectorFrameClass  GiramVectorFrameClass;

struct _GiramVectorFrame
{
  GtkFrame  frame;

  GtkWidget *entry_x;
  GtkWidget *entry_y;
  GtkWidget *entry_z;
};

struct _GiramVectorFrameClass
{
  GtkFrameClass parent_class;
  void (*vector_changed)(GiramVectorFrame *vf);
};

GtkType    giram_vector_frame_get_type(void);
GtkWidget *giram_vector_frame_new(const gchar *label);
void       giram_vector_frame_get_value(GiramVectorFrame *vf,
                                        Vector            vector);
void       giram_vector_frame_set_value(GiramVectorFrame *vf,
                                        Vector            vector);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __GIRAM_VECTOR_FRAME_H__ */

