/* girammultipan.h
 *
 * Giram, a GPLed 3D modeller.
 * Copyright (C) 2002 DindinX <David@dindinx.org>
 *
 * GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/. 
 */

#ifndef __GIRAM_MULTIPAN_H__
#define __GIRAM_MULTIPAN_H__

#include <gtk/gtkcontainer.h>

G_BEGIN_DECLS

#define GIRAM_TYPE_MULTIPAN                  (giram_multipan_get_type ())
#define GIRAM_MULTIPAN(obj)                  (G_TYPE_CHECK_INSTANCE_CAST((obj), GIRAM_TYPE_MULTIPAN, GiramMultipan))
#define GIRAM_MULTIPAN_CLASS(klass)          (G_TYPE_CHECK_CLASS_CAST ((klass), GIRAM_TYPE_MULTIPAN, GiramMultipanClass))
#define GIRAM_IS_MULTIPAN(obj)               (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GIRAM_TYPE_MULTIPAN))
#define GIRAM_IS_MULTIPAN_CLASS(klass)       (G_TYPE_CHECK_CLASS_TYPE ((klass), GIRAM_TYPE_MULTIPAN))
#define GIRAM_MULTIPAN_GET_CLASS(obj)        (G_TYPE_INSTANCE_GET_CLASS ((obj), GIRAM_TYPE_MULTIPAN, GiramMultipanClass))


typedef struct _GiramMultipan      GiramMultipan;
typedef struct _GiramMultipanClass GiramMultipanClass;

struct _GiramMultipan
{
  GtkContainer container;
  
  GtkWidget     *child1;
  GtkWidget     *child2;
  
  GdkWindow     *handle;
  GdkGC         *xor_gc;
  GdkCursorType  cursor_type;
  
  /*< private >*/
  GdkRectangle   handle_pos;

  gint           child1_size;
  gint           last_allocation;
  gint           min_position;
  gint           max_position;

  guint          position_set  : 1;
  guint          in_drag       : 1;
  guint          child1_shrink : 1;
  guint          child1_resize : 1;
  guint          child2_shrink : 1;
  guint          child2_resize : 1;
  guint          orientation   : 1;
  guint          in_recursion  : 1;
  guint          handle_prelit : 1;

  GtkWidget     *last_child1_focus;
  GtkWidget     *last_child2_focus;
  GtkWidget     *saved_focus;

  gint           drag_pos;
  gint           original_position;
};
 
struct _GiramMultipanClass
{
  GtkContainerClass parent_class;
  
  gboolean (* cycle_child_focus)   (GiramMultipan      *paned,
                                    gboolean            reverse); 
  gboolean (* toggle_handle_focus) (GiramMultipan      *paned);
  gboolean (* move_handle)         (GiramMultipan      *paned,
                                    GtkScrollType  scroll);
  gboolean (* cycle_handle_focus)  (GiramMultipan      *paned,
                                    gboolean            reverse);
  gboolean (* accept_position)     (GiramMultipan      *paned);
  gboolean (* cancel_position)     (GiramMultipan      *paned);

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};


GType giram_multipan_get_type     (void) G_GNUC_CONST;
void  giram_multipan_add1         (GiramMultipan *paned,
                                   GtkWidget     *child);
void  giram_multipan_add2         (GiramMultipan *paned,
                                   GtkWidget     *child);
void  giram_multipan_pack1        (GiramMultipan *paned,
                                   GtkWidget     *child,
                                   gboolean       resize,
                                   gboolean       shrink);
void  giram_multipan_pack2        (GiramMultipan *paned,
                                   GtkWidget     *child,
                                   gboolean       resize,
                                   gboolean       shrink);
gint  giram_multipan_get_position (GiramMultipan *paned);
void  giram_multipan_set_position (GiramMultipan *paned,
                                   gint           position);

/* Internal function */
void  giram_multipan_compute_position (GiramMultipan  *paned,
                                       gint            allocation,
                                       gint            child1_req,
                                       gint            child2_req);

G_END_DECLS

#endif /* __GIRAM_MULTIPAN_H__ */
