/* view.h
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999-2002 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __VIEW_H__
#define __VIEW_H__

typedef enum
{
  GIRAM_EDITING_WIREFRAME,
  GIRAM_EDITING_HIDDEN,
  GIRAM_EDITING_GOURAUD
} GiramEditingStyle;



/* This is attached to every view, so we know how to render them */
typedef struct ViewStruct
{
  gint                camera_style;
  GtkWidget          *disp_vbox;
  GtkWidget          *canvas;
  struct FrameStruct *frame;
  double              zoom;
  double              x_off, y_off;
  GiramEditingStyle   render_style;
  GtkWidget          *shell;
  GtkWidget          *hruler;
  GtkWidget          *vruler;
  gboolean            show_rulers;
  GtkWidget          *origin;
} ViewStruct;


void CreateViewMenu(void);
ViewStruct *giram_view_new(struct FrameStruct *LocalFrame, int CameraStyle);
void DrawSelection(GtkWidget *DrawingArea, struct TriangleListStruct *Tri,
                   GdkGC *gc, double Xoff, double Yoff, double Zoom);
void draw_unselected(GtkWidget *canvas, GdkDrawable *drawable, gint style, gint width, gint height);
void draw_all(GtkWidget *canvas, GdkDrawable *drawable, gint style, gint width, gint height);
void FitToSceneFunc(void);
void FitToSelection(void);

void ZoomIn(void);
void ZoomOut(void);

void giram_view_set_title(ViewStruct *tmp_view);
    

#endif /* __VIEW_H__ */
