/* utils.c
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999-2002 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "giram.h"
#include "csg.h"
#include "giramrc.h"
#include "utils.h"

static gboolean search_uniq_in_csg(CSGStruct *csg_object, gchar *name);

ViewStruct *current_view_data = NULL;

/*****************************************************************************
*  LibOpen
******************************************************************************/
FILE *LibOpen(char *filename)
{
  FILE   *h;
  gchar **paths;
  gint    i;

  if ((h = fopen(filename,"rb")) != NULL)
  {
    return h;
  }
  h = NULL;
  if (pov_include_path)
  {
    paths = g_strsplit(pov_include_path, ":", -1);
    for (i = 0 ; paths[i] ; i++)
    {
      gchar *full_filename;

      full_filename = g_strdup_printf("%s/%s", paths[i], filename);
      h = fopen(full_filename, "rb");
      g_free(full_filename);
      if (h) break;
    }
    g_strfreev(paths);
  }
  return h;
}

/*************************************************************************
*  get_current_view_data
**************************************************************************/
ViewStruct *get_current_view_data(void)
{
  GtkWidget  *event_widget;
  GtkWidget  *toplevel_widget;
  GdkEvent   *event;
  ViewStruct *view_data = NULL;

  event = gtk_get_current_event();
  if (event == NULL)
    return current_view_data;
  event_widget = gtk_get_event_widget(event);
  gdk_event_free(event);

  if (event_widget == NULL)
    return NULL;
  toplevel_widget = gtk_widget_get_toplevel(event_widget);

  view_data = g_object_get_data(G_OBJECT(toplevel_widget), "ViewData");
  if (view_data)
    return view_data;
  if (current_view_data)
    return current_view_data;
  return NULL;
}

/****************************************************************************
*  create_uniq_light_source_name
*****************************************************************************/
gchar *create_uniq_light_source_name(FrameStruct *frame, gchar *type)
{
  gint               i;
  gchar             *name;
  gboolean           done;
  GSList            *tmp_list;
  LightSourceStruct *light_source;

  i = 1;
  do
  {
    name = g_strdup_printf("%s %d", type, i);
    done = TRUE;
    for (tmp_list = frame->all_light_sources ; tmp_list ; tmp_list = g_slist_next(tmp_list))
    {
      light_source = tmp_list->data;
      if (light_source->name && !strcmp(light_source->name, name))
      {
        done = FALSE;
        g_free(name);
        break;
      }
    }
    i++;
  } while (!done);
  return name;
}

/*************************************************************************
*  search_uniq_in_csg
**************************************************************************/
static gboolean search_uniq_in_csg(CSGStruct *csg_object, gchar *name)
{
  GSList       *tmp_list;
  ObjectStruct *object;

  for  (tmp_list = csg_object->all_objects ;
        tmp_list ;
        tmp_list = g_slist_next(tmp_list))
  {
    object = tmp_list->data;
    if (object->name && !strcmp(object->name, name))
      return FALSE;
    if (object->Type == CSG_OBJECT && !search_uniq_in_csg((CSGStruct *)object, name))
      return FALSE;
  }
  return TRUE;
}

/****************************************************************************
*  create_uniq_object_name
*****************************************************************************/
gchar *create_uniq_object_name(FrameStruct *frame, gchar *type)
{
  gint          i;
  gchar        *name;
  gboolean      done;
  GSList       *tmp_list;
  ObjectStruct *object;

  i = 1;
  do
  {
    name = g_strdup_printf("%s %d", type, i);
    done = TRUE;
    for (tmp_list = frame->all_objects ; tmp_list ; tmp_list = g_slist_next(tmp_list))
    {
      object = tmp_list->data;
      if (object->name && !strcmp(object->name, name))
      {
        done = FALSE;
        g_free(name);
        break;
      }
      if (object->Type == CSG_OBJECT && !search_uniq_in_csg((CSGStruct *)object, name))
      {
        done = FALSE;
        g_free(name);
        break;
      }
    }
    i++;
  } while (!done);
  return name;
}
