/* tool_pan.c
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999-2002 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <math.h>
#include "giram.h"
#include "trimesh.h"
#include "view.h"
#include "object.h"
#include "utils.h"
#include "pixmaps/move.xpm"
#include "giramcursor.h"

#include "giramintl.h"

#include "tool_pan.h"

double xoff, yoff;
double morgx, morgy;

#define NONE   1
#define MOVING 2
static int PAN_STATE = NONE;

/*****************************************************************************
*  tool_pan_init_pan
******************************************************************************/
static void tool_pan_init_pan(GtkWidget *DrawingArea, GdkEventButton *bevent)
{
  ViewStruct *view_data;

  view_data = get_current_view_data();
  morgx  = bevent->x;
  morgy  = bevent->y;
  xoff = view_data->x_off;
  yoff = view_data->y_off;
  PAN_STATE = MOVING;
/*  gdk_pointer_grab(DrawingArea->window, FALSE,
                   GDK_POINTER_MOTION_MASK |
                   GDK_BUTTON_RELEASE_MASK,
                   NULL, NULL, bevent->time);*/
}

/*****************************************************************************
*  tool_pan_motion
******************************************************************************/
static void tool_pan_motion(GtkWidget *canvas, GdkEventMotion *Mev)
{
  ViewStruct *view_data;

  if (PAN_STATE != MOVING)
    return;

  view_data = get_current_view_data();

  view_data->x_off = xoff + (morgx-Mev->x)/view_data->zoom;
  view_data->y_off = yoff - (morgy-Mev->y)/view_data->zoom;
  gtk_widget_queue_draw(canvas);
}

/*****************************************************************************
*  tool_pan_release
******************************************************************************/
static void tool_pan_release(GtkWidget *DrawingArea, GdkEventButton *Bev)
{
  if (PAN_STATE != MOVING)
    return;

  PAN_STATE = NONE;
}

/****************************************************************************
*  tool_pan_cursor_update
*****************************************************************************/
static void tool_pan_cursor_update(GtkWidget *canvas, guint state)
{
  GdkCursor *cursor;

  cursor = giram_cursor_new(GDK_FLEUR, /* FIXME, a  flat  hand would be neater */
                            GIRAM_TOOL_CURSOR_NONE,
                            GIRAM_CURSOR_MODIFIER_NONE);
  gdk_window_set_cursor(canvas->window, cursor);
  gdk_cursor_unref(cursor);
}

/****************************************************************************
*  giram_tool_pan_register
*****************************************************************************/
GiramTool *giram_tool_pan_register(void)
{
  GiramTool *tool;

  tool = g_new(GiramTool, 1);
  tool->ToolTip        = _("Pan");
  tool->Icon           = move_icon;
  tool->Path           = "<ToolBar>";
  tool->ID             = MT_PAN;
  tool->OptionsFunc    = NULL;
  tool->button_press   = tool_pan_init_pan;
  tool->motion         = tool_pan_motion;
  tool->button_release = tool_pan_release;
  tool->cursor_update  = tool_pan_cursor_update;

  return tool;
}

