/* tool_heightfield.c
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999-2002 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "giram.h"
#include "primitives/heightfield.h"
#include "utils.h"
#include "csgtree.h"
#include "widgets/giramfileselection.h"
#include "giramcursor.h"
#include "pixmaps/hf.xpm"

#include "tool_heightfield.h"

#include "giramintl.h"

/****************************************************************************
*  tool_heightfield_response
*****************************************************************************/
static void tool_heightfield_reponse(GtkWidget *dialog, gint response, FrameStruct *frame)
{
  GiramFileSelection *gfs;
  GtkToggleButton    *radio, *check;
  GtkSpinButton      *spin;
  gchar              *filename;
  HFImageType         type = IMAGE_TYPE_GIF;
  gdouble             water_level;
  gboolean            smooth;
  GSList             *tmp_list;

  switch (response)
  {
    case GTK_RESPONSE_ACCEPT:
      {
        ObjectStruct *heightfield;
        
        gfs = g_object_get_data(G_OBJECT(dialog), "file_selection");
        filename = giram_file_selection_get_filename(gfs);
        g_print("filename: %s\n", filename);
        
        radio = g_object_get_data(G_OBJECT(dialog), "gif");
        if (gtk_toggle_button_get_active(radio))
          type = IMAGE_TYPE_GIF;
        radio = g_object_get_data(G_OBJECT(dialog), "tga");
        if (gtk_toggle_button_get_active(radio))
          type = IMAGE_TYPE_TGA;
        radio = g_object_get_data(G_OBJECT(dialog), "pot");
        if (gtk_toggle_button_get_active(radio))
          type = IMAGE_TYPE_POT;
        radio = g_object_get_data(G_OBJECT(dialog), "png");
        if (gtk_toggle_button_get_active(radio))
          type = IMAGE_TYPE_PNG;
        radio = g_object_get_data(G_OBJECT(dialog), "pgm");
        if (gtk_toggle_button_get_active(radio))
          type = IMAGE_TYPE_PGM;
        radio = g_object_get_data(G_OBJECT(dialog), "ppm");
        if (gtk_toggle_button_get_active(radio))
          type = IMAGE_TYPE_PPM;
        radio = g_object_get_data(G_OBJECT(dialog), "sys");
        if (gtk_toggle_button_get_active(radio))
          type = IMAGE_TYPE_SYS;

        spin = g_object_get_data(G_OBJECT(dialog), "water_level");
        water_level = gtk_spin_button_get_value(spin);

        check = g_object_get_data(G_OBJECT(dialog), "smooth");
        smooth = gtk_toggle_button_get_active(check);

        heightfield = giram_heightfield_new(filename,
                                            type,
                                            water_level,
                                            smooth);
        frame->all_objects = g_slist_append(frame->all_objects, heightfield);
        heightfield->name = create_uniq_object_name(frame, _("heightfield"));
        heightfield->frame = frame;

        giram_object_build_triangle_mesh(heightfield);
        /* Redraw all view plus CSG Tree */
        for (tmp_list = frame->all_views ;
             tmp_list ;
             tmp_list = tmp_list->next)
        {
          ViewStruct *TmpView = tmp_list->data;

          gtk_widget_queue_draw(TmpView->canvas);
        }
        giram_create_tree_model(frame);
      }
    case GTK_RESPONSE_REJECT:
      gtk_widget_destroy(dialog);
      break;
  }
}

/****************************************************************************
*  tool_heightfield_button_press
*****************************************************************************/
static void tool_heightfield_button_press(GtkWidget *DrawingArea, GdkEventButton *bevent)
{
  GtkWidget   *dialog, *file_selection, *hbox, *label, *spin, *check;
  GtkWidget   *wframe, *table, *radio;
  GtkWidget   *ok_button, *cancel_button;
  ViewStruct  *view_data;
  FrameStruct *frame;

  view_data = get_current_view_data();
  frame = view_data->frame;
  
  dialog = gtk_dialog_new();
  ok_button = gtk_dialog_add_button(GTK_DIALOG(dialog), GTK_STOCK_OK,
                                    GTK_RESPONSE_ACCEPT);
  cancel_button = gtk_dialog_add_button(GTK_DIALOG(dialog), GTK_STOCK_CANCEL,
                                        GTK_RESPONSE_REJECT);
  g_signal_connect(G_OBJECT(dialog), "response",
                   G_CALLBACK(tool_heightfield_reponse), frame);
  gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_MOUSE);

  /* filename */
  hbox = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), hbox, FALSE, FALSE, 0);
  label = gtk_label_new(_("Filename: "));
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
  file_selection = giram_file_selection_new(_("Height Field image file"),
                                            "", FALSE, TRUE);
  g_object_set_data(G_OBJECT(dialog), "file_selection", file_selection);
  gtk_box_pack_start_defaults(GTK_BOX(hbox), file_selection);

  /* type */
  wframe = gtk_frame_new(_("type:"));
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), wframe, FALSE, FALSE, 0);
  table = gtk_table_new(4, 2, TRUE);
  gtk_container_add(GTK_CONTAINER(wframe), table);
  radio = gtk_radio_button_new_with_label(NULL, "gif");
  g_object_set_data(G_OBJECT(dialog), "gif", radio);
  gtk_table_attach_defaults(GTK_TABLE(table), radio, 0,1, 0,1);
  radio = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(radio), "tga");
  g_object_set_data(G_OBJECT(dialog), "tga", radio);
  gtk_table_attach_defaults(GTK_TABLE(table), radio, 1,2, 0,1);
  radio = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(radio), "pot");
  g_object_set_data(G_OBJECT(dialog), "pot", radio);
  gtk_table_attach_defaults(GTK_TABLE(table), radio, 0,1, 1,2);
  radio = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(radio), "png");
  g_object_set_data(G_OBJECT(dialog), "png", radio);
  gtk_table_attach_defaults(GTK_TABLE(table), radio, 1,2, 1,2);
  radio = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(radio), "pgm");
  g_object_set_data(G_OBJECT(dialog), "pgm", radio);
  gtk_table_attach_defaults(GTK_TABLE(table), radio, 0,1, 2,3);
  radio = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(radio), "ppm");
  g_object_set_data(G_OBJECT(dialog), "ppm", radio);
  gtk_table_attach_defaults(GTK_TABLE(table), radio, 1,2, 2,3);
  radio = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(radio), "sys");
  g_object_set_data(G_OBJECT(dialog), "sys", radio);
  gtk_table_attach_defaults(GTK_TABLE(table), radio, 0,1, 3,4);
                
  /* water_level */
  hbox = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), hbox, FALSE, FALSE, 0);
  label = gtk_label_new(_("Water level: "));
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
  spin = gtk_spin_button_new_with_range(0.0, 1.0, 0.001);
  g_object_set_data(G_OBJECT(dialog), "water_level", spin);
  gtk_box_pack_start_defaults(GTK_BOX(hbox), spin);

  /* smooth */
  check = gtk_check_button_new_with_label(_("smooth"));
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), check, FALSE, FALSE, 0);
  g_object_set_data(G_OBJECT(dialog), "smooth", check);

  gtk_widget_show_all(dialog);
}

/****************************************************************************
*  tool_heightfield_cursor_update
*****************************************************************************/
static void tool_heightfield_cursor_update(GtkWidget *canvas, guint state)
{
  GdkCursor *cursor;

  cursor = giram_cursor_new(GIRAM_MOUSE_CURSOR,
                            GIRAM_TOOL_CURSOR_NONE,
                            GIRAM_CURSOR_MODIFIER_NONE);
  gdk_window_set_cursor(canvas->window, cursor);
  gdk_cursor_unref(cursor);
}

/****************************************************************************
*  giram_tool_heightfield_register
*****************************************************************************/
GiramTool *giram_tool_heightfield_register(void)
{
  GiramTool *tool;

  tool = g_new(GiramTool, 1);
  tool->ToolTip        = _("New Height Field");
  tool->Icon           = hf_icon;
  tool->Path           = "<ToolBar>";
  tool->ID             = MT_NEW_HEIGHTFIELD;
  tool->OptionsFunc    = NULL;
  tool->button_press   = tool_heightfield_button_press;
  tool->motion         = NULL;
  tool->button_release = NULL;
  tool->cursor_update  = tool_heightfield_cursor_update;

  return tool;
}

