/* texture.h
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999-2002 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __TEXTURE_H__
#define __TEXTURE_H__

#include "pigment.h"

/* This struct is used to store the Finish part of a texture */
typedef struct FinishStruct
{
  Vector ambient;
  double diffuse;
  double brilliance;
  double crand;
  Vector reflection;
  double phong;
  double phong_size;
  double specular;
  double roughness;

  double Metallic;
  double Refraction;
  double Ior;
  double Caustics;
  double FadeDistance;
  double FadePower;
  struct
  {
    double Amount;
    double Thickness;
    Vector Turbulence;
  } Irid;
} FinishStruct;

FinishStruct *DefaultFinish;

typedef struct TextureStruct
{
  guint            refcount;
  PigmentStruct   *Pigment;
  FinishStruct    *finish;
  TransformStruct *Trans;
} TextureStruct;

TextureStruct *DefaultTexture;

GtkWidget *texture_editor(TextureStruct *texture);
void texture_editor_set_texture(GObject *editor, TextureStruct *texture);

#endif /* __TEXTURE_H__ */
