/* sor.c
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999-2002 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <math.h>
#include "giram.h"
#include "sor.h"
#include "trimesh.h"

#include "giramintl.h"

static void giram_sor_build_triangle_mesh(ObjectStruct *sor);
static gboolean giram_sor_inside(ObjectStruct *sor, double x, double y, double z);
static gboolean giram_sor_find_intersection_segment(ObjectStruct *sor,
                                                    Vector in_point, Vector out_point,
                                                    Vector inter_point, Vector inter_norm);

/*****************************************************************************
*  giram_sor_build_triangle_mesh FIXME: needs to be smoother
******************************************************************************/
static void giram_sor_build_triangle_mesh(ObjectStruct *sor)
{ /* XXX: clipped_by */
  Vector     p1, p2, p3, p4;
  Vector     n1, n2, n3, n4;
  guint      i, j, DetailLevel;
  SorStruct *ssor = (SorStruct *)sor;

  DetailLevel = 16; /* XXX: Should be a private field */

  if (sor->FirstTriangle)
    DestroyObjectTriangleMesh(sor);

  for (i=1 ; i<ssor->NumberOfPoints-2 ; i++)
  {
    for (j=0 ; j<DetailLevel ; j++)
    {
      p1[0] = ssor->Point[i][0]*cos((j*2.0)*M_PI/DetailLevel);
      p1[1] = ssor->Point[i][1];
      p1[2] = ssor->Point[i][0]*sin((j*2.0)*M_PI/DetailLevel);
      n1[0] = n1[1] = n1[2];
      p2[0] = ssor->Point[i][0]*cos(((j+1)*2.0)*M_PI/DetailLevel);
      p2[1] = ssor->Point[i][1];
      p2[2] = ssor->Point[i][0]*sin(((j+1)*2.0)*M_PI/DetailLevel);
      n2[0] = n2[1] = n2[2];
      p3[0] = ssor->Point[i+1][0]*cos((j*2.0)*M_PI/DetailLevel);
      p3[1] = ssor->Point[i+1][1];
      p3[2] = ssor->Point[i+1][0]*sin((j*2.0)*M_PI/DetailLevel);
      n3[0] = n3[1] = n3[2];
      p4[0] = ssor->Point[i+1][0]*cos(((j+1)*2.0)*M_PI/DetailLevel);
      p4[1] = ssor->Point[i+1][1];
      p4[2] = ssor->Point[i+1][0]*sin(((j+1)*2.0)*M_PI/DetailLevel);
      n4[0] = n4[1] = n4[2];
      if (sor->Trans)
      {
        MEvaluatePoint(p1, sor->Trans, p1);
        MEvaluateVector(n1, sor->Trans, n1);
        MEvaluatePoint(p2, sor->Trans, p2);
        MEvaluateVector(n2, sor->Trans, n2);
        MEvaluatePoint(p3, sor->Trans, p3);
        MEvaluateVector(n3, sor->Trans, n3);
        MEvaluatePoint(p4, sor->Trans, p4);
        MEvaluateVector(n4, sor->Trans, n4);
      }
      AddTriangleToObjectMesh(sor, p1,p2,p3, n1,n2,n3);
      AddTriangleToObjectMesh(sor, p2,p3,p4, n2,n3,n4);
    }
  }
}

/*****************************************************************************
*  giram_sor_inside FIXME
******************************************************************************/
static gboolean giram_sor_inside(ObjectStruct *sor, double x, double y, double z)
{
  return FALSE; /* FIXME */
}

/*****************************************************************************
*  FindIntersectSorSegment FIXME
******************************************************************************/
static gboolean giram_sor_find_intersection_segment(ObjectStruct *sor,
                                                    Vector in_point, Vector out_point,
                                                    Vector inter_point, Vector inter_norm)
{
  return FALSE;
}

/*****************************************************************************
*  giram_sor_new
******************************************************************************/
ObjectStruct *giram_sor_new(guint nb_points, Vector *points)
{
  ObjectStruct *sor;
  SorStruct    *ssor;
  static GiramObjectClass *sor_klass = NULL;
  guint i;

  if (sor_klass == NULL)
  {
    sor_klass = giram_object_class_new();

    sor_klass->name                      = _("SoR");
    sor_klass->build_triangle_mesh       = giram_sor_build_triangle_mesh;
    sor_klass->inside                    = giram_sor_inside;
    sor_klass->find_intersection_segment = giram_sor_find_intersection_segment;
  }
  ssor = g_new(SorStruct, 1);
  sor = (ObjectStruct *)ssor;
  InitObject(sor);
  sor->Type = SOR_OBJECT;
  sor->klass = sor_klass;
  ssor->NumberOfPoints = nb_points;
  if (nb_points)
  {
    ssor->Point = g_new(Vector, ssor->NumberOfPoints);
    for (i=0 ; i<ssor->NumberOfPoints ; i++)
    {
      ssor->Point[i][0] = points[i][0];
      ssor->Point[i][1] = points[i][1];
    }
  }
  return sor;
}

