/* heightfield.c
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999-2002 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "giram.h"
#include "heightfield.h"
#include "trimesh.h"
//#include "csgtree.h"


#include "giramintl.h"
static void giram_heightfield_build_triangle_mesh(ObjectStruct *heightfield);
static gboolean giram_heightfield_inside(ObjectStruct *heightfield, double x, double y, double z);
static gboolean giram_heightfield_is_intersection(ObjectStruct *heightfield, Vector org, Vector dir);
static gboolean giram_heightfield_find_intersection_segment(ObjectStruct *heightfield,
                                                            Vector in_point, Vector out_point,
                                                            Vector inter_point, Vector inter_norm);
static gboolean giram_heightfield_find_intersection(ObjectStruct *heightfield,
                                                    Vector        origin,
                                                    Vector        direction,
                                                    Vector        intersection,
                                                    Vector        normal);

static void giram_heightfield_build_triangle_mesh(ObjectStruct *heightfield)
{
  Vector P[8], N[6];

  if (heightfield->FirstTriangle)
    DestroyObjectTriangleMesh(heightfield);
  V3Deq(P[0], 0.0, 0.0, 0.0);
  V3Deq(P[1], 0.0, 0.0, 1.0);
  V3Deq(P[2], 0.0, 1.0, 0.0);
  V3Deq(P[3], 0.0, 1.0, 1.0);
  V3Deq(P[4], 1.0, 0.0, 0.0);
  V3Deq(P[5], 1.0, 0.0, 1.0);
  V3Deq(P[6], 1.0, 1.0, 0.0);
  V3Deq(P[7], 1.0, 1.0, 1.0);

  V3Deq(N[0],  0.0, -1.0,  0.0);
  V3Deq(N[1],  0.0,  1.0,  0.0);
  V3Deq(N[2],  0.0,  0.0, -1.0);
  V3Deq(N[3],  0.0,  0.0,  1.0);
  V3Deq(N[4], -1.0,  0.0,  0.0);
  V3Deq(N[5],  1.0,  0.0,  0.0);

  if (heightfield->Trans)
  {
    MEvaluatePoint(P[0], heightfield->Trans, P[0]);
    MEvaluatePoint(P[1], heightfield->Trans, P[1]);
    MEvaluatePoint(P[2], heightfield->Trans, P[2]);
    MEvaluatePoint(P[3], heightfield->Trans, P[3]);
    MEvaluatePoint(P[4], heightfield->Trans, P[4]);
    MEvaluatePoint(P[5], heightfield->Trans, P[5]);
    MEvaluatePoint(P[6], heightfield->Trans, P[6]);
    MEvaluatePoint(P[7], heightfield->Trans, P[7]);
    MEvaluateVector(N[0], heightfield->Trans, N[0]);
    MEvaluateVector(N[1], heightfield->Trans, N[1]);
    MEvaluateVector(N[2], heightfield->Trans, N[2]);
    MEvaluateVector(N[3], heightfield->Trans, N[3]);
    MEvaluateVector(N[4], heightfield->Trans, N[4]);
    MEvaluateVector(N[5], heightfield->Trans, N[5]);
  }

  AddTriangleToObjectMesh(heightfield, P[0],P[1],P[4], N[0], N[0], N[0]);
  AddTriangleToObjectMesh(heightfield, P[5],P[1],P[4], N[0], N[0], N[0]);
  AddTriangleToObjectMesh(heightfield, P[2],P[3],P[6], N[1], N[1], N[1]);
  AddTriangleToObjectMesh(heightfield, P[7],P[3],P[6], N[1], N[1], N[1]);
  AddTriangleToObjectMesh(heightfield, P[0],P[2],P[4], N[2], N[2], N[2]);
  AddTriangleToObjectMesh(heightfield, P[2],P[6],P[4], N[2], N[2], N[2]);
  AddTriangleToObjectMesh(heightfield, P[1],P[3],P[5], N[3], N[3], N[3]);
  AddTriangleToObjectMesh(heightfield, P[7],P[3],P[5], N[3], N[3], N[3]);
  AddTriangleToObjectMesh(heightfield, P[0],P[1],P[2], N[4], N[4], N[4]);
  AddTriangleToObjectMesh(heightfield, P[1],P[2],P[3], N[4], N[4], N[4]);
  AddTriangleToObjectMesh(heightfield, P[4],P[5],P[6], N[5], N[5], N[5]);
  AddTriangleToObjectMesh(heightfield, P[5],P[6],P[7], N[5], N[5], N[5]);  
}

static gboolean giram_heightfield_inside(ObjectStruct *heightfield, double x, double y, double z)
{
  return FALSE;
}

static gboolean giram_heightfield_is_intersection(ObjectStruct *heightfield, Vector org, Vector dir)
{
  return FALSE;
}

static gboolean giram_heightfield_find_intersection_segment(ObjectStruct *heightfield,
                                                            Vector in_point, Vector out_point,
                                                            Vector inter_point, Vector inter_norm)
{
  return FALSE;
}

static gboolean giram_heightfield_find_intersection(ObjectStruct *heightfield,
                                                    Vector        origin,
                                                    Vector        direction,
                                                    Vector        intersection,
                                                    Vector        normal)
{
  return FALSE;
}

/*****************************************************************************
*  giram_heightfield_new
******************************************************************************/
ObjectStruct *giram_heightfield_new(gchar       *filename,
                                    HFImageType  type,
                                    gdouble      waterlevel,
                                    gboolean     smooth)
{
  ObjectStruct *heightfield;
  HeightFieldStruct *hheightfield;
  static GiramObjectClass *heightfield_klass = NULL;

  if (heightfield_klass == NULL)
  {
    heightfield_klass = giram_object_class_new();

    heightfield_klass->name                      = _("Height Field");
    heightfield_klass->build_triangle_mesh       = giram_heightfield_build_triangle_mesh;
    heightfield_klass->inside                    = giram_heightfield_inside;
    //heightfield_klass->is_intersection           = giram_heightfield_is_intersection;
    heightfield_klass->find_intersection_segment = giram_heightfield_find_intersection_segment;
    heightfield_klass->find_intersection         = giram_heightfield_find_intersection;
  }
  hheightfield = g_new(HeightFieldStruct, 1);
  heightfield= (ObjectStruct *)hheightfield;
  InitObject(heightfield);
  heightfield->Type = HEIGHT_FIELD_OBJECT;
  heightfield->klass = heightfield_klass;

  hheightfield->filename   = g_strdup(filename);
  hheightfield->type       = type;
  hheightfield->waterlevel = waterlevel;
  hheightfield->smooth     = smooth;

  return heightfield;
}

