/* bicubic_patch.c
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999-2002 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <math.h>
#include "giram.h"
#include "bicubic_patch.h"
#include "trimesh.h"
#include "csgtree.h"

#include "giramintl.h"

static void giram_bicubic_patch_build_triangle_mesh(ObjectStruct *box);

/*****************************************************************************
*  giram_bicubic_patch_build_triangle_mesh
******************************************************************************/
static void giram_bicubic_patch_build_triangle_mesh(ObjectStruct *bicubic_patch)
{
  BicubicPatchStruct *bbicubic_patch = (BicubicPatchStruct *)bicubic_patch;
  gint                i, j;
  Vector              P[4];
  Vector              N = { 1,0,0,0,0 };

  if (bicubic_patch->FirstTriangle)
    DestroyObjectTriangleMesh(bicubic_patch);

  for (i=0 ; i<3 ; i++)
    for (j=0 ; j<3 ; j++)
    {
      V3Dcopy(P[0], bbicubic_patch->control_points[j*4+i]);
      V3Dcopy(P[1], bbicubic_patch->control_points[j*4+i+1]);
      V3Dcopy(P[2], bbicubic_patch->control_points[j*4+i+4]);
      V3Dcopy(P[3], bbicubic_patch->control_points[j*4+i+5]);
      if (bicubic_patch->Trans)
      {
        MEvaluatePoint(P[0], bicubic_patch->Trans, P[0]);
        MEvaluatePoint(P[1], bicubic_patch->Trans, P[1]);
        MEvaluatePoint(P[2], bicubic_patch->Trans, P[2]);
        MEvaluatePoint(P[3], bicubic_patch->Trans, P[3]);
      }
      AddTriangleToObjectMesh(bicubic_patch, P[0],P[1],P[2], N, N, N);
      AddTriangleToObjectMesh(bicubic_patch, P[3],P[1],P[2], N, N, N);
    }
}

/*****************************************************************************
*  giram_bicubic_patch_new
******************************************************************************/
ObjectStruct *giram_bicubic_patch_new(gint u, gint v, Vector *control_points)
{
  ObjectStruct       *bicubic_patch;
  BicubicPatchStruct *bbicubic_patch;
  gint                i;

  static GiramObjectClass *bicubic_patch_klass = NULL;

  if (bicubic_patch_klass == NULL)
  {
    bicubic_patch_klass = giram_object_class_new();

    bicubic_patch_klass->name                = _("Bicubic Patch");
    bicubic_patch_klass->build_triangle_mesh = giram_bicubic_patch_build_triangle_mesh;
  }
  bbicubic_patch = g_new(BicubicPatchStruct, 1);
  bicubic_patch = (ObjectStruct *)bbicubic_patch;
  InitObject(bicubic_patch);
  bicubic_patch->Type = BICUBIC_PATCH_OBJECT;
  bicubic_patch->klass = bicubic_patch_klass;
  bbicubic_patch->u_steps = u;
  bbicubic_patch->v_steps = v;
  for (i=0 ; i<16 ; i++)
  {
    V3Dcopy(bbicubic_patch->control_points[i], control_points[i]);
  }
  return bicubic_patch;
}

