/* pigment.h
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999-2002 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __PIGMENT_H__
#define __PIGMENT_H__

/* These enum represents all the pattern PovRay can handle, and thus must
 * be handled as well by Giram.
 */
typedef enum
{
  PAT_SOLID_COLOR,
  PAT_BRICK,
  PAT_CHECKER,
  PAT_HEXAGON,
  PAT_ONION,
  PAT_LEOPARD,
  PAT_LAST
} GiramPigmentType;

typedef struct PigmentStruct
{
  guint             refcount;
  GiramPigmentType  Type;           /* Type of pattern used */
  Vector            Color;          /* Solid Color */
  TransformStruct  *Trans;          /* Transformation for the pigment */
  Vector            Color2, Color3;
/*  Vector BrickSize;
  double Mortar;*/
  GList            *color_map;
} PigmentStruct;

PigmentStruct *DefaultPigment;

void giram_pigment_evaluate(Vector color, PigmentStruct *pigment, Vector intersect);

#endif /* __PIGMENT_H__ */
