/* Giram: a simple 3D modeller
 * Copyright (C) 2001 DindinX <David@dindinx.org>
 *
 * The GIMP -- an image manipulation program
 * Copyright (C) 1995 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GIRAMRC_H__
#define __GIRAMRC_H__

/*  global giramrc variables  */
extern gboolean  show_xy_view;
extern gboolean  show_xz_view;
extern gboolean  show_zy_view;
extern gboolean  show_camera_view;
extern gchar    *temp_path;
extern gchar    *pov_include_path;
extern gchar    *renderer_modules_path;
extern gchar    *help_path;
extern gchar    *plugins_path;
extern gchar    *color_path;
extern gchar    *color_map_path;
extern gchar    *finish_path;
extern gchar    *normal_path;
extern gchar    *pigment_path;
extern gchar    *shape_path;
extern gchar    *texture_path;
extern gint      toolbox_style;
extern gint      dynamic_toolbox_shape;
extern gboolean  show_tips;
extern gint      last_tip;
extern gchar    *view_title_format;

extern gboolean  remove_trivial_transform;
extern gboolean  merge_successive_translation;

/*  function prototypes  */
gboolean parse_buffers_init(void); /* this has to be called before any file
                                    * is parsed
                                    */
void      parse_giramrc(void);
gboolean  parse_giramrc_file(gchar *filename);
void      save_giramrc(GList **updated_options,
                       GList **conflicting_options);
gchar    *giramrc_find_token(gchar *token);
gchar    *giramrc_value_to_str(gchar *name);
void      save_gimprc_strings(gchar *token,
                              gchar *value);

#endif  /*  __GIRAMRC_H__  */

