/* Giram: a simple 3D modeller
 * Copyright (C) 2001 DindinX <David@dindinx.org>
 *
 * LIBGIMP - The GIMP Library
 * Copyright (C) 1995-1997 Peter Mattis and Spencer Kimball
 *
 * giramenv.h
 *
 * Copyright (C) 1999 Tor Lillqvist <tml@iki.fi>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GIRAMENV_H__
#define __GIRAMENV_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* For information look into the C source or the html documentation */

const gchar * giram_directory                  (void);
gchar       * giram_personal_rc_file           (const gchar  *basename);
const gchar * giram_data_directory             (void);
const gchar * giram_sysconf_directory          (void);
const gchar * giram_gtkrc                      (void);

GList       * giram_path_parse                 (const gchar  *path,
                                                gint          max_paths,
                                                gboolean      check,
                                                GList       **check_failed);
gchar       * giram_path_to_str                (GList        *path);
void          giram_path_free                  (GList        *path);

gchar       * giram_path_get_user_writable_dir (GList        *path);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif  /*  __GIRAMENV_H__  */

