/* file-utils.c
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999-2003 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>

#include "giram.h"
#include "giramintl.h"

static GtkWidget *fileload = NULL;

static GtkWidget *giram_file_open_dialog_create(void);
static gboolean   giram_file_dialog_hide(GtkWidget *filesel);
static void       giram_file_open_ok(GtkWidget *widget, GtkWidget *open_dialog);


void giram_load_file(void)
{
  if (!fileload)
    fileload = giram_file_open_dialog_create();

  gtk_widget_set_sensitive(fileload, TRUE);

  if (GTK_WIDGET_VISIBLE(fileload))
  {
    gtk_window_present(GTK_WINDOW(fileload));
    return;
  }
  gtk_window_set_title(GTK_WINDOW(fileload), _("Open Scene"));
  /*gtk_file_selection_set_filename(GTK_FILE_SELECTION(fileload),
                                  "/tmp/");*/ /* FIXME */
  /* TODO set unsensitive open, save, etc. */
  gtk_widget_grab_focus(GTK_FILE_SELECTION(fileload)->selection_entry);
  gtk_widget_show(fileload);
}

static GtkWidget *giram_file_open_dialog_create(void)
{
  GtkWidget         *filesel;
  GtkFileSelection *fs;

  filesel = gtk_file_selection_new(_("Open Scene"));

  fs = GTK_FILE_SELECTION(filesel);
  gtk_window_set_position(GTK_WINDOW(filesel), GTK_WIN_POS_MOUSE);
  gtk_window_set_wmclass(GTK_WINDOW(filesel), "load_scene", "Giram");

  gtk_container_set_border_width(GTK_CONTAINER(fs->button_area), 2);
  gtk_container_set_border_width(GTK_CONTAINER(filesel), 2);

  g_signal_connect_swapped(G_OBJECT(fs->cancel_button), "clicked",
                           G_CALLBACK(giram_file_dialog_hide), filesel);
  g_signal_connect(G_OBJECT(filesel), "delete_event",
                   G_CALLBACK(giram_file_dialog_hide), NULL);
  
  g_signal_connect(G_OBJECT(fs->ok_button), "clicked",
                   G_CALLBACK(giram_file_open_ok), filesel);

  /* The file type menu */
  {
    GtkWidget *hbox, *option_menu, *label;

    hbox = gtk_hbox_new(FALSE, 4);
    option_menu = gtk_option_menu_new();
    gtk_box_pack_end(GTK_BOX(hbox), option_menu, FALSE, FALSE, 0);
    gtk_widget_show(option_menu);

/*    gtk_option_menu_set_menu(GTK_OPTION_MENU(option_menu),
                             GTK_ITEM_FACTORY(item_factory)->widget);*/
    gtk_box_pack_end(GTK_BOX(fs->main_vbox), hbox, FALSE, FALSE, 0);
    gtk_widget_show(hbox);

    label = gtk_label_new(_("Determine File Type:"));
    gtk_box_pack_end(GTK_BOX(hbox), label, FALSE, FALSE, 0);
    gtk_widget_show(label);
  }
  
  
  return filesel;
}

gboolean giram_file_dialog_hide(GtkWidget *filesel)
{
  gtk_widget_hide(filesel);

  /* TODO set sensitive open, save, etc. */
  return TRUE;
}

static void giram_file_open_ok(GtkWidget *widget, GtkWidget *open_dialog)
{
  /* bla bla bla */
}

