/* edit.c
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999-2002 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include "giram.h"
#include "object.h"
#include "copy.h"
#include "csgtree.h"
#include "tools/tool_select.h"
#include "edit.h"
#include "utils.h"

static GList *CutBuffer = NULL;

/*****************************************************************************
*  DestroyCutBuffer
******************************************************************************/
void DestroyCutBuffer(void)
{
  GList *TmpSel;

  for (TmpSel = CutBuffer; TmpSel ; TmpSel = g_list_next(TmpSel) )
    giram_object_destroy(TmpSel->data);
  g_list_free(CutBuffer);
  CutBuffer = NULL;
}

/*****************************************************************************
*  CutSelection
******************************************************************************/
void CutSelection()
{
  ViewStruct      *view_data;
  ObjectStruct    *TmpObject;
  GSList          *tmp_list;
  ViewStruct      *TmpView;
  GList           *selection;

  view_data = get_current_view_data();
  /* Destroy the current cut buffer */
  DestroyCutBuffer();

  if (view_data->frame->selection == NULL)
    return;
  for (selection = view_data->frame->selection ;
       selection ;
       selection = g_list_next(selection) )
  {
    TmpObject = selection->data;
    /* Remove the object from the frame. */
    view_data->frame->all_objects = g_slist_remove(view_data->frame->all_objects,
                                                   TmpObject);
    /* Add the object to the current cut buffer. */
    CutBuffer = g_list_prepend(CutBuffer, CopyObject(TmpObject));
    /* Destroy the object */
    giram_object_destroy(TmpObject);
  }

  /* Destroy the Current Selection */
  g_list_free(view_data->frame->selection);
  view_data->frame->selection = NULL;

  /* Redraw all view plus CSG Tree */
  for (tmp_list = view_data->frame->all_views ;
       tmp_list ;
       tmp_list = tmp_list->next)
  {
    TmpView = tmp_list->data;
    gtk_widget_queue_draw(TmpView->canvas);
  }
  giram_create_tree_model(view_data->frame);
}

/*****************************************************************************
*  CopySelection
******************************************************************************/
void CopySelection()
{
  ViewStruct   *view_data;
  GList        *selection;
  ObjectStruct *TmpObject;
  GSList       *tmp_list;
  ViewStruct   *TmpView;

  view_data = get_current_view_data();
  /* Destroy the current cut buffer */
  DestroyCutBuffer();
  if (view_data->frame->selection == NULL)
    return;
  for (selection = view_data->frame->selection ;
       selection ;
       selection = g_list_next(selection) )
  {
    TmpObject = selection->data;
    /* Add the object to the current cut buffer. */
    CutBuffer = g_list_prepend(CutBuffer, CopyObject(TmpObject));
  }

  /* Redraw all view plus CSG Tree */
  for (tmp_list = view_data->frame->all_views ;
       tmp_list ;
       tmp_list = tmp_list->next)
  {
    TmpView = tmp_list->data;
    gtk_widget_queue_draw(TmpView->canvas);
  }
  giram_create_tree_model(view_data->frame);
}

/*****************************************************************************
*  PasteSelection
******************************************************************************/
void PasteSelection()
{
  ViewStruct   *view_data;
  GList        *TmpSel;
  ObjectStruct *TmpObject;
  GSList       *tmp_list;
  ViewStruct   *TmpView;
  GList        *selection;

  view_data = get_current_view_data();
  /* Destroy the Current Selection */
  if (view_data->frame->selection)
  {
    for (selection = view_data->frame->selection;
         selection ;
         selection = g_list_next(selection) )
    {
      TmpObject = selection->data;
      TmpObject->selected = FALSE;
    }
    g_list_free(view_data->frame->selection);
    view_data->frame->selection = NULL;
  }

  if (CutBuffer)
  {
    for (TmpSel = CutBuffer ; TmpSel ; TmpSel = g_list_next(TmpSel))
    {
      TmpObject = CopyObject((ObjectStruct *)(TmpSel->data));
      view_data->frame->all_objects = g_slist_append(view_data->frame->all_objects,
                                                     TmpObject);
      TmpObject->name = create_uniq_object_name(view_data->frame, "pasted");
      view_data->frame->selection = g_list_append(view_data->frame->selection, TmpObject);
      TmpObject->selected = TRUE;
      giram_object_build_triangle_mesh(TmpObject);
      CSGTreeSelect(TmpObject);
    }
  }

  /* Redraw all view plus CSG Tree */
  for (tmp_list = view_data->frame->all_views ;
       tmp_list ;
       tmp_list = tmp_list->next)
  {
    TmpView = tmp_list->data;
    gtk_widget_queue_draw(TmpView->canvas);
  }
  giram_create_tree_model(view_data->frame);
}

