/* color_map.h
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999-2003 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __COLOR_MAP_H__
#define __COLOR_MAP_H__

typedef struct color_map_entry
{
  gdouble position;
  gdouble color[3];
} color_map_entry;

gboolean  color_map_check_valid(GList *color_map);
GList    *color_map_new(void);
GList    *color_map_add_point(GList *color_map, gdouble position, gdouble *color);
gboolean  color_map_change_color(GList *color_map, gdouble position, gdouble *color);
GList    *color_map_remove_point(GList *color_map, gdouble position);
GList    *color_map_remove_point_index(GList *color_map, guint index);
void      color_map_evaluate(GList *color_map, gdouble position, gdouble *color);
void      color_map_display(GList *color_map);
GList    *color_map_copy(GList *color_map);

#endif /* __COLOR_MAP_H__ */
