/* camera.h
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999-2002 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __CAMERA_H__
#define __CAMERA_H__

/* The different types of camera. Only the PERSPECTIVE one is used. */
typedef enum
{
  CAMERA_PERSPECTIVE,
  CAMERA_ORTHOGRAPHIC,
  CAMERA_FISHEYE,
  CAMERA_ULTRA_WIDE_ANGLE,
  CAMERA_OMNIMAX,
  CAMERA_PANORAMIC,
  CAMERA_SPHERICAL,
  CAMERA_CYLINDER_1,
  CAMERA_CYLINDER_2,
  CAMERA_CYLINDER_3,
  CAMERA_CYLINDER_4
} GiramCameraType;

typedef struct CameraStruct
{
  GiramCameraType  Type;
  gchar           *name;
  Vector           Location;
  Vector           LookAt;
  Vector           Right;
  Vector           Up;
  Vector           Direction;
  Vector           Sky;
  double           Angle;
  int              BlurSamples;
  double           Aperture;
  Vector           FocalPoint;
  double           Confidence;
  double           Variance;
  /* Private fields. These are used to calculate the Pers3d->2d */
  double x0, y0, z0;
  double PX, PY, PZ;
  double A, B, C, D;
  Vector P00, P01, P10, P11;
  Vector PA, PB, PC, PD;
  Vector Na, Nb, Nc;
  double Du0, Du1, Du2;
  double Dv0, Dv1, Dv2;
  Vector Qux, Quy, Qvx, Qvy;
  double Dux, Duy, Dvx, Dvy;
} CameraStruct;

void InitCamera(CameraStruct *Camera);
void ComputeCamera(CameraStruct *Camera);
void EditCamera(GtkWidget *DrawingArea);

#endif /* __CAMERA_H__ */
