/*
ICE Intelligent C Editor
Copyright (C) 2002 Carlos Rodríguez Caminero

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
*/
/*
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include <stdio.h>
#include <string.h>
//#include <glib.h>
#include <gtk/gtk.h>
#include "gtkcedit/gtkcedit.h"

//#include <gconf/gconf.h>

#define max_pages 20
GtkWidget *window;
GtkWidget *vbox1;
GtkWidget *hboxbottom;
GtkWidget *statusbar1;
GtkWidget *progressbar;
GtkWidget *toolbar;
GtkWidget *button_undo;
GtkWidget *button_redo;
GtkWidget *notebook;
GtkWidget *Preferencias;

  GtkTreeModel *modelcolores;
  GtkTreeModel *modelpath;

  GtkWidget *coloreado;
  GtkWidget *identacion;
  GtkWidget *scroll;
  GtkWidget *formateado;
  GtkWidget *correccioncontinua;
  GtkWidget *correccion;

//  GtkWidget *path;
  GtkWidget *listacolores;
  GtkWidget *listapath;

	gboolean lastColor;
	gboolean lastIdentation;
	gboolean lastScroll;
	gboolean lastFormat;
	gboolean lastContinuousCorrection;
	gboolean lastCorrection;

GtkWidget *label [max_pages];
GtkWidget *gtkcedit [max_pages];
GtkWidget *table1 [max_pages];
GtkWidget *vscrollbar [max_pages];
GtkWidget *hscrollbar [max_pages];
char filled [max_pages];
int virtual_page [max_pages];
gchar filename [max_pages][255];  // nombre del fichero
gboolean closing;

GtkWidget *dialog_window;
GtkWidget *entry;
gchar  lastfind [100];

GdkPixmap *pixmap;
GdkBitmap *mask;

GtkAccelGroup *accel_group;
GtkItemFactory *item_factory;


void
menuitem_cb (gpointer             callback_data,
    guint                callback_action,
    GtkWidget           *widget);

void
file_new (GtkWidget *button,
    gpointer   data);

void
file_open (GtkWidget *button,
    gpointer   data);
void
file_close (GtkWidget *button,
    gpointer   data);
void
file_save (GtkWidget *button,
    gpointer   data);
void
file_save_as (GtkWidget *button,
    gpointer   data);
void
file_preferences (GtkWidget *button,
    gpointer   data);
void
file_exit (GtkWidget *button,
    gpointer   data);
void
edit_undo (GtkWidget *button,
    gpointer   data);
void
edit_redo (GtkWidget *button,
    gpointer   data);
void
edit_cut (GtkWidget *button,
    gpointer   data);
void
edit_copy (GtkWidget *button,
    gpointer   data);
void
edit_paste (GtkWidget *button,
    gpointer   data);
void
edit_find (GtkWidget *button,
    gpointer   data);
void
edit_find_next (GtkWidget *button,
    gpointer   data);
void
edit_go_to_def (GtkWidget *button,
    gpointer   data);
void
edit_go_to_def_popup (result_definition_db *res_def_db);
void
edit_test (GtkWidget *button,
    gpointer   data);

void
have_undo (GtkWidget *widget,
    gpointer   data);
void
no_have_undo (GtkWidget *widget,
    gpointer   data);
void
have_redo (GtkWidget *widget,
    gpointer   data);
void
no_have_redo (GtkWidget *widget,
    gpointer   data);
void
    //notebook_select_page (GtkWidget *widget,
    //      gboolean arg1,
    //      gpointer   data);
notebook_select_page (GtkWidget *widget,
    GtkNotebookPage *page,
    gint page_num,
    gpointer   data);

int
actual_page ();
int
actual_page2 (gint page);
int
create_page ();
int
get_name (char *orig, char *dest);

void FindStringDialog (char *szMessage, void (*YesFunc)(), void (*NoFunc)());
void
FindNext ();
void
CancelFind (GtkWidget *widget,
    gpointer   data);
void msg_box (gchar *text, int type);

/*
void
InsertarPath (GtkWidget *button,
	      gpointer   data);
*/

int
create_preferences( void (*AceptarFunc)(), void (*AplicarFunc)(), void (*CancelarFunc)());

void AplicarPreferencias (GtkWidget *widget, gpointer data);
void AceptarPreferencias (GtkWidget *widget, gpointer data);
void CancelarPreferencias (GtkWidget *widget, gpointer data);
gint statusbar_text(gchar *text);
gint statusbar_interrupt (gpointer data);
void usar_preferencias (gint index);
void cargar (gchar *text);


GArray *ArrayPath;

typedef struct 
{
  gchar *Direccion;
  gboolean editable;
} Item;

enum
  {
    COLUMN_DESCRIPTION,
    NUM_COLUMNS
  };

enum
  {
    COLUMN_PATH_DESCRIPTION,
    COLUMN_PATH_EDITABLE,
    NUM_PATH_COLUMNS
  };
/*
static Item data [] =
  {
    {"/usr/include/", TRUE},
    {"/usr/local/include/", TRUE},
  };
*/


GtkTreeModel *
create_model_colores (void);

void
add_columns_colores (GtkTreeView *treeview);

void
add_items_path (void);

GtkTreeModel *
create_model_path (void);

void
add_columns_path (GtkTreeView *treeview);

void
cell_edited (GtkCellRendererText *cell,
	     const gchar         *path_string,
	     const gchar         *new_text,
	     gpointer             data);

void
remove_item (GtkWidget *widget, gpointer data);
void
add_item (GtkWidget *button, gpointer data);

void
CambiaColor (GtkWidget *button,
	     gpointer	  data);

gint CerrarAplicacion (GtkWidget *widget, gpointer data);

#include "language.h"

