/*
gICE Gnome Intelligent C Editor
Copyright (C) 2002 Carlos Rodríguez Caminero

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
*/
/*
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

    /*
    * Example showing custom widget
    */


#include "main.h"
#include "icon.xpm"

static GtkItemFactoryEntry menu_items [] =
{
    { "/_Fichero",                        NULL,         0,               0, "<Branch>" },
    { "/Fichero/_Nuevo",                  "<control>N", file_new,        0, "<StockItem>", GTK_STOCK_NEW },
    { "/Fichero/_Abrir",                  "<control>O", file_open,       0, "<StockItem>", GTK_STOCK_OPEN },
    { "/Fichero/_Grabar",                 "<control>S", file_save,       0, "<StockItem>", GTK_STOCK_SAVE },
    { "/Fichero/Grabar _como...",         NULL,         file_save_as,    0, "<StockItem>", GTK_STOCK_SAVE_AS },
    { "/Fichero/_Cerrar",                 NULL,         file_close,      0, "<StockItem>", GTK_STOCK_CLOSE },
    { "/Fichero/sep",                     NULL,         menuitem_cb,     0, "<Separator>" },
    { "/Fichero/_Preferencias",           NULL,         file_preferences,0, "<StockItem>", GTK_STOCK_PREFERENCES },
    { "/Fichero/sep1",                    NULL,         menuitem_cb,     0, "<Separator>" },
    { "/Fichero/_Salir",                  "<control>Q", file_exit,       0, "<StockItem>", GTK_STOCK_QUIT },
    { "/Edicion",                         NULL,         0,               0, "<Branch>" },
    { "/Edicion/_Undo",                   "<control>Z", edit_undo,       0, "<StockItem>", GTK_STOCK_UNDO },
    { "/Edicion/_Redo",                   "<control><shift>Z", edit_redo, 0,"<StockItem>", GTK_STOCK_REDO },
    { "/Edicion/sep2",                    NULL,         menuitem_cb,     0, "<Separator>" },
    { "/Edicion/Corta_r",                 "<control>X", edit_cut,     0, "<StockItem>", GTK_STOCK_CUT },
    { "/Edicion/_Copiar",                 "<control>C", edit_copy,       0, "<StockItem>", GTK_STOCK_COPY },
    { "/Edicion/_Pegar",                  "<control>V", edit_paste,      0, "<StockItem>", GTK_STOCK_PASTE },
    { "/Edicion/sep3",                    NULL,         menuitem_cb,     0, "<Separator>" },
    { "/Edicion/_Buscar...",              "<control>F", edit_find,       0, "<StockItem>", GTK_STOCK_FIND },
    { "/Edicion/B_uscar Siguiente",       "<control>G", edit_find_next,     0, "<StockItem>", GTK_STOCK_FIND },
    { "/Edicion/sep4",                    NULL,         menuitem_cb,     0, "<Separator>" },
    { "/Edicion/_Ir a definicion",        "<control>A", edit_go_to_def,  0, "<StockItem>", GTK_STOCK_JUMP_TO },
    /*    { "/_Preferences",                    NULL,         0,               0, "<Branch>" },
    { "/_Preferences/_Color",             NULL,         0,               0, "<Branch>" },
    { "/_Preferences/Color/_Red",         NULL,         menuitem_cb,     0, "<RadioItem>" },
    { "/_Preferences/Color/_Green",       NULL,         menuitem_cb,     0, "/Preferences/Color/Red" },
    { "/_Preferences/Color/_Blue",        NULL,         menuitem_cb,     0, "/Preferences/Color/Red" },
    { "/_Preferences/_Shape",             NULL,         0,               0, "<Branch>" },
    { "/_Preferences/Shape/_Square",      NULL,         menuitem_cb,     0, "<RadioItem>" },
    { "/_Preferences/Shape/_Rectangle",   NULL,         menuitem_cb,     0, "/Preferences/Shape/Square" },
    { "/_Preferences/Shape/_Oval",        NULL,         menuitem_cb,     0, "/Preferences/Shape/Rectangle" },
    */
};

void
menuitem_cb (gpointer             callback_data,
    guint                callback_action,
    GtkWidget           *widget)
{
    GtkWidget *dialog;
     
    dialog = gtk_message_dialog_new (GTK_WINDOW (callback_data),
        GTK_DIALOG_DESTROY_WITH_PARENT,
        GTK_MESSAGE_INFO,
        GTK_BUTTONS_CLOSE,
        "You selected or toggled the menu item: \"%s\"",
        gtk_item_factory_path_from_widget (widget));
        /* Close dialog on user response */
    g_signal_connect (G_OBJECT (dialog),
        "response",
        G_CALLBACK (gtk_widget_destroy),
        NULL);
    
    gtk_widget_show (dialog);
}

static void
toolbar_cb (GtkWidget *button,
    gpointer   data)
{
    GtkWidget *dialog;
    
    dialog = gtk_message_dialog_new (GTK_WINDOW (data),
        GTK_DIALOG_DESTROY_WITH_PARENT,
        GTK_MESSAGE_INFO,
        GTK_BUTTONS_CLOSE,
        "You selected a toolbar button");
    
        /* Close dialog on user response */
    g_signal_connect (G_OBJECT (dialog),
        "response",
        G_CALLBACK (gtk_widget_destroy),
        NULL);
    
    gtk_widget_show (dialog);
}
 





    /*
    * CloseAppWindow
    *
    * The window is closing down.  Need to shut down gtk.
    */
gint CerrarAplicacion (GtkWidget *widget, gpointer data)
{
    int i;
    
    closing = TRUE;
    for (i = 0; i < max_pages; i ++)
    {
        if (filled [i]== 1)
        {
            gtk_widget_destroy (GTK_WIDGET (gtkcedit [i]));
            gtk_notebook_remove_page (GTK_NOTEBOOK (notebook), virtual_page [i]);
        }
    }

    g_array_free(ArrayPath, TRUE);
    while (gtk_events_pending ())
        gtk_main_iteration ();
    
    gtk_main_quit ();
    
    return FALSE;
}


    /*
    * main - program begins here.
    */
int main (int argc, char *argv [])
{
    int i;
//    GError *err=NULL;
    
    closing = FALSE;
        /* --- GTK initialization --- */
    gtk_init (& argc, & argv);
    
//    if (!gconf_init(&err))
//      {
//	g_print("Error al inicializar GCONF: %s\n", err->message);
//	g_error_free(err);
//	err=NULL;
//	return -1;
//      }
        /* --- Create the top level window --- */
    window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_window_set_title (GTK_WINDOW (window), "Gnome Intelligent C Editor (gICE)");
    
        /* --- You should always remember to connect the delete_event
        to the main window. --- */
    gtk_signal_connect (GTK_OBJECT (window), "delete_event",
        GTK_SIGNAL_FUNC (CerrarAplicacion), NULL);
    
        /* --- Give the window a border --- */
    gtk_container_border_width (GTK_CONTAINER (window), 0);
    gtk_widget_show (window);
    
    
    vbox1 = gtk_vbox_new (FALSE, 0);
    gtk_widget_ref (vbox1);
    gtk_object_set_data_full (GTK_OBJECT (window), "vbox1", vbox1,
        (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (vbox1);
    gtk_container_add (GTK_CONTAINER (window), vbox1);
    
    
        /* Create the menubar */
    accel_group = gtk_accel_group_new ();
    gtk_window_add_accel_group (GTK_WINDOW (window), accel_group);
    g_object_unref (accel_group);
    
    item_factory = gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<main>", accel_group);

        /* Set up item factory to go away with the window */
    /*    g_object_ref (item_factory);
    gtk_object_sink (GTK_OBJECT (item_factory));
    g_object_set_data_full (G_OBJECT (window),
        "<main>",
        item_factory,
        (GDestroyNotify) g_object_unref);
    */
        /* Set up item factory to go away with the window */
    g_object_ref (item_factory);
    gtk_object_sink (GTK_OBJECT (item_factory));
    g_object_set_data_full (G_OBJECT (window),
        "<main>",
        item_factory,
        (GDestroyNotify) g_object_unref);
    
        /* create menu items */
    gtk_item_factory_create_items (item_factory, G_N_ELEMENTS (menu_items),
        menu_items, window);
    
    
        //  gtk_table_attach (GTK_TABLE (table),
        //    gtk_item_factory_get_widget (item_factory, "<main>"),
        /* X direction */          /* Y direction */
        //    0, 1,                      0, 1,
        //    GTK_EXPAND | GTK_FILL,     0,
        //    0,                         0);
    
    gtk_widget_show (gtk_item_factory_get_widget (item_factory, "<main>"));
    gtk_box_pack_start (GTK_BOX (vbox1), gtk_item_factory_get_widget (item_factory, "<main>"), FALSE, FALSE, 0);
    
    
        /* Create the toolbar
        */
    toolbar = gtk_toolbar_new ();
    
    gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar),
        GTK_STOCK_NEW,
        "Nuevo fichero",
        NULL,
        G_CALLBACK (file_new),
        window, /* user data for callback */
        - 1);  /* -1 means "append" */
    
    gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar),
        GTK_STOCK_OPEN,
        "Abrir un fichero",
        NULL,
        G_CALLBACK (file_open),
        window, /* user data for callback */
        - 1);  /* -1 means "append" */
    gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar),
        GTK_STOCK_SAVE,
        "Grabar fichero",
        NULL,
        G_CALLBACK (file_save),
        window, /* user data for callback */
        - 1);  /* -1 means "append" */
    gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar),
        GTK_STOCK_CLOSE,
        "Cerrar fichero",
        NULL,
        G_CALLBACK (file_close),
        window, /* user data for callback */
        - 1);  /* -1 means "append" */
    gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar),
        GTK_STOCK_QUIT,
        "Salir de ICE",
        NULL,
        G_CALLBACK (file_exit),
        window, /* user data for callback */
        - 1);  /* -1 means "append" */
    gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
    button_undo = gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar),
        GTK_STOCK_UNDO,
        "Deshacer",
        NULL,
        G_CALLBACK (edit_undo),
        window, /* user data for callback */
        - 1);  /* -1 means "append" */
    
    button_redo = gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar),
        GTK_STOCK_REDO,
        "Rehacer",
        NULL,
        G_CALLBACK (edit_redo),
        window, /* user data for callback */
        - 1);  /* -1 means "append" */
    gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
    gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar),
        GTK_STOCK_CUT,
        "Cortar",
        NULL,
        G_CALLBACK (edit_cut),
        window, /* user data for callback */
        - 1);  /* -1 means "append" */
    
    gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar),
        GTK_STOCK_COPY,
        "Copiar",
        NULL,
        G_CALLBACK (edit_copy),
        window, /* user data for callback */
        - 1);  /* -1 means "append" */
    gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar),
        GTK_STOCK_PASTE,
        "Pegar",
        NULL,
        G_CALLBACK (edit_paste),
        window, /* user data for callback */
        - 1);  /* -1 means "append" */
    gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
    gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar),
        GTK_STOCK_FIND,
        "Buscar",
        NULL,
        G_CALLBACK (edit_find),
        window, /* user data for callback */
        - 1);  /* -1 means "append" */
    gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar),
        GTK_STOCK_FIND,
        "Buscar siguiente",
        NULL,
        G_CALLBACK (edit_find_next),
        window, /* user data for callback */
        - 1);  /* -1 means "append" */
    
    gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar),
        GTK_STOCK_PREFERENCES,
        "Propiedades",
        NULL,
        G_CALLBACK (file_preferences),
        window, /* user data for callback */
        - 1);  /* -1 means "append" */
        //  gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar),
        //    GTK_STOCK_PASTE,
        //    "test",
        //    NULL,
        //    G_CALLBACK (edit_test),
        //    window, /* user data for callback */
        //    -1);  /* -1 means "append" */
    
    no_have_undo (button_undo, NULL);
    no_have_redo (button_redo, NULL);
    
    
    gtk_toolbar_set_style (GTK_TOOLBAR (toolbar), GTK_TOOLBAR_ICONS);
    gtk_widget_show (toolbar);
    gtk_box_pack_start (GTK_BOX (vbox1), toolbar, FALSE, FALSE, 0);
    
        /*
        * --- creo el bloc de notas
        */
    
    notebook = gtk_notebook_new ();
    gtk_widget_ref (notebook);
    gtk_object_set_data_full (GTK_OBJECT (window), "notebook", notebook,
        (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (notebook);
    
    gtk_signal_connect (GTK_OBJECT (notebook), "switch-page",
        GTK_SIGNAL_FUNC (notebook_select_page), NULL);
    
    gtk_box_pack_start (GTK_BOX (vbox1), notebook, TRUE, TRUE, 0);
    
        //  gtk_container_add(GTK_CONTAINER(notebook), label1);
    
    label [0] = gtk_label_new ("noname.c");
    gtk_widget_ref (label [0]);
        //gtk_object_set_data_full(GTK_OBJECT(window), "label", label[0],
        //   (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (label [0]);
        //  gtk_notebook_set_tab_label(GTK_NOTEBOOK(notebook), gtk_notebook_get_nth_page(GTK_NOTEBOOK (notebook), 0), label[0]);
    
    
        /*
        * --- Creo un gtkcedit
        */
    
    table1 [0] = gtk_table_new (2, 2, FALSE);
    gtk_widget_ref (table1 [0]);
        //  gtk_object_set_data_full(GTK_OBJECT(window), "table1", table1[0],
        //   (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (table1 [0]);
    gtk_container_add (GTK_CONTAINER (notebook), table1 [0]);
        //  gtk_box_pack_start (GTK_BOX (vbox1), table1[0], TRUE, TRUE, 0);
    
    gtkcedit [0] = gtk_cedit_new ();

    gtk_cedit_set_go_to_definition_callback(GTK_CEDIT(gtkcedit[0]), GTK_SIGNAL_FUNC(edit_go_to_def_popup), NULL);
    gtk_signal_connect (GTK_OBJECT (gtkcedit [0]), "have_undo",
			GTK_SIGNAL_FUNC (have_undo), NULL);
    gtk_signal_connect (GTK_OBJECT (gtkcedit [0]), "no_have_undo",
			GTK_SIGNAL_FUNC (no_have_undo), NULL);
    gtk_signal_connect (GTK_OBJECT (gtkcedit [0]), "have_redo",
			GTK_SIGNAL_FUNC (have_redo), NULL);
    gtk_signal_connect (GTK_OBJECT (gtkcedit [0]), "no_have_redo",
			GTK_SIGNAL_FUNC (no_have_redo), NULL);
    
    gtk_widget_show (gtkcedit [0]);
    gtk_table_attach (GTK_TABLE (table1 [0]), gtkcedit [0], 0, 1, 0, 1,
        (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
        (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
    
    hscrollbar [0] = gtk_hscrollbar_new (GTK_ADJUSTMENT (GTK_CEDIT (gtkcedit [0])-> hadj));
    gtk_widget_show (hscrollbar [0]);
    gtk_table_attach (GTK_TABLE (table1 [0]), hscrollbar [0], 0, 1, 1, 2,
        (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
        (GtkAttachOptions) (GTK_FILL), 0, 0);
    
    vscrollbar [0] = gtk_vscrollbar_new (GTK_CEDIT (gtkcedit [0])-> vadj);
    gtk_widget_show (vscrollbar [0]);
    gtk_table_attach (GTK_TABLE (table1 [0]), vscrollbar [0], 1, 2, 0, 1,
        (GtkAttachOptions) (GTK_FILL),
        (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
    
        //gtk_notebook_append_page(GTK_NOTEBOOK(notebook), table1, label);
    gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), 0), label [0]);
    filled [0]= 1;
    virtual_page [0]= gtk_notebook_get_current_page (GTK_NOTEBOOK (notebook));
    strcpy (filename [0],"noname.c");
    
        // parte inferior
    
    hboxbottom = gtk_hbox_new (FALSE, 0);
    gtk_widget_ref (hboxbottom);
    gtk_object_set_data_full (GTK_OBJECT (window), "hboxbottom", hboxbottom,
        (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (hboxbottom);
    gtk_box_pack_start (GTK_BOX (vbox1), hboxbottom, FALSE, FALSE, 0);
    
    
        // barra de estado
    statusbar1 = gtk_statusbar_new ();
    gtk_widget_ref (statusbar1);
    gtk_object_set_data_full (GTK_OBJECT (window), "statusbar1", statusbar1,
        (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (statusbar1);
    gtk_box_pack_start (GTK_BOX (hboxbottom), statusbar1, TRUE, TRUE, 0);
    
        // barra de progreso
    progressbar = gtk_progress_bar_new ();
    gtk_widget_ref (progressbar);
    gtk_object_set_data_full (GTK_OBJECT (window), "progressbar", progressbar,
        (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (progressbar);
    gtk_box_pack_start (GTK_BOX (hboxbottom), progressbar, FALSE, FALSE, 0);
    gtk_cedit_set_progress_bar (GTK_CEDIT (gtkcedit [0]), GTK_PROGRESS_BAR (progressbar));
    gtk_notebook_set_scrollable (GTK_NOTEBOOK (notebook), TRUE);
    
        // icono de la aplicacion
    pixmap = gdk_pixmap_create_from_xpm_d (window-> window, & mask,
        & window-> style-> bg [GTK_STATE_NORMAL], icon_xpm);
    gdk_window_set_icon (window-> window, NULL, pixmap, mask);
    
        // le doy el foco al gtkcedit
    
    gtk_widget_grab_focus (GTK_WIDGET (gtkcedit [0]));
    
    
    for (i = 1; i < max_pages; i ++)
    {
        filled [i]= 0;
        virtual_page [i]=- 1;
        filename [i][0]='\0';
    }
    ArrayPath=NULL;

  // create tree model 
  modelcolores = create_model_colores ();
  /* create model */
  modelpath = create_model_path ();

  lastColor=FALSE;
  lastIdentation=FALSE;
  lastScroll=FALSE;
  lastFormat=TRUE;
  lastContinuousCorrection=FALSE;
  lastCorrection=TRUE;
  
  usar_preferencias(0); // pongo los valores iniciales (colores y path)

  gtk_timeout_add(5000, statusbar_interrupt, NULL);

    gtk_main ();
    
    return 0;
}


