/* genpasswd.c,v 1.10 1998/11/12 22:24:29 kim Exp
 *
 * Generates passwords that are pronouncable (in Finnish).
 * (e.g. will not use 3 consonants in a row, etc.)
 */

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/time.h>
#if defined(hpux) || defined(linux)
# include <crypt.h>
#endif

#define kon     0
#define vok     1
#define koko 1000

#define via    12		/* all characters */
#define kia    62

#define vil     6		/* only lowercase letters */
#define kil    20

#define viu   via		/* lower- and uppercase letters */
#define kiu    40

#define vin   via		/* lowercase, uppercase and numbers */
#define kin    50

int vidx = vil, kidx = kil;
char v[via] =
{'a', 'e', 'i', 'o', 'u', 'y',
 'A', 'E', 'I', 'O', 'U', 'Y'};
char k[kia] =
{'b', 'c', 'd', 'f', 'g', 'h', 'j', 'k', 'l', 'm', 'n',
 'p', 'k', 'r', 's', 't', 'v', 'w', 's', 't',
 'B', 'C', 'D', 'F', 'G', 'H', 'J', 'K', 'L', 'M', 'N',
 'P', 'K', 'R', 'S', 'T', 'V', 'W', 'S', 'T',
 '1', '2', '3', '4', '5', '6', '7', '8', '9', '0',
 '!', '$', '%', '&', '*', '/', '(', ')', '=', '?', '-', '+'};

int sattuma(const int ll, const int ul)
{
  /* Throw away low 16 bits as they are not really that random */
  return (ll + ((lrand48() >> 16) % (ul - ll + 1)));
}

char *gpwd(const int ll, const int ul)
{
  extern char v[], k[];
  extern int vidx, kidx;
  int pituus, sed = vok, ed = kon, tama = 0;
  char *c, *p;

  c = (char *) malloc(koko);
  memset(c, 0, koko);
  p = c;
  pituus = sattuma(ll, ul) - 1;
  do {
    if (ed == kon) {
      tama = vok;
      if ((sed == vok) && pituus)
	tama = sattuma(kon, vok);
    } else {
      if (sed == kon)
	tama = sattuma(kon, vok);
      else
	tama = kon;
    }
    if (tama == kon)
      *p++ = k[sattuma(0, kidx - 1)];
    else
      *p++ = v[sattuma(0, vidx - 1)];
    sed = ed;
    ed = tama;
  } while (pituus--);
  return (c);
}

void usage(const char *me)
{
  fprintf(stderr, "usage: %s [-options ...]\n\n", me);
  fprintf(stderr, "where options include:\n");
  fprintf(stderr, "    -m min-length     (default 6)\n");
  fprintf(stderr, "    -M max-length     (default 9)\n");
  fprintf(stderr, "    -l only lowercase (default)  \n");
  fprintf(stderr, "    -u also uppercase            \n");
  fprintf(stderr, "    -n also numbers              \n");
  fprintf(stderr, "    -a all characters            \n");
  fprintf(stderr, "    -c count          (default 1)\n");
  fprintf(stderr, "    -x encrypted output on stdout\n");
  fprintf(stderr, "          normal output on stderr\n");
  fprintf(stderr, "\n");
  exit(1);
}

int main(int argc, char **argv)
{
  extern int vidx, kidx;
  int larvo = 6, uarvo = 9, count = 1, xcr = 0, c;
  struct timeval t;
  char *xcrp;

  while ((c = getopt(argc, argv, "ac:lm:M:nux")) != EOF)
    switch (c) {
    case 'a':
      vidx = via;
      kidx = kia;
      break;
    case 'c':
      count = atoi(optarg);
      break;
    case 'l':
      vidx = vil;
      kidx = kil;
      break;
    case 'm':
      larvo = atoi(optarg);
      break;
    case 'M':
      uarvo = atoi(optarg);
      break;
    case 'n':
      vidx = vin;
      kidx = kin;
      break;
    case 'u':
      vidx = viu;
      kidx = kiu;
      break;
    case 'x':
      xcr = 1;
      break;
    default:
      usage(argv[0]);
    }

  if (optind < argc)
    usage(argv[0]);

  /* sanity check */
  if (larvo < 1)
    larvo = 1;
  if (uarvo < larvo)
    uarvo = larvo;
  if (count < 1)
    count = 1;

  /*
   * Try generating a seed that has a lot of entropy in all its
   * bits.  tv_usec has about 20 bits of useful randomness.  The
   * lower 16 bits of tv_sec is reasonably random over multiple
   * runs, not too predictable anyway.  Similarly, the lower 8
   * bits of a pid change reasonably quickly -- at worst, if
   * this is the only process on the machine, they are an 8-bit
   * counter.
   */

  gettimeofday(&t, (struct timezone *) NULL);
  srand48(((getpid() & 0xff) << 24)
	  ^ ((t.tv_sec & 0xffff) << 20)
	  ^ t.tv_usec);

  if (xcr == 0) {
    while (count--)
      printf("%s%s", gpwd(larvo, uarvo), count ? " " : "");
  } else {
    xcrp = gpwd(larvo, uarvo);
    printf("%s", crypt(xcrp, gpwd(2, 2)));
    fprintf(stderr, "%s\n", xcrp);
  }
  printf("\n");
  exit(0);
}
