/*
  Simple DirectMedia Layer
  Copyright (C) 1997-2014 Sam Lantinga <slouken@libsdl.org>

  This software is provided 'as-is', without any express or implied
  warranty.  In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

  1. The origin of this software must not be misrepresented; you must not
     claim that you wrote the original software. If you use this software
     in a product, an acknowledgment in the product documentation would be
     appreciated but is not required.
  2. Altered source versions must be plainly marked as such, and must not be
     misrepresented as being the original software.
  3. This notice may not be removed or altered from any source distribution.
*/

#ifndef _SDL_config_iphoneos_h
#define _SDL_config_iphoneos_h

#include "SDL_platform.h"

#ifdef __LP64__
#define SIZEOF_VOIDP 8
#else
#define SIZEOF_VOIDP 4
#endif

#define HAVE_GCC_ATOMICS    1

#define HAVE_ALLOCA_H       1
#define HAVE_SYS_TYPES_H    1
#define HAVE_STDIO_H    1
#define STDC_HEADERS    1
#define HAVE_STRING_H   1
#define HAVE_INTTYPES_H 1
#define HAVE_STDINT_H   1
#define HAVE_CTYPE_H    1
#define HAVE_MATH_H 1
#define HAVE_SIGNAL_H   1

/* C library functions */
#define HAVE_MALLOC 1
#define HAVE_CALLOC 1
#define HAVE_REALLOC    1
#define HAVE_FREE   1
#define HAVE_ALLOCA 1
#define HAVE_GETENV 1
#define HAVE_SETENV 1
#define HAVE_PUTENV 1
#define HAVE_SETENV 1
#define HAVE_UNSETENV   1
#define HAVE_QSORT  1
#define HAVE_ABS    1
#define HAVE_BCOPY  1
#define HAVE_MEMSET 1
#define HAVE_MEMCPY 1
#define HAVE_MEMMOVE    1
#define HAVE_MEMCMP 1
#define HAVE_STRLEN 1
#define HAVE_STRLCPY    1
#define HAVE_STRLCAT    1
#define HAVE_STRDUP 1
#define HAVE_STRCHR 1
#define HAVE_STRRCHR    1
#define HAVE_STRSTR 1
#define HAVE_STRTOL 1
#define HAVE_STRTOUL    1
#define HAVE_STRTOLL    1
#define HAVE_STRTOULL   1
#define HAVE_STRTOD 1
#define HAVE_ATOI   1
#define HAVE_ATOF   1
#define HAVE_STRCMP 1
#define HAVE_STRNCMP    1
#define HAVE_STRCASECMP 1
#define HAVE_STRNCASECMP 1
#define HAVE_VSSCANF 1
#define HAVE_VSNPRINTF  1
#define HAVE_M_PI   1
#define HAVE_ATAN   1
#define HAVE_ATAN2  1
#define HAVE_CEIL   1
#define HAVE_COPYSIGN   1
#define HAVE_COS    1
#define HAVE_COSF   1
#define HAVE_FABS   1
#define HAVE_FLOOR  1
#define HAVE_LOG    1
#define HAVE_POW    1
#define HAVE_SCALBN 1
#define HAVE_SIN    1
#define HAVE_SINF   1
#define HAVE_SQRT   1
#define HAVE_SIGACTION  1
#define HAVE_SETJMP 1
#define HAVE_NANOSLEEP  1
#define HAVE_SYSCONF    1
#define HAVE_SYSCTLBYNAME 1

#ifndef SDL_AUDIO_DRIVER_DUMMY
#define SDL_AUDIO_DRIVER_DUMMY 1
#endif
#ifndef SDL_AUDIO_DRIVER_DISK
#define SDL_AUDIO_DRIVER_DISK 1
#endif
#ifndef SDL_VIDEO_DRIVER_DUMMY
#define SDL_VIDEO_DRIVER_DUMMY 1
#endif
#ifndef SDL_AUDIO_DRIVER_COREAUDIO
#define SDL_AUDIO_DRIVER_COREAUDIO 1
#endif
#ifndef SDL_VIDEO_DRIVER_UIKIT
#define SDL_VIDEO_DRIVER_UIKIT 1
#endif
#ifndef SDL_THREAD_PTHREAD_RECURSIVE_MUTEX
#define SDL_THREAD_PTHREAD_RECURSIVE_MUTEX 1
#endif
#ifndef SDL_FILESYSTEM_COCOA
#define SDL_FILESYSTEM_COCOA 1
#endif
#ifndef SDL_IPHONE_KEYBOARD
#define SDL_IPHONE_KEYBOARD 1
#endif
#ifndef SDL_POWER_UIKIT
#define SDL_POWER_UIKIT 1
#endif
#ifndef SDL_JOYSTICK_DISABLED
#define SDL_JOYSTICK_DISABLED 0
#endif
#ifndef SDL_VIDEO_RENDER_OGL_ES
#define SDL_VIDEO_RENDER_OGL_ES 1
#endif
#ifndef SDL_TIMER_UNIX
#define SDL_TIMER_UNIX 1
#endif
#ifndef SDL_VIDEO_OPENGL_ES
#define SDL_VIDEO_OPENGL_ES 1
#endif
#ifndef SDL_THREAD_PTHREAD
#define SDL_THREAD_PTHREAD 1
#endif
#ifndef SDL_VIDEO_RENDER_OGL_ES2
#define SDL_VIDEO_RENDER_OGL_ES2 1
#endif
#ifndef SDL_LOADSO_DISABLED
#define SDL_LOADSO_DISABLED 1
#endif
#ifndef SDL_HAPTIC_DISABLED
#define SDL_HAPTIC_DISABLED 1
#endif

/* Set max recognized G-force from accelerometer
   See src/joystick/uikit/SDLUIAccelerationDelegate.m for notes on why this is needed
 */
#define SDL_IPHONE_MAX_GFORCE 5.0

#endif /* _SDL_config_iphoneos_h */
