/*
    parse.c

    Jonathan B. Leffert <jonathan@leffert.net>
    10 May 2000

    $Id: parse.c,v 1.3 2000/05/11 20:35:13 jonathan Exp $
    
    Copyright (c) 2000 Jonathan B. Leffert <jonathan@leffert.net>
    All rights reserved.
*/

#include "parse.h"

/* returns the string a_string unescaped---i.e., \t is made into a
   literal */
char *unescape_string(char *a_string)
{
  char *s;
  char c;
  char c_prime;
  int i;
  int j;

  if ( a_string == NULL )
    {
      return NULL;
    }
  else
    {
      s = calloc( strlen(a_string) + 1, sizeof(char) );
      if ( s == NULL )
	{
	  /* memory allocation error of some sorts */
	  return NULL;
	}
    }

  /* memory for s has been allocated successfully and a_string is
     non-null */
  for ( i = 0, j = 0; i <= strlen(a_string); i++ )
    {
      c = a_string[i];
      if ( c != '\\' )
	{
	  /* just copy the character */
	  s[j] = c;
	  j++;
	}
      else
	{
	  if ( i < strlen(a_string) )
	    {
	      /* backslash does not occur at last spot in string (last
		 spot before the \0, thit is) */
	      /* so, check the next character for the escape code */
	      c_prime = a_string[i+1];
	      switch (c_prime)
		{
		case 't':
		  /* tab */
		  s[j] = '\t';
		  break;
		case 'n':
		  /* newline */
		  s[j] = '\n';
		  break;
		case '\\':
		  /* backslash */
		  s[j] = '\\';
		  break;
		case 'r':
		  /* carriage return */
		  s[j] = '\r';
		  break;
		case 'v':
		  /* vertical tab */
		  s[j] = '\v';
		  break;
		default:
		  /* copy them both over */
		  s[j] = '\\';
		  s[j+1] = c_prime;
		  j++;
		  break;
		}
	      /* really need i=i+2, but the other i++ will be caught
		 on the for loop */
	      i++;
	      j++;
	    }
	  else
	    {
	      /* just copy the backslash through for now */

	      /* !!!! THIS NEEDS TO BE RETHOUGHT */
	      s[j] = c;
	      j++;
	    }
	}
    }
  return s;
}

