/*
  gdbm-remove.c
  
  Jonathan B. Leffert <jonathan@leffert.net>
  24 April 2000
  
  $Id: gdbm-remove.c,v 1.17 2000/05/16 23:35:07 jonathan Exp $
  
  Copyright (c) 2000 Jonathan B. Leffert <jonathan@leffert.net>
  All rights reserved.
*/

#include "common.h"

/* prototypes */
void parse_args(int *, char ***, char **);
void usage(char *);

/* function defs */

void parse_args(int *argc, char ***argv, char **dbName)
{
  char *options = "d:hv";
  int c;

  while ( (c = getopt(*argc, *argv, options)) != EOF )
    {
      switch (c)
	{
	case 'd':
	  /* database name */
	  *dbName = optarg;
	  break;
	case 'h':
	  /* request help */
	  usage((*argv)[0]);
	  exit(0);
	  break;
	case 'v':
	  /* version information */
	  printf("Version %f\n", VERSION);
	  exit(0);
	  break;
	case '?':
	  /* unknown option */
	  usage((*argv)[0]);
	  exit(1);
	  break;
	default:
	  /* default: do nothing */
	  break;
	}
    }
}

void usage(char *program_name)
{
  printf("Usage:\n");
  printf("\n");
  printf("%s [-hv] [-d DB] key(s)\n", program_name);
  printf("\n");
  printf("-d DB = Use database with specified name.\n");
  printf("        Must be supplied.\n");
  printf("-h    = This help message\n");
  printf("-v    = Prints version information.\n");
  printf("\n");
  printf("This program removes the given keys from the given database.\n");
  printf("\n");
  printf("Error Codes:\n");
  printf("  0 on success\n");
  printf("  1 on non-database failure\n");
  printf("  2 on database failure\n");
}

int main(int argc, char **argv)
{
  char *name = NULL;
  GDBM_FILE db = NULL;
  datum key;
  int i;
  int returnValue = 0;
  
  parse_args(&argc, &argv, &name);

  if ( name == NULL )
    {
      /* -d was not specified */
      usage(argv[0]);
      exit(1);
    }

  /* open the database read write */
  db = open_gdbm_database_rw(name);
  
  if ( db != NULL )
    {
      for ( i = optind; i < argc; i++ )
	{
	  /* build the key object */
	  key.dptr = argv[i];
	  key.dsize = (strlen(key.dptr) + 1) * sizeof(char);

	  if ( gdbm_delete(db, key) == -1 )
	    {
	      /* key not present or db read only */
	      returnValue = 1;
	    }
	}
      /* close the database */
      gdbm_close(db);
    }
  else
    {
      /* error occured */
      perror(argv[0]);
      exit(2);
    }
  
  return returnValue;
}
