/*
  fileio.c
  
  Jonathan B. Leffert <jonathan@leffert.net>
  28 April 2000
  
  $Id: fileio.c,v 1.10 2000/05/15 21:37:37 jonathan Exp $
  
  Copyright (c) 2000 Jonathan B. Leffert <jonathan@leffert.net>
  All rights reserved.

  This file contains the implementation for a simple line-at-a-time
  file reader.
*/

#include "fileio.h"

/*
  Returns the next whole line in file minus the trailing newline.
  NULL is returned on error. The line may be of arbitrary length.  The
  returned pointer is allocated via calloc(3) and must be freed by the
  user.
*/
char *readline(FILE *file)
{
  char *s = NULL;
  char *t = NULL;
  unsigned int size = INITIAL_SIZE;
  unsigned int used = 0;
  int i;
  int c;

  if ( file != NULL )
    {
      /* allocate some space */
      s = calloc(size, sizeof(char));
      while ( (c = fgetc(file)) != EOF )
	{
	  if ( (c == '\n') || (c == '\r') )
	    {
	      /* end of line encountered.  return */
	      return s;
	    }
	  else
	    {
	      if ( s != NULL )
		{
		  if ( used >= size - 2 )
		    {
		      /* we've filled up the current allocation
			 space. double the allocation size, copy the
			 old data over and continue */
		      size = size * MULT_FACTOR;
		      t = calloc(size, sizeof(char));
		      for ( i = 0; i < used; i++ )
			{
			  /* copy array contents */
			  t[i] = s[i];
			}
		      /* free the old memory */
		      free(s);
		      /* realign pointers */
		      s = t;
		      t = NULL;
		    }
		  /* insert the character in the array */
		  s[used] = c;
		  used++;
		}
	    }
	}
    }
  return NULL;
}
